/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModelException;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.model.EORelationship;

public class NewManyToManyRelationshipOperation
extends AbstractOperation {
    private EOEntity _sourceEntity;
    private String _name;
    private boolean _createRelationship;
    private EOEntity _destinationEntity;
    private String _inverseName;
    private boolean _createInverseRelationship;
    private String _joinEntityName;
    private boolean _flatten;
    private EOEntity _joinEntity;

    public NewManyToManyRelationshipOperation(EOEntity sourceEntity, EOEntity destinationEntity, boolean createRelationship, String name, boolean createInverseRelationship, String inverseName, String joinEntityName, boolean flatten) {
        super("Add Relationship");
        this._sourceEntity = sourceEntity;
        this._destinationEntity = destinationEntity;
        this._createRelationship = createRelationship;
        this._name = name;
        this._createInverseRelationship = createInverseRelationship;
        this._inverseName = inverseName;
        this._joinEntityName = joinEntityName;
        this._flatten = flatten;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            this._joinEntity = this._sourceEntity.joinInManyToManyWith(this._destinationEntity, this._createRelationship, this._name, this._createInverseRelationship, this._inverseName, this._joinEntityName, this._flatten);
            return Status.OK_STATUS;
        }
        catch (EOModelException e) {
            throw new ExecutionException("Failed to add new object.", (Throwable)e);
        }
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        HashSet<EOModelVerificationFailure> failures = new HashSet<EOModelVerificationFailure>();
        Set<EORelationship> referencingRelationships = this._joinEntity.getReferencingRelationships();
        for (EORelationship relationship : referencingRelationships) {
            if (relationship.isFlattened()) continue;
            if (this._flatten) {
                for (EORelationship flattenedRelationship : relationship.getReferencingFlattenedRelationships()) {
                    flattenedRelationship._removeFromModelParent(failures);
                }
            }
            relationship._removeFromModelParent(failures);
        }
        this._joinEntity._removeFromModelParent(failures);
        return Status.OK_STATUS;
    }
}

