/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.actions;

import java.util.HashSet;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.objectstyle.wolips.eomodeler.core.model.EOAttribute;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOJoin;
import org.objectstyle.wolips.eomodeler.core.model.EOModelException;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.model.EORelationship;

public class NewOneToManyRelationshipOperation
extends AbstractOperation {
    private EORelationship _relationship;
    private EOEntity _sourceEntity;
    private String _name;
    private boolean _createRelationship;
    private boolean _toMany;
    private boolean _createFK;
    private EOAttribute _foreignKey;
    private String _fkName;
    private String _fkColumnName;
    private EORelationship _inverseRelationship;
    private EOEntity _destinationEntity;
    private EOAttribute _inverseForeignKey;
    private String _inverseName;
    private boolean _createInverseRelationship;
    private boolean _inverseToMany;
    private boolean _createInverseFK;
    private String _inverseFKName;
    private String _inverseFKColumnName;

    public NewOneToManyRelationshipOperation(EORelationship relationship, EOEntity sourceEntity, String name, boolean createRelationship, boolean toMany, boolean createFK, String fkName, String fkColumnName, EOEntity destinationEntity, String inverseName, boolean createInverseRelationship, boolean inverseToMany, boolean createInverseFK, String inverseFKName, String inverseFKColumnName) {
        super("Add Relationship");
        this._relationship = relationship;
        this._sourceEntity = sourceEntity;
        this._name = name;
        this._createRelationship = createRelationship;
        this._toMany = toMany;
        this._createFK = createFK;
        this._fkName = fkName;
        this._fkColumnName = fkColumnName;
        this._destinationEntity = destinationEntity;
        this._inverseName = inverseName;
        this._createInverseRelationship = createInverseRelationship;
        this._inverseToMany = inverseToMany;
        this._createInverseFK = createInverseFK;
        this._inverseFKName = inverseFKName;
        this._inverseFKColumnName = inverseFKColumnName;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            EOJoin newJoin = null;
            if (this._createFK) {
                this._foreignKey = this._sourceEntity.createForeignKeyTo(this._destinationEntity, this._fkName, this._fkColumnName, false);
                newJoin = new EOJoin();
                newJoin.setSourceAttribute(this._foreignKey);
                newJoin.setDestinationAttribute(this._destinationEntity.getSinglePrimaryKeyAttribute());
            }
            if (this._createInverseFK) {
                this._inverseForeignKey = this._destinationEntity.createForeignKeyTo(this._sourceEntity, this._inverseFKName, this._inverseFKColumnName, false);
                newJoin = new EOJoin();
                newJoin.setSourceAttribute(this._sourceEntity.getSinglePrimaryKeyAttribute());
                newJoin.setDestinationAttribute(this._inverseForeignKey);
            }
            if (newJoin != null) {
                this._relationship.removeAllJoins();
                this._relationship.addJoin(newJoin);
            }
            if (this._createRelationship) {
                this._relationship.setName(this._name);
                this._relationship.setToMany(this._toMany);
                this._relationship.setMandatoryIfNecessary();
                this._sourceEntity.addRelationship(this._relationship);
            }
            if (this._createInverseRelationship) {
                this._inverseRelationship = this._relationship.createInverseRelationshipNamed(this._inverseName, this._inverseToMany);
                this._inverseRelationship.setMandatoryIfNecessary();
                this._inverseRelationship.getEntity().addRelationship(this._inverseRelationship);
            }
            return Status.OK_STATUS;
        }
        catch (EOModelException e) {
            throw new ExecutionException("Failed to add new object.", (Throwable)e);
        }
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        HashSet<EOModelVerificationFailure> failures = new HashSet<EOModelVerificationFailure>();
        if (this._createRelationship) {
            this._relationship._removeFromModelParent(failures);
        }
        if (this._createInverseRelationship) {
            this._inverseRelationship._removeFromModelParent(failures);
        }
        if (this._createFK) {
            this._foreignKey._removeFromModelParent(failures);
        }
        if (this._createInverseFK) {
            this._inverseForeignKey._removeFromModelParent(failures);
        }
        return Status.OK_STATUS;
    }
}

