/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.entity;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.objectstyle.wolips.eomodeler.core.kvc.KVCComparator;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.utils.EOModelUtils;

public class EOEntityListContentProvider
implements IStructuredContentProvider {
    public static final Object BLANK_ENTITY = "";
    private boolean _allowBlank;
    private boolean _restrictToSingleModel;
    private boolean _includePrototypes;
    private KVCComparator _comparator;

    public EOEntityListContentProvider(boolean allowBlank, boolean restrictToSingleModel, boolean includePrototypes) {
        this._allowBlank = allowBlank;
        this._restrictToSingleModel = restrictToSingleModel;
        this._includePrototypes = includePrototypes;
        this._comparator = new KVCComparator<EOEntity>(EOEntity.class, "name");
    }

    public Object[] getElements(Object inputElement) {
        Set<EOEntity> entitiesList;
        EOModel model = EOModelUtils.getRelatedModel(inputElement);
        if (model != null) {
            entitiesList = this._restrictToSingleModel ? (this._includePrototypes ? model.getEntities() : model.getNonPrototypeEntities()) : (this._includePrototypes ? model.getModelGroup().getEntities() : model.getModelGroup().getNonPrototypeEntities());
        } else {
            throw new IllegalArgumentException("Unknown input element: " + inputElement);
        }
        LinkedList<Object> entitiesListCopy = new LinkedList<Object>();
        entitiesListCopy.addAll(entitiesList);
        Collections.sort(entitiesListCopy, this._comparator);
        if (this._allowBlank) {
            entitiesListCopy.add(0, BLANK_ENTITY);
        }
        Object[] entities = entitiesListCopy.toArray();
        return entities;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer _viewer, Object _oldInput, Object _newInput) {
    }
}

