/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.editors.patterset;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.objectstyle.wolips.core.resources.pattern.PatternsetReader;
import org.objectstyle.wolips.core.resources.pattern.PatternsetWriter;
import org.objectstyle.wolips.editors.EditorsPlugin;
import org.objectstyle.wolips.editors.patterset.PatternsetPage;
import org.objectstyle.wolips.ui.actions.TouchAllFilesOperation;

public class PatternsetEditor
extends FormEditor {
    private ArrayList patternList;
    private boolean isDirty = false;

    public void close(boolean save) {
        super.close(save);
    }

    IFile getInputFile() {
        IEditorInput editorInput = this.getEditorInput();
        return ((IFileEditorInput)editorInput).getFile();
    }

    void loadPatternList() {
        PatternsetReader patternsetReader = new PatternsetReader(this.getInputFile());
        String[] pattern = patternsetReader.getPattern();
        this.patternList = new ArrayList();
        for (int i = 0; i < pattern.length; ++i) {
            this.patternList.add(pattern[i]);
        }
    }

    protected void addPages() {
        this.loadPatternList();
        try {
            this.addPage((IFormPage)new PatternsetPage(this, this.patternList));
        }
        catch (PartInitException e) {
            EditorsPlugin.getDefault().log(e);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        IEditorInput editorInput = this.getEditorInput();
        IFile inputFile = ((IFileEditorInput)editorInput).getFile();
        String[] pattern = this.patternList.toArray(new String[this.patternList.size()]);
        PatternsetWriter.create((IFile)inputFile, (String[])pattern);
        this.setDirty(false);
        TouchAllFilesOperation touchAllFilesOperation = new TouchAllFilesOperation(inputFile.getProject());
        try {
            touchAllFilesOperation.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        this.firePropertyChange(257);
    }
}

