/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.action;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.objectstyle.wolips.bindings.api.ApiModel;
import org.objectstyle.wolips.bindings.api.Wo;
import org.objectstyle.wolips.bindings.utils.BindingReflectionUtils;
import org.objectstyle.wolips.bindings.wod.BindingValueKey;
import org.objectstyle.wolips.bindings.wod.TypeCache;
import org.objectstyle.wolips.wodclipse.WodclipsePlugin;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;

public class GenerateAPIAction
implements IObjectActionDelegate {
    private ISelection _selection;

    public void dispose() {
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this._selection = selection;
    }

    public void run() {
        try {
            if (this._selection instanceof IStructuredSelection) {
                Object[] selectedObjects = ((IStructuredSelection)this._selection).toArray();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    IResource resource = (IResource)selectedObjects[i];
                    WodParserCache cache = WodParserCache.parser(resource);
                    List bindingKeys = BindingReflectionUtils.getBindingKeys((IJavaProject)cache.getJavaProject(), (IType)cache.getComponentType(), (String)"", (boolean)false, (int)1, (boolean)false, (TypeCache)WodParserCache.getTypeCache());
                    IFile apiFile = cache.getApiFile();
                    ApiModel apiModel = new ApiModel(apiFile);
                    Wo wo = apiModel.getWo();
                    for (BindingValueKey binding : bindingKeys) {
                        if (BindingReflectionUtils.isSystemBindingValueKey((BindingValueKey)binding, (boolean)true)) continue;
                        String bindingName = binding.getBindingName();
                        wo.createBinding(bindingName);
                    }
                    apiModel.saveChanges();
                }
            }
        }
        catch (Exception e) {
            WodclipsePlugin.getDefault().log(e);
        }
    }
}

