/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.objectstyle.wolips.bindings.wod.IWodBinding;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.refactoring.TemplateRefactoring;
import org.objectstyle.wolips.wodclipse.core.util.WodDocumentUtils;

public class ChangeBindingNameRefactoring
implements IRunnableWithProgress {
    private IWodElement _element;
    private IWodBinding _binding;
    private String _newName;
    private WodParserCache _cache;

    public ChangeBindingNameRefactoring(String newName, IWodElement element, IWodBinding binding, WodParserCache cache) {
        this._newName = newName;
        this._element = element;
        this._binding = binding;
        this._cache = cache;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        try {
            Position namePosition = this._binding.getNamePosition();
            if (this._element.isInline()) {
                IDocument htmlDocument = this._cache.getHtmlEntry().getDocument();
                if (htmlDocument != null) {
                    LinkedList<TextEdit> htmlEdits = new LinkedList<TextEdit>();
                    htmlEdits.add((TextEdit)new ReplaceEdit(namePosition.getOffset(), namePosition.getLength(), this._newName));
                    WodDocumentUtils.applyEdits(htmlDocument, htmlEdits);
                }
            } else {
                IDocument wodDocument = this._cache.getWodEntry().getDocument();
                if (wodDocument != null) {
                    LinkedList<TextEdit> wodEdits = new LinkedList<TextEdit>();
                    wodEdits.add((TextEdit)new ReplaceEdit(namePosition.getOffset(), namePosition.getLength(), this._newName));
                    WodDocumentUtils.applyEdits(wodDocument, wodEdits);
                }
            }
        }
        catch (Exception e) {
            throw new InvocationTargetException(e, "Failed to refactor.");
        }
    }

    public static void run(String newName, IWodElement element, IWodBinding binding, WodParserCache cache, IProgressMonitor progressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
        TemplateRefactoring.processHtmlAndWod(new ChangeBindingNameRefactoring(newName, element, binding, cache), cache, progressMonitor);
    }
}

