/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.refactoring;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.objectstyle.wolips.baseforplugins.util.StringUtils;
import org.objectstyle.wolips.bindings.wod.IWodBinding;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.bindings.wod.SimpleWodBinding;
import org.objectstyle.wolips.bindings.wod.SimpleWodElement;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.refactoring.ChangeElementTypeRefactoring;
import org.objectstyle.wolips.wodclipse.core.refactoring.RefactoringWodBinding;
import org.objectstyle.wolips.wodclipse.core.refactoring.RemoveBindingRefactoring;
import org.objectstyle.wolips.wodclipse.core.refactoring.RenameElementsRefactoring;

public class RefactoringWodElement {
    public static final String ELEMENT_NAME = "elementName";
    public static final String ELEMENT_TYPE = "elementType";
    private PropertyChangeSupport _propertyChange;
    private SimpleWodElement _wodElement;
    private WodParserCache _cache;

    public RefactoringWodElement(IWodElement element, WodParserCache cache) {
        this._cache = cache;
        this._wodElement = new SimpleWodElement(element);
        this._propertyChange = new PropertyChangeSupport(this);
    }

    public SimpleWodElement getWodElement() {
        return this._wodElement;
    }

    public RefactoringWodBinding setValueForBinding(String value, String name) throws CoreException, InvocationTargetException, InterruptedException {
        RefactoringWodBinding wodBinding = null;
        if (value == null || value.trim().length() == 0) {
            this.removeBindingNamed(name);
        } else {
            wodBinding = this.getBindingNamed(name);
            if (wodBinding != null) {
                wodBinding.setValue(value);
            } else {
                wodBinding = this.addBindingValueNamed(value, null, name);
            }
        }
        return wodBinding;
    }

    public void removeBindingNamed(String name) throws CoreException, InvocationTargetException, InterruptedException {
        IWodBinding existingBinding = this._wodElement.getBindingNamed(name);
        if (existingBinding != null) {
            RemoveBindingRefactoring.run((IWodElement)this._wodElement, existingBinding, this._cache, (IProgressMonitor)new NullProgressMonitor());
            this._wodElement.removeBinding(existingBinding);
        }
    }

    public RefactoringWodBinding addBindingValueNamed(String value, String namespace, String name) throws CoreException, InvocationTargetException, InterruptedException {
        SimpleWodBinding binding = new SimpleWodBinding(namespace, name, value);
        this._wodElement.addBinding((IWodBinding)binding);
        RefactoringWodBinding refactoringBinding = new RefactoringWodBinding((IWodElement)this._wodElement, (IWodBinding)binding, this._cache);
        refactoringBinding._setValue(value);
        return refactoringBinding;
    }

    public RefactoringWodBinding getBindingNamed(String name) {
        IWodBinding binding = this._wodElement.getBindingNamed(name);
        RefactoringWodBinding refactoringBinding = null;
        if (binding != null) {
            refactoringBinding = new RefactoringWodBinding((IWodElement)this._wodElement, binding, this._cache);
        }
        return refactoringBinding;
    }

    public void setElementName(String elementName) throws CoreException, InvocationTargetException, InterruptedException {
        String oldElementName = this._wodElement.getElementName();
        if (!this._wodElement.isInline()) {
            RenameElementsRefactoring.run(oldElementName, elementName, this._cache, (IProgressMonitor)new NullProgressMonitor());
        }
        this._wodElement.setElementName(elementName);
        this._propertyChange.firePropertyChange(ELEMENT_NAME, oldElementName, elementName);
    }

    public String getElementName() {
        return this._wodElement.getElementName();
    }

    public void setElementType(String elementType) throws CoreException, InvocationTargetException, InterruptedException {
        String oldElementType = this._wodElement.getElementType();
        ChangeElementTypeRefactoring.run(elementType, (IWodElement)this._wodElement, this._cache, (IProgressMonitor)new NullProgressMonitor());
        this._wodElement.setElementType(elementType);
        this._propertyChange.firePropertyChange(ELEMENT_TYPE, oldElementType, elementType);
    }

    public String getElementType() {
        return this._wodElement.getElementType();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._propertyChange.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this._propertyChange.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._propertyChange.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this._propertyChange.removePropertyChangeListener(propertyName, listener);
    }

    public static String findUnusedBindingName(IWodElement element, String baseName) {
        return StringUtils.findUnusedName((String)"newBinding", (Object)element, (String)"getBindingNamed");
    }
}

