/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.apieditor.editor;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.objectstyle.wolips.bindings.api.ApiModel;
import org.objectstyle.wolips.bindings.api.Binding;
import org.objectstyle.wolips.bindings.api.IApiBinding;

public class BindingDetailsPage
implements IDetailsPage {
    IManagedForm managedForm;
    TableViewer viewer;
    Binding binding;
    Text name;
    Button requiredFlag;
    Button willSetFlag;
    Combo valueSetCombo;
    ApiModel apiModel;

    public void initialize(IManagedForm form) {
        this.managedForm = form;
    }

    public void createContents(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 5;
        layout.leftMargin = 5;
        layout.rightMargin = 2;
        layout.bottomMargin = 2;
        parent.setLayout((Layout)layout);
        FormToolkit toolkit = this.managedForm.getToolkit();
        Section s1 = toolkit.createSection(parent, 256);
        s1.marginWidth = 10;
        s1.setText("Binding Details");
        s1.setDescription("Set the properties of the selected binding.");
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        s1.setLayoutData((Object)td);
        Composite client = toolkit.createComposite((Composite)s1);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.numColumns = 2;
        client.setLayout((Layout)glayout);
        SelectionAdapter choiceListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BindingDetailsPage.this.binding != null) {
                    int selectedIndex = ((Combo)e.widget).getSelectionIndex();
                    BindingDetailsPage.this.binding.setDefaults(selectedIndex);
                    BindingDetailsPage.this.managedForm.dirtyStateChanged();
                }
            }
        };
        toolkit.createLabel(client, "Name:");
        this.name = toolkit.createText(client, "", 4);
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BindingDetailsPage.this.binding != null) {
                    try {
                        BindingDetailsPage.this.binding.setName(BindingDetailsPage.this.name.getText());
                    }
                    catch (Throwable t) {
                        BindingDetailsPage.this.binding.setName(BindingDetailsPage.this.name.getText() + System.currentTimeMillis());
                    }
                    BindingDetailsPage.this.managedForm.dirtyStateChanged();
                }
            }
        });
        GridData gd = new GridData(770);
        gd.widthHint = 10;
        this.name.setLayoutData((Object)gd);
        toolkit.createLabel(client, "Value Set:");
        this.valueSetCombo = new Combo(client, 8);
        this.valueSetCombo.setLayoutData((Object)new GridData(768));
        for (int i = 0; i < IApiBinding.ALL_DEFAULTS.length; ++i) {
            this.valueSetCombo.add(IApiBinding.ALL_DEFAULTS[i]);
        }
        this.valueSetCombo.addSelectionListener((SelectionListener)choiceListener);
        this.createSpacer(toolkit, client, 2);
        this.requiredFlag = toolkit.createButton(client, "Required", 32);
        this.requiredFlag.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BindingDetailsPage.this.binding != null) {
                    BindingDetailsPage.this.binding.setIsRequired(BindingDetailsPage.this.requiredFlag.getSelection());
                    BindingDetailsPage.this.managedForm.dirtyStateChanged();
                }
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.requiredFlag.setLayoutData((Object)gd);
        this.willSetFlag = toolkit.createButton(client, "Will Set", 32);
        this.willSetFlag.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BindingDetailsPage.this.binding != null) {
                    BindingDetailsPage.this.binding.setIsWillSet(BindingDetailsPage.this.willSetFlag.getSelection());
                    BindingDetailsPage.this.managedForm.dirtyStateChanged();
                }
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.willSetFlag.setLayoutData((Object)gd);
        this.createSpacer(toolkit, client, 2);
        toolkit.paintBordersFor((Composite)s1);
        s1.setClient((Control)client);
    }

    private void createSpacer(FormToolkit toolkit, Composite parent, int span) {
        Label spacer = toolkit.createLabel(parent, "");
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        spacer.setLayoutData((Object)gd);
    }

    private void update() {
        int selectedDefaults = this.binding.getSelectedDefaults();
        this.valueSetCombo.select(selectedDefaults);
        this.requiredFlag.setSelection(this.binding != null && this.binding.isRequired());
        this.willSetFlag.setSelection(this.binding != null && this.binding.isWillSet());
        this.name.setText(this.binding != null && this.binding.getName() != null ? this.binding.getName() : "");
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        this.binding = ssel.size() == 1 ? (Binding)ssel.getFirstElement() : null;
        this.update();
    }

    public void commit(boolean onSave) {
    }

    public void setFocus() {
        this.name.setFocus();
    }

    public void dispose() {
    }

    public boolean isDirty() {
        if (this.binding == null) {
            return false;
        }
        return this.binding.apiModel.isDirty();
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
        this.update();
    }

    public boolean setFormInput(Object input) {
        return false;
    }
}

