/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.entity;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.objectstyle.wolips.eomodeler.core.kvc.KVCComparator;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.utils.EOModelUtils;

public class EOPrototypeEntityListContentProvider
implements IStructuredContentProvider {
    public static final Object BLANK_ENTITY = "";
    private boolean myAllowBlank;
    private KVCComparator myComparator;

    public EOPrototypeEntityListContentProvider(boolean _allowBlank) {
        this.myAllowBlank = _allowBlank;
        this.myComparator = new KVCComparator<EOEntity>(EOEntity.class, "name");
    }

    public Object[] getElements(Object _inputElement) {
        EOModel model = EOModelUtils.getRelatedModel(_inputElement);
        if (model == null) {
            throw new IllegalArgumentException("Unknown input element: " + _inputElement);
        }
        Set<EOEntity> entitiesList = model.getModelGroup().getPrototypeEntities();
        LinkedList<Object> entitiesListCopy = new LinkedList<Object>();
        entitiesListCopy.addAll(entitiesList);
        Collections.sort(entitiesListCopy, this.myComparator);
        if (this.myAllowBlank) {
            entitiesListCopy.add(0, BLANK_ENTITY);
        }
        Object[] entities = entitiesListCopy.toArray();
        return entities;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer _viewer, Object _oldInput, Object _newInput) {
    }
}

