/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.factories;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.objectstyle.woenvironment.plist.ParserDataStructureFactory;
import org.objectstyle.woenvironment.plist.PropertyListParserException;
import org.objectstyle.woenvironment.plist.SimpleParserDataStructureFactory;
import org.objectstyle.woenvironment.plist.WOLPropertyListSerialization;
import org.objectstyle.wolips.baseforplugins.util.StringUtils;
import org.objectstyle.wolips.eomodeler.core.model.AbstractManifestEOModelGroupFactory;
import org.objectstyle.wolips.eomodeler.core.model.ManifestSearchFolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class IDEAProjectEOModelGroupFactory
extends AbstractManifestEOModelGroupFactory {
    @Override
    public List<ManifestSearchFolder> getSearchFolders(File selectedModelFolder) throws IOException {
        LinkedHashSet<ManifestSearchFolder> searchFolders = null;
        LinkedHashSet<File> ideaProjectFiles = new LinkedHashSet<File>();
        try {
            IDEAProjectEOModelGroupFactory.findIdeaProjectFilesInFolder(selectedModelFolder, ideaProjectFiles);
        }
        catch (PropertyListParserException e) {
            e.printStackTrace();
            throw new IOException("Failed to parse '.EntityModeler.plist'. " + StringUtils.getErrorMessage((Throwable)e));
        }
        if (!ideaProjectFiles.isEmpty()) {
            searchFolders = new LinkedHashSet<ManifestSearchFolder>();
            for (File ideaProjectFile : ideaProjectFiles) {
                HashMap<String, File> ideaLibraries = new HashMap<String, File>();
                String ideaProjectPath = ideaProjectFile.getParentFile().getAbsolutePath();
                HashSet<File> visitedModulePaths = new HashSet<File>();
                try {
                    XPathExpression ideaLibrariesExpression = XPathFactory.newInstance().newXPath().compile("project/component[@name='libraryTable']/library");
                    XPathExpression ideaModulesExpression = XPathFactory.newInstance().newXPath().compile("project/component[@name='ProjectModuleManager']/modules/module");
                    XPathExpression ideaClassesRootExpression = XPathFactory.newInstance().newXPath().compile("CLASSES/root");
                    Document ideaProjectDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(ideaProjectFile);
                    NodeList ideaLibraryNodes = (NodeList)ideaLibrariesExpression.evaluate(ideaProjectDocument, XPathConstants.NODESET);
                    block5: for (int ideaLibraryNum = 0; ideaLibraryNum < ideaLibraryNodes.getLength(); ++ideaLibraryNum) {
                        Element ideaLibraryElement = (Element)ideaLibraryNodes.item(ideaLibraryNum);
                        String libraryName = ideaLibraryElement.getAttribute("name");
                        NodeList rootNodes = (NodeList)ideaClassesRootExpression.evaluate(ideaLibraryElement, XPathConstants.NODESET);
                        for (int rootNodeNum = 0; rootNodeNum < rootNodes.getLength(); ++rootNodeNum) {
                            Element rootNodeElement = (Element)rootNodes.item(rootNodeNum);
                            String rootPath = rootNodeElement.getAttribute("url");
                            if (!rootPath.contains(".framework/Resources")) continue;
                            rootPath = rootPath.replaceAll("^[^:]+://", "");
                            rootPath = rootPath.replaceAll("\\$PROJECT_DIR\\$", ideaProjectPath);
                            rootPath = rootPath.replaceAll("(.*\\.framework/Resources).*", "$1");
                            ideaLibraries.put(libraryName, new File(rootPath).getCanonicalFile());
                            continue block5;
                        }
                    }
                    NodeList ideaModuleNodes = (NodeList)ideaModulesExpression.evaluate(ideaProjectDocument, XPathConstants.NODESET);
                    for (int ideaModuleNum = 0; ideaModuleNum < ideaModuleNodes.getLength(); ++ideaModuleNum) {
                        Element ideaModuleElement = (Element)ideaModuleNodes.item(ideaModuleNum);
                        String ideaModulePath = ideaModuleElement.getAttribute("filepath");
                        ideaModulePath = ideaModulePath.replaceAll("\\$PROJECT_DIR\\$", ideaProjectPath);
                        File ideaModuleFile = new File(ideaModulePath).getCanonicalFile();
                        this.processIdeaModuleFile(ideaModuleFile, searchFolders, ideaLibraries, visitedModulePaths);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return searchFolders == null ? null : new LinkedList(searchFolders);
    }

    protected void processIdeaModuleFile(File ideaModuleFile, Set<ManifestSearchFolder> searchFolders, Map<String, File> ideaLibraries, Set<File> visitedModulePaths) throws IOException, XPathExpressionException, SAXException, ParserConfigurationException {
        if (!ideaModuleFile.exists()) {
            return;
        }
        if (visitedModulePaths.contains(ideaModuleFile)) {
            return;
        }
        visitedModulePaths.add(ideaModuleFile);
        String ideaProjectPath = ideaModuleFile.getParentFile().getAbsolutePath();
        Document ideaModuleDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(ideaModuleFile);
        XPathExpression sourceFoldersExpression = XPathFactory.newInstance().newXPath().compile("//module/component/content");
        NodeList contentNodes = (NodeList)sourceFoldersExpression.evaluate(ideaModuleDocument, XPathConstants.NODESET);
        for (int contentNum = 0; contentNum < contentNodes.getLength(); ++contentNum) {
            Element contentElement = (Element)contentNodes.item(contentNum);
            String contentPath = contentElement.getAttribute("url");
            contentPath = contentPath.replaceAll("^file://", "");
            File contentFolder = new File(contentPath = contentPath.replaceAll("\\$MODULE_DIR\\$", ideaProjectPath)).getCanonicalFile();
            File resourcesFolder = new File(contentFolder, "Resources");
            if (!resourcesFolder.exists()) continue;
            searchFolders.add(new ManifestSearchFolder(resourcesFolder));
        }
        XPathExpression ideaModulesExpression = XPathFactory.newInstance().newXPath().compile("//module/component/orderEntry");
        NodeList ideaModuleNodes = (NodeList)ideaModulesExpression.evaluate(ideaModuleDocument, XPathConstants.NODESET);
        for (int ideaModuleNum = 0; ideaModuleNum < ideaModuleNodes.getLength(); ++ideaModuleNum) {
            String ideaLibraryName;
            File ideaLibraryFolder;
            Element ideaModuleElement = (Element)ideaModuleNodes.item(ideaModuleNum);
            String ideaModuleType = ideaModuleElement.getAttribute("type");
            if ("module".equals(ideaModuleType)) {
                String ideaModuleName = ideaModuleElement.getAttribute("module-name");
                File dependentModuleFile = new File(ideaModuleFile.getParentFile(), ideaModuleName + ".iml").getCanonicalFile();
                this.processIdeaModuleFile(dependentModuleFile, searchFolders, ideaLibraries, visitedModulePaths);
                continue;
            }
            if (!"library".equals(ideaModuleType) || (ideaLibraryFolder = ideaLibraries.get(ideaLibraryName = ideaModuleElement.getAttribute("name"))) == null) continue;
            searchFolders.add(new ManifestSearchFolder(ideaLibraryFolder));
        }
    }

    public static void findIdeaProjectFilesInFolder(File folder, Set<File> ideaProjectFiles) throws IOException, PropertyListParserException {
        if (folder != null) {
            boolean foundProjectFiles = false;
            if (folder.isDirectory()) {
                File projectLocator = new File(folder, ".EntityModeler.plist");
                if (projectLocator.exists()) {
                    List projectFilePaths;
                    Map projectProperties = (Map)WOLPropertyListSerialization.propertyListWithContentsOfFile((String)projectLocator.getCanonicalPath(), (ParserDataStructureFactory)new SimpleParserDataStructureFactory());
                    Map dependencies = (Map)projectProperties.get("Dependencies");
                    if (dependencies != null && (projectFilePaths = (List)dependencies.get("IDEA")) != null) {
                        for (String projectFilePath : projectFilePaths) {
                            File projectFile = new File(projectFilePath);
                            if (!projectFile.exists()) {
                                projectFile = new File(folder, projectFilePath);
                            }
                            if (!projectFile.exists() || !IDEAProjectEOModelGroupFactory.isIdeaProjectFile(projectFile = projectFile.getCanonicalFile())) continue;
                            ideaProjectFiles.add(projectFile.getCanonicalFile());
                            foundProjectFiles = true;
                        }
                    }
                } else {
                    File[] files = folder.listFiles();
                    if (files != null) {
                        for (File file : files) {
                            if (!IDEAProjectEOModelGroupFactory.isIdeaProjectFile(file)) continue;
                            ideaProjectFiles.add(file.getCanonicalFile());
                            foundProjectFiles = true;
                        }
                    }
                }
            }
            if (!foundProjectFiles) {
                File parentFolder = folder.getParentFile();
                IDEAProjectEOModelGroupFactory.findIdeaProjectFilesInFolder(parentFolder, ideaProjectFiles);
            }
        }
    }

    public static boolean isIdeaProjectFile(File file) {
        return file.getName().endsWith(".ipr");
    }
}

