/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.objectstyle.wolips.baseforuiplugins.utils.WorkbenchUtilities;
import org.objectstyle.wolips.componenteditor.actions.WOElementSelectionDialog;
import org.objectstyle.wolips.locate.LocatePlugin;
import org.objectstyle.wolips.locate.result.LocalizedComponentsLocateResult;

public class OpenComponentAction
extends Action
implements IWorkbenchWindowActionDelegate,
IActionDelegate2 {
    private Object _selectedObject;

    public OpenComponentAction() {
        this.setText("Open Component");
        this.setDescription("Open a Component");
        this.setToolTipText("Open a Component");
    }

    public void run() {
        this.runWithEvent(null);
    }

    public void runWithEvent(Event e) {
        IJavaProject javaProject = null;
        if (this._selectedObject instanceof IJavaElement) {
            IJavaElement javaElement = (IJavaElement)this._selectedObject;
            javaProject = javaElement.getJavaProject();
        } else if (this._selectedObject instanceof IResource) {
            IProject project = ((IResource)this._selectedObject).getProject();
            javaProject = JavaCore.create((IProject)project);
        } else {
            IEditorInput editorInput;
            IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (editorPart != null && (editorInput = editorPart.getEditorInput()) instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)editorInput).getFile();
                javaProject = JavaCore.create((IProject)file.getProject());
            }
        }
        Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (javaProject == null) {
            ErrorDialog.openError((Shell)parent, (String)"Select a Project", (String)"You must have selected an object within a project before using Open Component.", (IStatus)Status.OK_STATUS);
        } else {
            WOElementSelectionDialog dialog = new WOElementSelectionDialog(parent, javaProject, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
            dialog.setTitle("Open Component");
            dialog.setMessage("Select a Component to Open");
            int result = dialog.open();
            if (result != 0) {
                return;
            }
            Object[] typeNames = dialog.getResult();
            if (typeNames != null && typeNames.length > 0) {
                for (int i = 0; i < typeNames.length; ++i) {
                    String typeName = (String)typeNames[i];
                    OpenComponentAction.openComponentWithTypeNamed(javaProject, typeName);
                }
            }
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this._selectedObject = ((IStructuredSelection)selection).getFirstElement();
        }
    }

    public void runWithEvent(IAction action, Event event) {
        this.runWithEvent(event);
    }

    public void init(IAction action) {
    }

    public static void openComponentWithTypeNamed(IJavaProject javaProject, String typeName) {
        try {
            IType type = javaProject.findType(typeName);
            if (type != null) {
                JavaUI.openInEditor((IJavaElement)type, (boolean)true, (boolean)true);
                LocalizedComponentsLocateResult componentsLocateResults = LocatePlugin.getDefault().getLocalizedComponentsLocateResult(type.getUnderlyingResource());
                IFile wodFile = componentsLocateResults.getFirstWodFile();
                if (wodFile != null) {
                    WorkbenchUtilities.open((IFile)wodFile, (String)"org.objectstyle.wolips.componenteditor.ComponentEditor");
                }
            }
        }
        catch (Throwable e1) {
            e1.printStackTrace();
        }
    }
}

