/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.launcher;

import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.objectstyle.wolips.componenteditor.part.ComponentEditor;
import org.objectstyle.wolips.components.input.ComponentEditorInput;
import org.objectstyle.wolips.editors.EditorsPlugin;

public class ComponentEditorMatchingStrategy
implements IEditorMatchingStrategy {
    private boolean canHandleExtension(String extension) {
        return "wod".equalsIgnoreCase(extension) || "html".equalsIgnoreCase(extension) || "woo".equalsIgnoreCase(extension) || "api".equalsIgnoreCase(extension) || "tiff".equalsIgnoreCase(extension);
    }

    public boolean matches(IEditorReference editorReference, IEditorInput editorInput) {
        String editorID = editorReference.getId();
        if (editorID == null) {
            return false;
        }
        if (!editorID.equals(EditorsPlugin.ComponentEditorID)) {
            return false;
        }
        if (editorInput instanceof ComponentEditorInput) {
            IWorkbenchPart workbenchPart = editorReference.getPart(true);
            if (workbenchPart == null) {
                return false;
            }
            ComponentEditor componentEditor = (ComponentEditor)workbenchPart;
            ComponentEditorInput componentEditorInput = componentEditor.getComponentEditorInput();
            return componentEditorInput.equals((Object)editorInput);
        }
        if (!(editorInput instanceof FileEditorInput)) {
            return false;
        }
        IFile inputFile = ResourceUtil.getFile((IEditorInput)editorInput);
        if (inputFile == null) {
            return false;
        }
        String extension = inputFile.getFileExtension();
        if (extension == null) {
            return false;
        }
        if (!this.canHandleExtension(extension)) {
            return false;
        }
        IWorkbenchPart workbenchPart = editorReference.getPart(true);
        if (workbenchPart == null) {
            return false;
        }
        if (!(workbenchPart instanceof ComponentEditor)) {
            return false;
        }
        ComponentEditor componentEditor = (ComponentEditor)workbenchPart;
        ComponentEditorInput componentEditorInput = componentEditor.getComponentEditorInput();
        IEditorInput[] editorInputArray = componentEditorInput.getInput();
        for (int i = 0; i < editorInputArray.length; ++i) {
            IFile inputFileFromEditor = ResourceUtil.getFile((IEditorInput)editorInputArray[i]);
            if (inputFileFromEditor == null || !inputFileFromEditor.equals(inputFile)) continue;
            return true;
        }
        return false;
    }
}

