/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.part;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IShowEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.objectstyle.wolips.baseforuiplugins.IEditorTarget;
import org.objectstyle.wolips.componenteditor.outline.ComponentEditorOutline;
import org.objectstyle.wolips.componenteditor.part.ApiTab;
import org.objectstyle.wolips.componenteditor.part.ComponentEditorTab;
import org.objectstyle.wolips.componenteditor.part.HtmlPreviewTab;
import org.objectstyle.wolips.componenteditor.part.HtmlWodTab;
import org.objectstyle.wolips.componenteditor.part.WooTab;
import org.objectstyle.wolips.components.editor.ComponentEditorInteraction;
import org.objectstyle.wolips.components.editor.IComponentEditor;
import org.objectstyle.wolips.components.input.ComponentEditorInput;
import org.objectstyle.wolips.templateeditor.TemplateEditor;
import org.objectstyle.wolips.wodclipse.editor.WodEditor;

public class ComponentEditorPart
extends MultiPageEditorPart
implements IEditorTarget,
IResourceChangeListener,
IComponentEditor,
IShowEditorInput {
    private int htmlPageId;
    private int wodPageId;
    private int wooPageId;
    private int previewPageId;
    private int apiPageId;
    ComponentEditorInput componentEditorInput;
    private ComponentEditorInteraction editorInteraction = new ComponentEditorInteraction();
    private ComponentEditorOutline componentEditorOutline;
    private HtmlWodTab[] htmlWodTabs;
    private HtmlPreviewTab htmlPreviewTab;
    private ApiTab apiTab;
    private ComponentEditorTab[] componentEditorTabs;
    private boolean _saving;

    public ComponentEditorPart() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.editorInteraction.setComponentEditor((IComponentEditor)this);
    }

    public boolean embeddedEditorWillSave(IProgressMonitor progressMonitor) {
        boolean saveEmbeddedEditor = true;
        if (!this._saving) {
            saveEmbeddedEditor = false;
            this.doSave(progressMonitor);
        }
        return saveEmbeddedEditor;
    }

    public void addPage(int index, IEditorPart editor, IEditorInput input) throws PartInitException {
        super.addPage(index, editor, input);
    }

    private ComponentEditorOutline getComponentEditorOutline() {
        if (this.componentEditorOutline == null) {
            this.componentEditorOutline = new ComponentEditorOutline();
        }
        return this.componentEditorOutline;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IContentOutlinePage.class)) {
            return this.getComponentEditorOutline();
        }
        return super.getAdapter(adapter);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.componentEditorInput = (ComponentEditorInput)input;
        if (input != null) {
            String inputName = input.getName();
            this.setPartName(inputName);
        }
        site.setSelectionProvider((ISelectionProvider)new ComponentEditorPartSelectionProvider(this));
    }

    public IEditorInput getEditorInput() {
        if (this.componentEditorTabs == null) {
            return null;
        }
        return this.componentEditorTabs[this.getActivePage()].getActiveEditorInput();
    }

    protected void createPages() {
        if (this.componentEditorInput == null) {
            return;
        }
        IEditorInput[] editorInput = this.componentEditorInput.getComponentEditors();
        ArrayList<ComponentEditorTab> componentEditorTabsList = new ArrayList<ComponentEditorTab>();
        ArrayList<HtmlWodTab> htmlWodTabsList = new ArrayList<HtmlWodTab>();
        IFileEditorInput htmlInput = null;
        IFileEditorInput wodInput = null;
        IFileEditorInput wooInput = null;
        int inputsPerComponent = 3;
        int tabIndex = 0;
        boolean hasMultipleComponents = editorInput.length > inputsPerComponent;
        for (int componentNum = 0; componentNum < editorInput.length; componentNum += inputsPerComponent) {
            htmlInput = (IFileEditorInput)editorInput[componentNum + 0];
            wodInput = (IFileEditorInput)editorInput[componentNum + 1];
            wooInput = (IFileEditorInput)editorInput[componentNum + 2];
            String language = null;
            if (hasMultipleComponents) {
                language = ComponentEditorInput.getLanguageName((IFileEditorInput)htmlInput);
                if (language == null && (language = ComponentEditorInput.getLanguageName((IFileEditorInput)wodInput)) == null) {
                    language = ComponentEditorInput.getLanguageName((IFileEditorInput)wooInput);
                }
                language = language == null ? "" : language + " ";
            } else {
                language = "";
            }
            HtmlWodTab htmlWodTab = new HtmlWodTab(this, tabIndex, (IEditorInput)htmlInput, (IEditorInput)wodInput);
            componentEditorTabsList.add(htmlWodTab);
            htmlWodTabsList.add(htmlWodTab);
            htmlWodTab.createTab();
            this.wodPageId = this.htmlPageId = this.addPage((Control)htmlWodTab);
            this.setPageText(tabIndex, language + "Component");
            WooTab wooTab = new WooTab(this, ++tabIndex, (IEditorInput)wooInput);
            componentEditorTabsList.add(wooTab);
            wooTab.createTab();
            this.wooPageId = this.addPage((Control)wooTab);
            this.setPageText(tabIndex, language + "Display Groups");
            ++tabIndex;
        }
        if (this.componentEditorInput.getStandaloneHtmlEditor() != null) {
            IFileEditorInput standaloneHtmlInput = (IFileEditorInput)this.componentEditorInput.getStandaloneHtmlEditor();
            HtmlWodTab htmlWodTab = new HtmlWodTab(this, tabIndex, (IEditorInput)standaloneHtmlInput, null);
            componentEditorTabsList.add(htmlWodTab);
            htmlWodTabsList.add(htmlWodTab);
            htmlWodTab.createTab();
            this.wodPageId = this.htmlPageId = this.addPage((Control)htmlWodTab);
            this.setPageText(tabIndex, "HTML");
            ++tabIndex;
        }
        if (this.componentEditorInput.getStandaloneHtmlEditor() == null) {
            IFileEditorInput apiInput = (IFileEditorInput)this.componentEditorInput.getApiEditor();
            this.apiTab = new ApiTab(this, tabIndex, (IEditorInput)apiInput);
            componentEditorTabsList.add(this.apiTab);
            this.apiTab.createTab();
            this.apiPageId = this.addPage((Control)this.apiTab);
            this.setPageText(tabIndex, "Api");
            ++tabIndex;
        }
        if (editorInput.length > 0) {
            this.htmlPreviewTab = new HtmlPreviewTab(this, tabIndex, (IEditorInput)htmlInput);
            componentEditorTabsList.add(this.htmlPreviewTab);
            this.htmlPreviewTab.createTab();
            this.previewPageId = this.addPage((Control)this.htmlPreviewTab);
            this.setPageText(tabIndex, "Preview (Experimental)");
            ++tabIndex;
        }
        this.componentEditorTabs = componentEditorTabsList.toArray(new ComponentEditorTab[componentEditorTabsList.size()]);
        this.htmlWodTabs = htmlWodTabsList.toArray(new HtmlWodTab[htmlWodTabsList.size()]);
        CTabFolder tabFolder = (CTabFolder)this.getContainer();
        tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ComponentEditorPart.this.updateOutline();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.componentEditorInput.isDisplayWodPartOnReveal()) {
            this.switchToWod();
        } else if (this.componentEditorInput.isDisplayWooPartOnReveal()) {
            this.switchToWoo();
        } else if (this.componentEditorInput.isDisplayApiPartOnReveal()) {
            this.switchToApi();
        } else if (this.componentEditorInput.isDisplayHtmlPartOnReveal()) {
            this.switchToHtml();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this._saving = true;
        try {
            for (int i = 0; i < this.componentEditorTabs.length; ++i) {
                if (this.componentEditorTabs[i] == null || !this.componentEditorTabs[i].isDirty()) continue;
                this.componentEditorTabs[i].doSave(monitor);
            }
            return;
        }
        finally {
            this._saving = false;
        }
    }

    public void close(boolean save) {
        for (int i = 0; i < this.componentEditorTabs.length; ++i) {
            if (this.componentEditorTabs[i] == null) continue;
            this.componentEditorTabs[i].close(save);
        }
    }

    public void doSaveAs() {
        assert (false);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void updateOutline() {
        IEditorPart editorPart = this.getActiveEditor();
        if (editorPart != null) {
            IContentOutlinePage contentOutlinePage = (IContentOutlinePage)editorPart.getAdapter(IContentOutlinePage.class);
            this.getComponentEditorOutline().setPageActive(contentOutlinePage);
        }
    }

    public boolean isDirty() {
        if (super.isDirty()) {
            return true;
        }
        for (int i = 0; i < this.componentEditorTabs.length; ++i) {
            if (!this.componentEditorTabs[i].isDirty()) continue;
            return true;
        }
        return false;
    }

    public IEditorPart switchTo(int targetEditorID) {
        switch (targetEditorID) {
            case 3: {
                this.switchToApi();
                break;
            }
            case 0: {
                this.switchToHtml();
                break;
            }
            case 2: {
                this.switchToPreview();
                break;
            }
            case 1: {
                this.switchToWod();
                break;
            }
            case 4: {
                this.switchToWoo();
                break;
            }
        }
        IEditorPart editorPart = this.getActiveEditor();
        return editorPart;
    }

    public HtmlWodTab htmlWodTab() {
        return this.htmlWodTabs != null && this.htmlWodTabs.length > 0 ? this.htmlWodTabs[0] : null;
    }

    public void switchToHtml() {
        this.htmlWodTab().setHtmlActive();
        this.switchToPage(this.htmlPageId);
    }

    public void switchToWod() {
        this.htmlWodTab().setWodActive();
        this.switchToPage(this.wodPageId);
    }

    public void switchToWoo() {
        this.switchToPage(this.wooPageId);
    }

    public void switchToPreview() {
        this.switchToPage(this.previewPageId);
    }

    public void switchToApi() {
        this.switchToPage(this.apiPageId);
    }

    public void switchToPage(int page) {
        this.setActivePage(page);
        this.setFocus();
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        this.componentEditorTabs[newPageIndex].editorSelected();
    }

    public ComponentEditorInput getComponentEditorInput() {
        return this.componentEditorInput;
    }

    public TemplateEditor getTemplateEditor() {
        return this.htmlWodTab() == null ? null : this.htmlWodTab().templateEditor();
    }

    public WodEditor getWodEditor() {
        return this.htmlWodTab() == null ? null : this.htmlWodTab().wodEditor();
    }

    public IEditorPart getEditor(int pageIndex) {
        return this.componentEditorTabs[this.getActivePage()].getActiveEmbeddedEditor();
    }

    public IEditorPart getActiveEditor() {
        int activePage = this.getActivePage();
        if (activePage == -1) {
            return null;
        }
        return this.componentEditorTabs[activePage].getActiveEmbeddedEditor();
    }

    public void publicHandlePropertyChange(int propertyId) {
        this.handlePropertyChange(propertyId);
    }

    public IEditorSite publicCreateSite(IEditorPart editor) {
        return this.createSite(editor);
    }

    public Composite publicGetContainer() {
        return super.getContainer();
    }

    public ComponentEditorInteraction getEditorInteraction() {
        return this.editorInteraction;
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    boolean closed = false;
                    for (int i = 0; i < ComponentEditorPart.this.componentEditorInput.getInput().length; ++i) {
                        if (((FileEditorInput)ComponentEditorPart.this.componentEditorInput.getInput()[i]).getFile().getProject().equals(event.getResource())) {
                            IWorkbenchPage[] pages = ComponentEditorPart.this.getSite().getWorkbenchWindow().getPages();
                            for (int j = 0; j < pages.length; ++j) {
                                IEditorPart editorPart = pages[i].findEditor((IEditorInput)ComponentEditorPart.this.componentEditorInput);
                                if (editorPart == null || !pages[i].closeEditor((IEditorPart)ComponentEditorPart.this, true)) continue;
                                closed = true;
                            }
                        }
                        if (closed) break;
                    }
                }
            });
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        if (this.componentEditorTabs != null) {
            for (int i = 0; i < this.componentEditorTabs.length; ++i) {
                if (this.componentEditorTabs[i] == null) continue;
                this.componentEditorTabs[i].dispose();
            }
        }
        super.dispose();
    }

    public void showEditorInput(IEditorInput editorInput) {
        IFile inputFile = ((FileEditorInput)editorInput).getFile();
        IEditorInput[] editorInputArray = this.componentEditorInput.getInput();
        block6: for (int i = 0; i < editorInputArray.length; ++i) {
            IFile inputFileFromEditor = ResourceUtil.getFile((IEditorInput)editorInputArray[i]);
            if (inputFileFromEditor == null || !inputFileFromEditor.equals(inputFile)) continue;
            switch (i) {
                case 0: {
                    this.switchToHtml();
                    continue block6;
                }
                case 1: {
                    this.switchToWod();
                    continue block6;
                }
                case 2: {
                    this.switchToWoo();
                    continue block6;
                }
                case 3: {
                    this.switchToApi();
                    continue block6;
                }
            }
        }
    }

    private static class ComponentEditorPartSelectionProvider
    extends MultiPageSelectionProvider {
        private ISelection globalSelection;

        public ComponentEditorPartSelectionProvider(ComponentEditorPart componentEditorPart) {
            super((MultiPageEditorPart)componentEditorPart);
        }

        public ISelection getSelection() {
            ISelectionProvider selectionProvider;
            IEditorPart activeEditor = ((ComponentEditorPart)this.getMultiPageEditor()).getActiveEditor();
            if (activeEditor != null && (selectionProvider = activeEditor.getSite().getSelectionProvider()) != null) {
                return selectionProvider.getSelection();
            }
            return this.globalSelection;
        }

        public void setSelection(ISelection selection) {
            IEditorPart activeEditor = ((ComponentEditorPart)this.getMultiPageEditor()).getActiveEditor();
            if (activeEditor != null) {
                ISelectionProvider selectionProvider = activeEditor.getSite().getSelectionProvider();
                if (selectionProvider != null) {
                    selectionProvider.setSelection(selection);
                }
            } else {
                this.globalSelection = selection;
                this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.globalSelection));
            }
        }
    }
}

