/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.core.resources.pattern;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.objectstyle.wolips.core.CorePlugin;

public class PatternsetReader {
    private String[] pattern = new String[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PatternsetReader(IFile patternset) {
        ArrayList<String> patternList = new ArrayList<String>();
        BufferedReader patternReader = null;
        try {
            patternReader = new BufferedReader(new FileReader(new File(patternset.getLocation().toOSString())));
            String line = patternReader.readLine();
            while (line != null) {
                if (line.length() > 0) {
                    patternList.add(line);
                }
                line = patternReader.readLine();
            }
        }
        catch (IOException ioe) {
            CorePlugin.getDefault().log(ioe);
        }
        finally {
            if (null != patternReader) {
                try {
                    patternReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.setPattern(patternList.toArray(new String[patternList.size()]));
    }

    public PatternsetReader(String[] pattern) {
        this.setPattern(pattern);
    }

    public void setPattern(String[] pattern) {
        this.pattern = pattern;
        if (this.pattern != null) {
            for (int patternNum = 0; patternNum < this.pattern.length; ++patternNum) {
                this.pattern[patternNum] = this.pattern[patternNum].replace("/", File.separator);
            }
        }
    }

    public String[] getPattern() {
        return this.pattern;
    }
}

