/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.core.resources.types;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.TypeNameRequestor;

public class TypeNameCollector
extends TypeNameRequestor {
    private IJavaProject _project;
    private Set<String> _typeNames;
    private Map<String, String> _typeNameToPath;
    private Map<String, IType> _typeNameToType;
    private IType _superclassType;
    private boolean _requireTypeInProject;

    public TypeNameCollector(IJavaProject project, boolean requireTypeInProject) throws JavaModelException {
        this("com.webobjects.appserver.WOElement", project, requireTypeInProject, new TreeSet<String>());
    }

    public TypeNameCollector(IJavaProject project, boolean requireTypeInProject, Set<String> typeNames) throws JavaModelException {
        this("com.webobjects.appserver.WOElement", project, requireTypeInProject, typeNames);
    }

    public TypeNameCollector(String superclassTypeName, IJavaProject project, boolean requireTypeInProject) throws JavaModelException {
        this(superclassTypeName, project, requireTypeInProject, new TreeSet<String>());
    }

    public TypeNameCollector(String superclassTypeName, IJavaProject project, boolean requireTypeInProject, Set<String> typeNames) throws JavaModelException {
        this._project = project;
        this._typeNames = typeNames;
        this._typeNameToPath = new HashMap<String, String>();
        this._typeNameToType = new HashMap<String, IType>();
        this._requireTypeInProject = requireTypeInProject;
        if (superclassTypeName != null) {
            this._superclassType = this._project.findType(superclassTypeName);
        }
    }

    public IJavaProject getProject() {
        return this._project;
    }

    public IType getSuperclassType() {
        return this._superclassType;
    }

    public Set<String> getTypeNames() {
        return this._typeNames;
    }

    public boolean isExactMatch() {
        return this._typeNames.size() == 1;
    }

    public boolean isEmpty() {
        return this._typeNames.isEmpty();
    }

    public String firstTypeName() {
        return this._typeNames.iterator().next();
    }

    public Collection<IType> types() {
        return this._typeNameToType.values();
    }

    public Iterator<String> typeNames() {
        return this._typeNames.iterator();
    }

    public String getPathForClassName(String _className) {
        return this._typeNameToPath.get(_className);
    }

    public IType getTypeForClassName(String _className) {
        return this._typeNameToType.get(_className);
    }

    public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
        String simpleClassName = new String(simpleTypeName);
        String className = packageName == null || packageName.length == 0 ? simpleClassName : new String(packageName) + "." + simpleClassName;
        try {
            IType type = this._project.findType(className);
            if (type != null) {
                IResource correspondingResource;
                boolean typeMatches = true;
                if (this._requireTypeInProject && (correspondingResource = type.getResource()) == null) {
                    typeMatches = false;
                }
                if (typeMatches) {
                    this._typeNames.add(className);
                    this._typeNameToPath.put(className, path);
                    this._typeNameToType.put(className, type);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

