/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.jdt.ui.tags;

import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.objectstyle.wolips.jdt.ui.tags.ITaggedComponentsContentProvider;
import org.objectstyle.wolips.jdt.ui.tags.Tag;
import org.objectstyle.wolips.jdt.ui.tags.TaggedComponent;

public class SecondLevelTagContentProvider
implements ITaggedComponentsContentProvider {
    public Tag tag;
    public Tag parentTag;
    public TaggedComponent[] taggedComponents;
    public IFolder[] componentFolder;

    public SecondLevelTagContentProvider(Tag tag, Tag parentTag) {
        this.tag = tag;
        this.parentTag = parentTag;
    }

    @Override
    public Object[] getChildren() {
        if (this.taggedComponents == null) {
            Tag[] tags = new Tag[]{this.tag, this.parentTag};
            this.taggedComponents = this.tag.tagLib.getComponents(tags);
        }
        if (this.componentFolder == null) {
            this.componentFolder = this.find((IProgressMonitor)new NullProgressMonitor());
        }
        return this.componentFolder;
    }

    @Override
    public boolean hasChildren() {
        if (this.taggedComponents == null) {
            Tag[] tags = new Tag[]{this.tag, this.parentTag};
            this.taggedComponents = this.tag.tagLib.getComponents(tags);
        }
        return this.taggedComponents.length > 0;
    }

    public InputStream getContents() throws CoreException {
        return null;
    }

    public IPath getFullPath() {
        return null;
    }

    public String getName() {
        return this.tag.name;
    }

    public boolean isReadOnly() {
        return false;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    protected IFolder[] find(IProgressMonitor monitor) {
        ArrayList<IFolder> folder = new ArrayList<IFolder>();
        try {
            this.find((IResource)this.tag.tagLib.project, folder, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return folder.toArray(new IFolder[folder.size()]);
    }

    private void find(IResource resource, ArrayList<IFolder> folder, IProgressMonitor monitor) throws CoreException {
        if (resource.isDerived()) {
            return;
        }
        if (resource.getType() == 1) {
            return;
        }
        IResource[] members = null;
        if (resource.getType() == 2) {
            if (resource.getFileExtension() != null && "wo".equals(resource.getFileExtension())) {
                for (int i = 0; i < this.taggedComponents.length; ++i) {
                    TaggedComponent taggedComponent = this.taggedComponents[i];
                    String folderName = taggedComponent.name + ".wo";
                    if (!folderName.equals(resource.getName())) continue;
                    folder.add((IFolder)resource);
                    return;
                }
                return;
            }
            members = ((IFolder)resource).members();
        }
        if (resource.getType() == 4) {
            members = ((IProject)resource).members();
        }
        if (members != null) {
            for (int i = 0; i < members.length; ++i) {
                this.find(members[i], folder, monitor);
            }
        }
    }
}

