/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.editormenu;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.objectstyle.wolips.componenteditor.ComponenteditorPlugin;
import org.objectstyle.wolips.componenteditor.part.ComponentEditor;
import org.objectstyle.wolips.locate.LocateException;
import org.objectstyle.wolips.locate.LocatePlugin;
import org.objectstyle.wolips.locate.result.LocalizedComponentsLocateResult;

public abstract class AbstractSwitchToActionDelegate
implements IEditorActionDelegate {
    private ComponentEditor componentEditor;
    private IEditorPart editorPart;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editorPart = null;
        this.componentEditor = null;
        if (targetEditor == null) {
            return;
        }
        if (targetEditor instanceof ComponentEditor) {
            this.componentEditor = (ComponentEditor)targetEditor;
        }
        this.editorPart = targetEditor;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public ComponentEditor getComponentEditor() {
        return this.componentEditor;
    }

    public IEditorPart getEditorPart() {
        return this.editorPart;
    }

    public LocalizedComponentsLocateResult getLocalizedComponentsLocateResult() {
        IEditorInput editorInput = this.editorPart.getEditorInput();
        FileEditorInput fileEditorInput = (FileEditorInput)editorInput;
        IFile file = fileEditorInput.getFile();
        LocalizedComponentsLocateResult localizedComponentsLocateResult = null;
        try {
            localizedComponentsLocateResult = LocatePlugin.getDefault().getLocalizedComponentsLocateResult((IResource)file);
        }
        catch (CoreException e) {
            ComponenteditorPlugin.getDefault().log(e);
            return null;
        }
        catch (LocateException e) {
            ComponenteditorPlugin.getDefault().log(e);
            return null;
        }
        if (localizedComponentsLocateResult.getComponents() == null || localizedComponentsLocateResult.getComponents().length == 0) {
            return null;
        }
        return localizedComponentsLocateResult;
    }
}

