/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.baseforplugins.util;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class StringUtilities {
    public static boolean isDigitsOnly(String aString) {
        int i = aString.length();
        while (i-- > 0) {
            char c = aString.charAt(i);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumericOnly(String aString) {
        boolean foundDecimal = false;
        int i = aString.length();
        while (i-- > 0) {
            char c = aString.charAt(i);
            if (c == '-') {
                if (i == 0) continue;
                return false;
            }
            if (c == '.') {
                if (!foundDecimal) {
                    foundDecimal = true;
                    continue;
                }
                return false;
            }
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static String toCommandlineParameterFormat(String parameter, String value, boolean escapeSpacesAndQuotes) {
        return StringUtilities.toCommandlineParameterFormat(parameter, value, escapeSpacesAndQuotes, false);
    }

    public static String toCommandlineParameterFormat(String parameter, String value, boolean escapeSpacesAndQuotes, boolean equalsSeparator) {
        String formattedValue;
        boolean quote;
        StringBuffer commandlineFormat = new StringBuffer();
        commandlineFormat.append(parameter);
        if (!parameter.endsWith("=")) {
            if (equalsSeparator) {
                commandlineFormat.append("=");
            } else {
                commandlineFormat.append(" ");
            }
        }
        boolean bl = quote = (formattedValue = value).indexOf(32) != -1 || formattedValue.indexOf(45) != -1;
        if (quote && escapeSpacesAndQuotes) {
            formattedValue = formattedValue.replaceAll(" ", "\\\\ ");
            formattedValue = formattedValue.replaceAll("\"", "\\\\\"");
        }
        if (quote) {
            commandlineFormat.append('\"');
        }
        commandlineFormat.append(formattedValue);
        if (quote) {
            commandlineFormat.append('\"');
        }
        return commandlineFormat.toString();
    }

    public static String replace(String origin, String oldPart, String newPart) {
        int index;
        if (origin == null || origin.length() == 0) {
            return origin;
        }
        StringBuffer buffer = new StringBuffer(origin);
        int end = origin.length();
        int oldLength = oldPart.length();
        while (end >= 0 && (index = origin.lastIndexOf(oldPart, end)) != -1) {
            end = index - oldLength;
            buffer.replace(index, index + oldLength, newPart);
        }
        return buffer.toString();
    }

    public static synchronized ArrayList arrayListFromCSV(String csvString) {
        if (csvString == null || csvString.length() == 0) {
            return new ArrayList();
        }
        StringTokenizer valueTokenizer = new StringTokenizer(csvString, ",");
        ArrayList<Object> resultList = new ArrayList<Object>(valueTokenizer.countTokens());
        while (valueTokenizer.hasMoreElements()) {
            resultList.add(valueTokenizer.nextElement());
        }
        return resultList;
    }
}

