/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocType;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.event.FuzzyXMLErrorEvent;
import jp.aonir.fuzzyxml.event.FuzzyXMLErrorListener;
import jp.aonir.fuzzyxml.internal.FuzzyXMLAttributeImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLCDATAImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLCommentImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLDocTypeImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLDocumentImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLElementImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLPreImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLProcessingInstructionImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLScriptImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLStyleImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLTextImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLUtil;
import jp.aonir.fuzzyxml.resources.Messages;
import org.objectstyle.wolips.wodclipse.core.util.WodHtmlUtils;

public class FuzzyXMLParser {
    private Stack<FuzzyXMLNode> _stack = new Stack();
    private String _originalSource;
    private List<FuzzyXMLNode> _roots;
    private FuzzyXMLDocType _docType;
    private List<FuzzyXMLErrorListener> _listeners = new ArrayList<FuzzyXMLErrorListener>();
    private List<FuzzyXMLElement> _nonCloseElements = new ArrayList<FuzzyXMLElement>();
    private List<String> _looseNamespaces = new ArrayList<String>();
    private List<String> _autocloseTags = new ArrayList<String>();
    private List<String> _looseTags = new ArrayList<String>();
    private boolean _wellFormedRequired = false;
    private boolean _isHTML = false;
    private Pattern _tag = Pattern.compile("<((|/)([^<>]*))([^<]?|>)");
    private Pattern _docTypeName = Pattern.compile("^<!DOCTYPE[ \r\n\t]+([\\w\\-_]*)");
    private Pattern _docTypePublic = Pattern.compile("PUBLIC[ \r\n\t]+\"([^\"]*)\"[ \r\n\t]*\"*([^\">]*)\"*");
    private Pattern _docTypeSystem = Pattern.compile("SYSTEM[ \r\n\t]+\"([^\"]*)\"");
    private Pattern _docTypeSubset = Pattern.compile("\\[([^\\]]*)\\]>");
    private Pattern _invalidStringPattern = Pattern.compile("([<>&])");
    private Pattern _preCloseTagPattern = Pattern.compile("<\\s*/\\s*PRE\\s*>", 2);

    public FuzzyXMLParser(boolean wellFormedRequired) {
        this(wellFormedRequired, false);
    }

    public FuzzyXMLParser(boolean wellFormedRequired, boolean isHTML) {
        this._wellFormedRequired = wellFormedRequired;
        this._roots = new LinkedList<FuzzyXMLNode>();
        this._isHTML = isHTML;
        this.addLooseNamespace("wo");
        this.addLooseNamespace("webobject");
        this.addLooseNamespace("webobjects");
        if (!this._wellFormedRequired) {
            this.addAutocloseTag("img");
            this.addAutocloseTag("br");
            this.addAutocloseTag("hr");
            this.addAutocloseTag("meta");
            this.addAutocloseTag("link");
            this.addAutocloseTag("input");
            this.addAutocloseTag("spacer");
            this.addAutocloseTag("frame");
            this.addAutocloseTag("basefont");
            this.addAutocloseTag("base");
            this.addAutocloseTag("area");
            this.addAutocloseTag("col");
            this.addAutocloseTag("isindex");
            this.addAutocloseTag("param");
            this.addLooseTag("p");
            this.addLooseTag("li");
        }
    }

    public void addAutocloseTag(String autocloseTag) {
        this._autocloseTags.add(autocloseTag);
        this.addLooseTag(autocloseTag);
    }

    public void addLooseTag(String looseTag) {
        this._looseTags.add(looseTag);
    }

    public void addLooseNamespace(String namespace) {
        this._looseNamespaces.add(namespace);
    }

    public void addErrorListener(FuzzyXMLErrorListener listener) {
        this._listeners.add(listener);
    }

    private void fireErrorEvent(int offset, int length, String message, FuzzyXMLNode node) {
        FuzzyXMLErrorEvent evt = new FuzzyXMLErrorEvent(offset, length, message, node);
        for (FuzzyXMLErrorListener listener : this._listeners) {
            listener.error(evt);
        }
    }

    public FuzzyXMLDocument parse(InputStream in) throws IOException {
        byte[] bytes = FuzzyXMLUtil.readStream(in);
        String encode = FuzzyXMLUtil.getEncoding(bytes);
        if (encode == null) {
            return this.parse(new String(bytes));
        }
        return this.parse(new String(bytes, encode));
    }

    public FuzzyXMLDocument parse(File file) throws IOException {
        byte[] bytes = FuzzyXMLUtil.readStream(new FileInputStream(file));
        String encode = FuzzyXMLUtil.getEncoding(bytes);
        if (encode == null) {
            return this.parse(new String(bytes));
        }
        return this.parse(new String(bytes, encode));
    }

    protected int _parse(String source, int initialOffset, boolean woOnly, boolean parseAsSynthetic) {
        Matcher matcher = this._tag.matcher(source);
        int lastIndex = initialOffset - 1;
        while (matcher.find()) {
            int start = matcher.start() + initialOffset;
            int end = matcher.end() + initialOffset;
            if (lastIndex == -1 && start > 0) {
                this.handleText(0, start, true);
            } else if (lastIndex != initialOffset - 1 && lastIndex < start) {
                this.handleText(lastIndex, start, true);
            }
            String originalText = matcher.group(1);
            String text = originalText.trim();
            if (!woOnly && text.startsWith("%")) {
                this.handleText(start, end, false);
            } else if (!woOnly && text.startsWith("?")) {
                this.handleDeclaration(start, end);
            } else if (!woOnly && (text.startsWith("!DOCTYPE") || text.startsWith("!doctype"))) {
                this.handleDoctype(start, end, text);
            } else if (!woOnly && text.startsWith("![CDATA[")) {
                this.handleCDATA(start, end, this._originalSource.substring(start, end));
            } else if (!woOnly && (text.equalsIgnoreCase("pre") || text.toLowerCase().startsWith("pre "))) {
                end = this.handlePreTag(start, end);
                matcher.region(end, source.length());
            } else if (text.startsWith("/") && (!woOnly || WodHtmlUtils.isWOTag((String)text.substring(1)))) {
                this.handleCloseTag(start, end, text);
            } else if (text.endsWith("/") && (!woOnly || WodHtmlUtils.isWOTag((String)text))) {
                if (originalText.endsWith(" ")) {
                    this.fireErrorEvent(start, end - start, "You can not have a space between the / and the > in your webobject tags.", null);
                }
                this.handleEmptyTag(start, end, parseAsSynthetic);
            } else if (!woOnly && text.startsWith("!--")) {
                end = this._originalSource.indexOf("-->", start);
                if (end > 0) {
                    end += 3;
                }
                this.handleComment(start, end, this._originalSource.substring(start, end));
                matcher.region(end, source.length());
            } else if (!woOnly || WodHtmlUtils.isWOTag((String)text)) {
                this.handleStartTag(start, end, parseAsSynthetic);
            }
            lastIndex = end;
        }
        return lastIndex;
    }

    public FuzzyXMLDocument parse(String source) {
        this._originalSource = source;
        source = FuzzyXMLUtil.comment2space(source, true);
        source = FuzzyXMLUtil.escapeScript(source);
        source = FuzzyXMLUtil.scriptlet2space(source, true);
        source = FuzzyXMLUtil.cdata2space(source, true);
        source = FuzzyXMLUtil.doctype2space(source, true);
        source = FuzzyXMLUtil.processing2space(source, true);
        source = FuzzyXMLUtil.escapeString(source);
        int lastIndex = this._parse(source, 0, false, false);
        if (this._stack.size() > 0 && this._nonCloseElements.size() > 0) {
            FuzzyXMLElementImpl lastElement = (FuzzyXMLElementImpl)this._nonCloseElements.get(this._nonCloseElements.size() - 1);
            String lowercaseLastElementName = lastElement.getName().toLowerCase();
            if (!this._looseTags.contains(lowercaseLastElementName)) {
                this.fireErrorEvent(lastElement.getOffset(), lastElement.getLength(), Messages.getMessage("error.noCloseTag", lastElement.getName()), null);
            }
            for (FuzzyXMLNode openNode : this._stack) {
                if (!(openNode instanceof FuzzyXMLElementImpl)) continue;
                FuzzyXMLElementImpl openElement = (FuzzyXMLElementImpl)openNode;
                openElement.setLength(lastIndex - openElement.getOffset());
                if (openElement.getParentNode() == null) {
                    this._roots.add(openElement);
                    continue;
                }
                ((FuzzyXMLElementImpl)openElement.getParentNode()).appendChildWithNoCheck(openElement);
            }
        }
        if (lastIndex != source.length()) {
            this.handleText(Math.max(0, lastIndex), source.length(), true);
        }
        FuzzyXMLElementImpl docElement = null;
        if (this._roots.size() == 0) {
            docElement = new FuzzyXMLElementImpl(null, "document", 0, this._originalSource.length(), 0);
        } else {
            FuzzyXMLNode firstRoot = this._roots.get(0);
            FuzzyXMLNode lastRoot = this._roots.get(this._roots.size() - 1);
            docElement = new FuzzyXMLElementImpl(null, "document", firstRoot.getOffset(), lastRoot.getOffset() + lastRoot.getLength() - firstRoot.getOffset(), 0);
            for (FuzzyXMLNode root : this._roots) {
                docElement.appendChildWithNoCheck(root);
            }
        }
        FuzzyXMLDocumentImpl doc = new FuzzyXMLDocumentImpl(docElement, this._docType);
        doc.setHTML(this._isHTML);
        return doc;
    }

    private void handleCDATA(int offset, int end, String text) {
        this.closeAutocloseTags();
        text = text.replaceFirst("<!\\[CDATA\\[", "");
        text = text.replaceFirst("\\]\\]>", "");
        FuzzyXMLCDATAImpl cdata = new FuzzyXMLCDATAImpl(this.getParent(), text, offset, end - offset);
        if (this.getParent() != null) {
            ((FuzzyXMLElement)this.getParent()).appendChild(cdata);
        } else {
            this._roots.add(cdata);
        }
        this._stack.push(cdata);
        this._parse(text, offset + "<![CDATA[".length(), true, true);
        FuzzyXMLNode poppedNode = this._stack.pop();
        if (poppedNode != cdata) {
            this._stack.push(poppedNode);
        }
    }

    private int handlePreTag(int offset, int end) {
        this.closeAutocloseTags();
        String[] content = this._preCloseTagPattern.split(this._originalSource.substring(end, this._originalSource.length()), 2);
        String text = content[0];
        TagInfo info = this.parseTagContents(this._originalSource.substring(offset + 1, end - 1));
        FuzzyXMLPreImpl preNode = new FuzzyXMLPreImpl(this.getParent(), text, offset, text.length());
        this.handleStartTag(preNode, info, offset, end);
        String preBlock = this._originalSource.substring(offset, end + text.length() + 1);
        return this._parse(preBlock, offset, true, false) - 1;
    }

    private void handleText(int offset, int end, boolean escape) {
        String text = this._originalSource.substring(offset, end);
        this.closeAutocloseTags();
        FuzzyXMLTextImpl textNode = new FuzzyXMLTextImpl(this.getParent(), FuzzyXMLUtil.decode(text, this._isHTML), offset, end - offset);
        textNode.setEscape(escape);
        if (this.getParent() != null) {
            ((FuzzyXMLElement)this.getParent()).appendChild(textNode);
        } else {
            this._roots.add(textNode);
        }
    }

    private void handleDeclaration(int offset, int end) {
        this.closeAutocloseTags();
        String text = this._originalSource.substring(offset, end);
        text = text.replaceFirst("^<\\?", "");
        text = text.replaceFirst("\\?>$", "");
        text = text.trim();
        String[] dim = text.split("[ \r\n\t]+");
        String name = dim[0];
        String data = text.substring(name.length()).trim();
        FuzzyXMLProcessingInstructionImpl pi = new FuzzyXMLProcessingInstructionImpl(null, name, data, offset, end - offset);
        if (this.getParent() != null) {
            ((FuzzyXMLElement)this.getParent()).appendChild(pi);
        } else {
            this._roots.add(pi);
        }
        if (name.startsWith("xml")) {
            this._autocloseTags.clear();
        }
    }

    private void handleDoctype(int offset, int end, String text) {
        this.closeAutocloseTags();
        if (this._docType == null) {
            String name = "";
            String publicId = "";
            String systemId = "";
            String internalSubset = "";
            text = this._originalSource.substring(offset, end);
            Matcher matcher = this._docTypeName.matcher(text);
            if (matcher.find()) {
                name = matcher.group(1);
            }
            if ((matcher = this._docTypePublic.matcher(text)).find()) {
                publicId = matcher.group(1);
                systemId = matcher.group(2);
            } else {
                matcher = this._docTypeSystem.matcher(text);
                if (matcher.find()) {
                    systemId = matcher.group(1);
                }
            }
            matcher = this._docTypeSubset.matcher(text);
            if (matcher.find()) {
                internalSubset = matcher.group(1);
            }
            this._docType = new FuzzyXMLDocTypeImpl(null, name, publicId, systemId, internalSubset, offset, end - offset);
        }
    }

    private void closeAutocloseTags() {
        FuzzyXMLElementImpl lastOpenElement;
        String name;
        if (this._stack.size() > 0 && (this._autocloseTags.contains(name = (lastOpenElement = (FuzzyXMLElementImpl)this._stack.peek()).getName().toLowerCase()) || lastOpenElement.isForbiddenFromHavingChildren())) {
            int openTagEndOffset = lastOpenElement.getOffset() + lastOpenElement.getOpenTagLength();
            this.handleCloseTag(openTagEndOffset, openTagEndOffset, "/" + name, false);
        }
    }

    private void handleCloseTag(int offset, int end, String text) {
        this.handleCloseTag(offset, end, text, true);
    }

    private void handleCloseTag(int offset, int end, String text, boolean showMismatchError) {
        String lowercaseCloseTagName;
        FuzzyXMLElementImpl lastOpenElement;
        String lowercaseLastOpenElementName;
        boolean closeTagMatches;
        String chuckWord;
        if (this._stack.size() == 0) {
            return;
        }
        String tagName = text.substring(1).trim();
        int chuckIndex = tagName.indexOf(32);
        if (chuckIndex != -1 && WodHtmlUtils.isWOTag((String)(chuckWord = tagName.substring(0, chuckIndex)))) {
            tagName = chuckWord;
        }
        if (!(closeTagMatches = (lowercaseLastOpenElementName = (lastOpenElement = (FuzzyXMLElementImpl)this._stack.pop()).getName().toLowerCase()).equals(lowercaseCloseTagName = tagName.toLowerCase()))) {
            String elementNamespace;
            this.closeAutocloseTags();
            boolean looseNamespace = false;
            int colonIndex = lowercaseLastOpenElementName.indexOf(58);
            if (colonIndex != -1 && lowercaseCloseTagName.equals(elementNamespace = lowercaseLastOpenElementName.substring(0, colonIndex)) && this._looseNamespaces.contains(elementNamespace)) {
                tagName = lastOpenElement.getName();
                lowercaseCloseTagName = lowercaseLastOpenElementName;
                looseNamespace = true;
            }
            if (!looseNamespace) {
                boolean looseTag = false;
                if (this._looseTags.contains(lowercaseLastOpenElementName)) {
                    looseTag = true;
                }
                if (looseTag) {
                    while (lowercaseLastOpenElementName != null && !lowercaseLastOpenElementName.equals(lowercaseCloseTagName) && this._looseTags.contains(lowercaseLastOpenElementName)) {
                        int lastOpenElementEndOffset = end;
                        this._stack.push(lastOpenElement);
                        this.handleCloseTag(lastOpenElementEndOffset, lastOpenElementEndOffset, "/" + lastOpenElement.getName(), false);
                        if (this._stack.size() == 0) {
                            lastOpenElement = null;
                            lowercaseLastOpenElementName = null;
                            continue;
                        }
                        lastOpenElement = (FuzzyXMLElementImpl)this._stack.pop();
                        lowercaseLastOpenElementName = lastOpenElement.getName().toLowerCase();
                    }
                } else {
                    FuzzyXMLElement matchingOpenElement = null;
                    for (FuzzyXMLElement nonCloseElement : this._nonCloseElements) {
                        if (!nonCloseElement.getName().equalsIgnoreCase(lowercaseCloseTagName)) continue;
                        matchingOpenElement = nonCloseElement;
                    }
                    if (matchingOpenElement == null) {
                        if (showMismatchError) {
                            this.fireErrorEvent(offset, end - offset, Messages.getMessage("error.noStartTag", tagName), null);
                        }
                        this._stack.push(lastOpenElement);
                        return;
                    }
                    if (showMismatchError) {
                        this.fireErrorEvent(lastOpenElement.getOffset(), lastOpenElement.getLength(), "Missing </" + lastOpenElement.getName() + "> tag", null);
                    }
                    this._stack.push(lastOpenElement);
                    this.handleCloseTag(offset, offset, "/" + lastOpenElement.getName(), false);
                    lastOpenElement = (FuzzyXMLElementImpl)this._stack.pop();
                    lowercaseLastOpenElementName = lastOpenElement.getName().toLowerCase();
                }
            }
        }
        if (lastOpenElement != null) {
            if (lastOpenElement.getChildren().length == 0) {
                // empty if block
            }
            lastOpenElement.setLength(end - lastOpenElement.getOffset());
            if (closeTagMatches) {
                lastOpenElement.setCloseTagOffset(offset);
                lastOpenElement.setCloseTagLength(end - offset - 2);
                lastOpenElement.setCloseNameOffset(text.indexOf(tagName));
            }
            this._nonCloseElements.remove(lastOpenElement);
            if (lastOpenElement.getParentNode() == null) {
                this._roots.add(lastOpenElement);
                for (FuzzyXMLElement error : this._nonCloseElements) {
                    if (!showMismatchError) continue;
                    this.fireErrorEvent(error.getOffset(), error.getLength(), Messages.getMessage("error.noCloseTag", error.getName()), error);
                }
            } else {
                ((FuzzyXMLElementImpl)lastOpenElement.getParentNode()).appendChildWithNoCheck(lastOpenElement);
            }
        }
    }

    private void checkAttributeValue(FuzzyXMLAttribute attr) {
        String str = attr.getRawValue();
        if (str != null) {
            if (attr.hasNestedTag()) {
                str = str.replaceAll("<[^>]*>", "");
            }
            str = str.replaceAll("&[^&; \"]+;", " ");
            Matcher invalidStringMatcher = this._invalidStringPattern.matcher(str);
            while (invalidStringMatcher.find()) {
                String invalidPart = invalidStringMatcher.group();
                this.fireErrorEvent(attr.getParentNode().getOffset() + attr.getValueDataOffset() + 1, attr.getValueDataLength(), "The character '" + invalidPart + "' must be escaped.", attr);
            }
        }
    }

    private void handleEmptyTag(int offset, int end, boolean synthetic) {
        this.closeAutocloseTags();
        TagInfo info = this.parseTagContents(this._originalSource.substring(offset + 1, end - 1));
        FuzzyXMLNode parent = this.getParent();
        FuzzyXMLElementImpl element = new FuzzyXMLElementImpl(parent, info.name, offset, end - offset, info.nameOffset);
        if (parent == null) {
            this._roots.add(element);
        } else {
            ((FuzzyXMLElement)parent).appendChild(element);
        }
        AttrInfo[] attrs = info.getAttrs();
        for (int i = 0; i < attrs.length; ++i) {
            FuzzyXMLAttributeImpl attr = this.createFuzzyXMLAttribute(element, offset, attrs[i]);
            element.appendChild(attr);
        }
        element.setSynthetic(synthetic);
        this.checkElement(element);
    }

    protected void checkElement(FuzzyXMLElement element) {
        for (FuzzyXMLAttribute attr : element.getAttributes()) {
            if (!this._wellFormedRequired) {
                if (WodHtmlUtils.isWOTag((FuzzyXMLElement)((FuzzyXMLElement)attr.getParentNode()))) continue;
                this._stack.push(attr.getParentNode());
                this._parse(attr.getValue(), element.getOffset() + attr.getValueDataOffset() + 1, true, true);
                FuzzyXMLNode poppedNode = this._stack.pop();
                if (poppedNode == attr.getParentNode()) continue;
                this._stack.push(poppedNode);
                continue;
            }
            this.checkAttributeValue(attr);
        }
    }

    private void handleComment(int offset, int end, String text) {
        this.closeAutocloseTags();
        FuzzyXMLNode parent = this.getParent();
        FuzzyXMLCommentImpl comment = new FuzzyXMLCommentImpl(parent, text, offset, end - offset);
        if (parent == null) {
            this._roots.add(comment);
        } else {
            ((FuzzyXMLElement)parent).appendChild(comment);
        }
        this._stack.push(comment);
        this._parse(text.replaceFirst("<[^>]+-->$", ""), offset, true, true);
        FuzzyXMLNode poppedNode = this._stack.pop();
        if (poppedNode != comment) {
            this._stack.push(poppedNode);
        }
    }

    private void handleStartTag(int offset, int end, boolean synthetic) {
        TagInfo info;
        this.closeAutocloseTags();
        String tagContents = this._originalSource.substring(offset, end);
        if (tagContents.startsWith("<")) {
            tagContents = tagContents.substring(1);
        }
        if (tagContents.endsWith(">")) {
            tagContents = tagContents.substring(0, tagContents.length() - 1);
        }
        FuzzyXMLElementImpl element = (info = this.parseTagContents(tagContents)).name.equalsIgnoreCase("script") ? new FuzzyXMLScriptImpl(this.getParent(), info.name, offset, end - offset, info.nameOffset) : (info.name.equalsIgnoreCase("style") ? new FuzzyXMLStyleImpl(this.getParent(), info.name, offset, end - offset, info.nameOffset) : new FuzzyXMLElementImpl(this.getParent(), info.name, offset, end - offset, info.nameOffset));
        this.handleStartTag(element, info, offset, end);
        element.setSynthetic(synthetic);
    }

    protected FuzzyXMLAttributeImpl createFuzzyXMLAttribute(FuzzyXMLElement element, int offset, AttrInfo attrInfo) {
        int colonIndex;
        String namespace = null;
        String name = attrInfo.name;
        if (name != null && (colonIndex = name.indexOf(58)) != -1) {
            namespace = name.substring(0, colonIndex);
            name = name.substring(colonIndex + 1);
        }
        if (this._wellFormedRequired) {
            FuzzyXMLAttributeImpl attr = new FuzzyXMLAttributeImpl(element, namespace, name, FuzzyXMLUtil.decode(attrInfo.value, false), attrInfo.rawValue, attrInfo.offset + offset, attrInfo.end - attrInfo.offset + 1, attrInfo.valueOffset);
            attr.setHasNestedTag(attrInfo.hasNestedTag);
            attr.setQuoteCharacter(attrInfo.quote);
            return attr;
        }
        FuzzyXMLAttributeImpl attr = new FuzzyXMLAttributeImpl(element, namespace, name, attrInfo.value, attrInfo.rawValue, attrInfo.offset + offset, attrInfo.end - attrInfo.offset + 1, attrInfo.valueOffset);
        attr.setHasNestedTag(attrInfo.hasNestedTag);
        attr.setQuoteCharacter(attrInfo.quote);
        if (attrInfo.value.indexOf(34) >= 0 || attrInfo.value.indexOf(39) >= 0 || attrInfo.value.indexOf(60) >= 0 || attrInfo.value.indexOf(62) >= 0 || attrInfo.value.indexOf(38) >= 0) {
            attr.setEscape(false);
        }
        return attr;
    }

    private void handleStartTag(FuzzyXMLElement element, TagInfo info, int offset, int end) {
        AttrInfo[] attrs = info.getAttrs();
        for (int i = 0; i < attrs.length; ++i) {
            element.appendChild(this.createFuzzyXMLAttribute(element, offset, attrs[i]));
        }
        this._stack.push(element);
        this._nonCloseElements.add(element);
        this.checkElement(element);
    }

    private FuzzyXMLNode getParent() {
        if (this._stack.size() == 0) {
            return null;
        }
        return (FuzzyXMLNode)this._stack.get(this._stack.size() - 1);
    }

    private TagInfo parseTagContents(String text) {
        Range trimmedRange = Range.trimmedRange(text);
        if ((text = trimmedRange.trim(text)).endsWith("/")) {
            text = text.substring(0, text.length() - 1);
        }
        TagInfo info = new TagInfo();
        if (FuzzyXMLUtil.getSpaceIndex(text) != -1) {
            info.name = text.substring(0, FuzzyXMLUtil.getSpaceIndex(text)).trim();
            info.nameOffset = trimmedRange.getOffset();
            this.parseAttributeContents(info, text);
        } else {
            info.name = text;
        }
        return info;
    }

    private void parseAttributeContents(TagInfo info, String text) {
        AttributeParseState state = AttributeParseState.Start;
        StringBuffer tokenBuffer = new StringBuffer();
        String name = null;
        char quoteCharacter = '\u0000';
        int start = -1;
        int valueOffset = -1;
        boolean escape = false;
        boolean hasNestedTag = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (state == AttributeParseState.Start && FuzzyXMLUtil.isWhitespace(c)) {
                state = AttributeParseState.BeforeAttributeName;
                continue;
            }
            if (state == AttributeParseState.BeforeAttributeName && !FuzzyXMLUtil.isWhitespace(c)) {
                if (start == -1) {
                    start = i;
                }
                state = AttributeParseState.InAttributeName;
                tokenBuffer.append(c);
                continue;
            }
            if (state == AttributeParseState.InAttributeName) {
                if (c == '=') {
                    state = AttributeParseState.AfterAttributeName;
                    name = tokenBuffer.toString().trim();
                    tokenBuffer.setLength(0);
                    valueOffset = -1;
                    continue;
                }
                tokenBuffer.append(c);
                continue;
            }
            if (state == AttributeParseState.AfterAttributeName && !FuzzyXMLUtil.isWhitespace(c)) {
                if (valueOffset == -1) {
                    valueOffset = i;
                }
                if (c == '\'' || c == '\"') {
                    quoteCharacter = c;
                } else {
                    quoteCharacter = '\u0000';
                    tokenBuffer.append(c);
                }
                state = AttributeParseState.InAttributeValue;
                continue;
            }
            if (state == AttributeParseState.InAttributeValue) {
                if (c == quoteCharacter && escape) {
                    tokenBuffer.append(c);
                    escape = false;
                    continue;
                }
                if (c == quoteCharacter || quoteCharacter == '\u0000' && FuzzyXMLUtil.isWhitespace(c)) {
                    AttrInfo attr = new AttrInfo();
                    attr.name = FuzzyXMLUtil.decode(name, this._isHTML);
                    attr.rawValue = tokenBuffer.toString();
                    attr.value = FuzzyXMLUtil.decode(attr.rawValue, this._isHTML);
                    attr.valueOffset = valueOffset;
                    attr.offset = start;
                    attr.end = i + 1;
                    attr.quote = quoteCharacter;
                    attr.hasNestedTag = hasNestedTag;
                    info.addAttr(attr);
                    tokenBuffer.setLength(0);
                    state = AttributeParseState.BeforeAttributeName;
                    start = -1;
                    hasNestedTag = false;
                    continue;
                }
                if (c == '\\') {
                    if (escape) {
                        tokenBuffer.append(c);
                        escape = false;
                        continue;
                    }
                    escape = true;
                    continue;
                }
                if (c == '<') {
                    hasNestedTag = true;
                    state = AttributeParseState.InNestedTag;
                    tokenBuffer.append(c);
                    continue;
                }
                if (escape) {
                    tokenBuffer.append('\\');
                    escape = false;
                }
                tokenBuffer.append(c);
                continue;
            }
            if (state != AttributeParseState.InNestedTag) continue;
            tokenBuffer.append(c);
            if (c != '>') continue;
            state = AttributeParseState.InAttributeValue;
        }
        if ((state == AttributeParseState.InAttributeValue || state == AttributeParseState.InNestedTag) && quoteCharacter == '\u0000') {
            AttrInfo attr = new AttrInfo();
            attr.name = FuzzyXMLUtil.decode(name, this._isHTML);
            attr.rawValue = tokenBuffer.toString();
            attr.value = FuzzyXMLUtil.decode(attr.rawValue, this._isHTML);
            attr.valueOffset = valueOffset;
            attr.offset = start;
            attr.end = text.length();
            attr.quote = quoteCharacter;
            attr.hasNestedTag = hasNestedTag;
            info.addAttr(attr);
        }
        if (state != AttributeParseState.InAttributeValue || quoteCharacter != '\u0000') {
            // empty if block
        }
    }

    public static class Range {
        private int _offset;
        private int _length;

        public int getOffset() {
            return this._offset;
        }

        public int getLength() {
            return this._length;
        }

        public String trim(String str) {
            return str.substring(this._offset, this._offset + this._length);
        }

        public static Range trimmedRange(String str) {
            int i = 0;
            int length = str.length();
            Range r = new Range();
            for (i = 0; i < length && str.charAt(i) <= ' '; ++i) {
            }
            r._offset = i;
            for (i = length - 1; i > r._offset && str.charAt(i) <= ' '; --i) {
            }
            r._length = i - r._offset + 1;
            return r;
        }
    }

    private class AttrInfo {
        private String name;
        private String value;
        private String rawValue;
        private int offset;
        private int valueOffset;
        private int end;
        private char quote;
        private boolean hasNestedTag;

        private AttrInfo() {
        }
    }

    private class TagInfo {
        private String name;
        private int nameOffset;
        private ArrayList<AttrInfo> attrs = new ArrayList();

        private TagInfo() {
        }

        public void addAttr(AttrInfo attr) {
            AttrInfo[] info = this.getAttrs();
            for (int i = 0; i < info.length; ++i) {
                if (!info[i].name.equals(attr.name)) continue;
                return;
            }
            this.attrs.add(attr);
        }

        public AttrInfo[] getAttrs() {
            return this.attrs.toArray(new AttrInfo[this.attrs.size()]);
        }
    }

    private static enum AttributeParseState {
        Start,
        BeforeAttributeName,
        InAttributeName,
        AfterAttributeName,
        InAttributeValue,
        InNestedTag;

    }
}

