/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.ui.view;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.navigator.ShowInNavigatorAction;
import org.objectstyle.wolips.baseforuiplugins.utils.WorkbenchUtilities;
import org.objectstyle.wolips.core.resources.IWOLipsResource;
import org.objectstyle.wolips.ui.view.RelatedContentProvider;
import org.objectstyle.wolips.ui.view.RelatedLabelProvider;

public final class RelatedView
extends ViewPart
implements ISelectionListener,
IPartListener {
    private TableViewer _viewer;
    private Action _doubleClickAction;
    private Action _openInEditorAction;
    private Action _showInNavigatorAction;

    public void createPartControl(Composite parent) {
        Composite viewerContainer = new Composite(parent, 0);
        this._viewer = new TableViewer(viewerContainer, 66308);
        this._viewer.getTable().setLinesVisible(false);
        RelatedContentProvider relatedContentProvider = new RelatedContentProvider();
        this._viewer.setContentProvider((IContentProvider)relatedContentProvider);
        RelatedLabelProvider relatedLabelProvider = new RelatedLabelProvider();
        this._viewer.setLabelProvider((IBaseLabelProvider)relatedLabelProvider);
        relatedContentProvider.setLabelProvider(relatedLabelProvider);
        this._viewer.setSorter(new ViewerSorter());
        TableColumnLayout relatedTableLayout = new TableColumnLayout();
        viewerContainer.setLayout((Layout)relatedTableLayout);
        TableColumn typeColumn = new TableColumn(this._viewer.getTable(), 16384);
        relatedTableLayout.setColumnData((Widget)typeColumn, (ColumnLayoutData)new ColumnPixelData(68));
        TableColumn nameColumn = new TableColumn(this._viewer.getTable(), 16384);
        relatedTableLayout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnWeightData(90, true));
        this._showInNavigatorAction = new ShowInNavigatorAction(this.getViewSite().getPage(), (ISelectionProvider)this._viewer);
        this._doubleClickAction = this._openInEditorAction = new Action(){

            public void run() {
                ISelection selection = RelatedView.this.getViewer().getSelection();
                List list = ((IStructuredSelection)selection).toList();
                for (int i = 0; i < list.size(); ++i) {
                    Object object = list.get(i);
                    if (!(object instanceof IAdaptable)) continue;
                    IWOLipsResource wolipsResource = (IWOLipsResource)((IAdaptable)object).getAdapter(IWOLipsResource.class);
                    if (wolipsResource != null) {
                        wolipsResource.open();
                        continue;
                    }
                    if (!(object instanceof IFile)) continue;
                    WorkbenchUtilities.open((IFile)((IFile)object));
                }
            }
        };
        this._viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RelatedView.this.getDoubleClickAction().run();
            }
        });
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resourceChanged(IResourceChangeEvent event) {
                TableViewer tableViewer = RelatedView.this._viewer;
                synchronized (tableViewer) {
                    IViewSite viewSite = RelatedView.this.getViewSite();
                    if (viewSite == null) {
                        return;
                    }
                    IWorkbenchWindow workbenchWindow = viewSite.getWorkbenchWindow();
                    if (workbenchWindow == null) {
                        return;
                    }
                    Shell shell = workbenchWindow.getShell();
                    if (shell == null) {
                        return;
                    }
                    Display display = shell.getDisplay();
                    if (display == null) {
                        return;
                    }
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TableViewer tableViewer = RelatedView.this.getViewer();
                            if (!tableViewer.getTable().isDisposed()) {
                                tableViewer.refresh(false);
                            }
                        }
                    });
                }
            }
        });
        this.getViewSite().getPage().addSelectionListener((ISelectionListener)this);
        this.getViewSite().getPage().addPartListener((IPartListener)this);
        this.selectionChanged(null, this.getViewSite().getPage().getSelection());
        this.createContextMenu();
    }

    private void createContextMenu() {
        Control menuControl = this._viewer.getControl();
        MenuManager menuMgr = new MenuManager("#PopUp");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RelatedView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(menuControl);
        menuControl.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this._viewer);
    }

    void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this._showInNavigatorAction);
        List list = ((IStructuredSelection)this.getViewer().getSelection()).toList();
        for (int i = 0; i < list.size(); ++i) {
            OpenWithMenu action;
            Object object = list.get(i);
            if (object == null) continue;
            if (object instanceof IResource) {
                IResource resource = (IResource)object;
                action = new OpenWithMenu(this.getViewSite().getPage(), (IAdaptable)resource);
                menu.add((IContributionItem)action);
                continue;
            }
            if (!(object instanceof ICompilationUnit)) continue;
            ICompilationUnit unit = (ICompilationUnit)object;
            action = new OpenWithMenu(this.getViewSite().getPage(), (IAdaptable)unit);
            menu.add((IContributionItem)action);
        }
        menu.add((IContributionItem)new Separator("additions"));
    }

    public void setFocus() {
        this._viewer.getControl().setFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        TableViewer tableViewer = this._viewer;
        synchronized (tableViewer) {
            if (selection != null && selection instanceof IStructuredSelection) {
                IStructuredSelection sel = (IStructuredSelection)selection;
                Object selectedElement = sel.getFirstElement();
                Object viewerInput = this._viewer.getInput();
                if (viewerInput == null || !viewerInput.equals(selectedElement)) {
                    this._viewer.setInput(selectedElement);
                }
            }
        }
    }

    protected TableViewer getViewer() {
        return this._viewer;
    }

    protected Action getDoubleClickAction() {
        return this._doubleClickAction;
    }

    public void partActivated(IWorkbenchPart part) {
        IEditorInput input;
        IContributedContentsView contentsView;
        IWorkbenchPart contributingPart = part instanceof IEditorPart ? part : ((contentsView = (IContributedContentsView)part.getAdapter(IContributedContentsView.class)) != null ? contentsView.getContributingPart() : part);
        if (contributingPart instanceof IEditorPart && (input = ((IEditorPart)contributingPart).getEditorInput()) instanceof IFileEditorInput) {
            this._viewer.setInput((Object)((IFileEditorInput)input).getFile());
        }
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        IEditorInput input;
        IContributedContentsView contentsView;
        IWorkbenchPart contributingPart = part instanceof IEditorPart ? part : ((contentsView = (IContributedContentsView)part.getAdapter(IContributedContentsView.class)) != null ? contentsView.getContributingPart() : part);
        if (contributingPart instanceof IEditorPart && (input = ((IEditorPart)contributingPart).getEditorInput()) instanceof IFileEditorInput) {
            this._viewer.setInput((Object)((IFileEditorInput)input).getFile());
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void dispose() {
        this.getViewSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.getViewSite().getPage().removePartListener((IPartListener)this);
        super.dispose();
    }
}

