/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.builder.internal;

import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.objectstyle.wolips.builder.BuilderPlugin;
import org.objectstyle.wolips.builder.internal.BuildResourceValidator;
import org.objectstyle.wolips.builder.internal.PatternsetDeltaVisitor;
import org.objectstyle.wolips.core.resources.builder.AbstractOldBuilder;

public abstract class AbstractIncrementalProjectBuilder
extends AbstractOldBuilder {
    private ThreadLocal<BuildResourceValidator> _buildResourceValidator = new ThreadLocal();
    private ThreadLocal<PatternsetDeltaVisitor> _patternsetDeltaVisitor = new ThreadLocal();

    public PatternsetDeltaVisitor patternsetDeltaVisitor() {
        PatternsetDeltaVisitor patternsetDeltaVisitor = this._patternsetDeltaVisitor.get();
        if (patternsetDeltaVisitor == null) {
            patternsetDeltaVisitor = new PatternsetDeltaVisitor();
            this._patternsetDeltaVisitor.set(patternsetDeltaVisitor);
        }
        return patternsetDeltaVisitor;
    }

    public BuildResourceValidator buildResourceValidator() {
        BuildResourceValidator buildResourceValidator = this._buildResourceValidator.get();
        if (buildResourceValidator == null) {
            buildResourceValidator = new BuildResourceValidator();
            this._buildResourceValidator.set(buildResourceValidator);
        }
        return buildResourceValidator;
    }

    protected boolean projectNeedsAnUpdate(IResourceDelta delta) {
        BuildResourceValidator buildResourceValidator = this.buildResourceValidator();
        buildResourceValidator.reset();
        PatternsetDeltaVisitor patternsetDeltaVisitor = this.patternsetDeltaVisitor();
        patternsetDeltaVisitor.reset();
        if (delta == null) {
            return false;
        }
        try {
            delta.accept((IResourceDeltaVisitor)patternsetDeltaVisitor);
            if (patternsetDeltaVisitor.isFullBuildRequired()) {
                return true;
            }
            delta.accept((IResourceDeltaVisitor)buildResourceValidator);
        }
        catch (CoreException e) {
            BuilderPlugin.getDefault().log(e);
            return false;
        }
        return buildResourceValidator.isBuildRequired();
    }
}

