/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.goodies.core.mac.jna;

import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;

public interface CoreFoundation
extends Library {
    public static final int kCFStringEncodingUTF8 = 0x8000100;
    public static final int kCFRunLoopRunFinished = 1;
    public static final int kCFRunLoopRunStopped = 2;
    public static final int kCFRunLoopRunTimedOut = 3;
    public static final int kCFRunLoopRunHandledSource = 4;

    public Pointer CFArrayCreate(Pointer var1, Pointer[] var2, int var3, CFArrayCallBacks var4);

    public Pointer CFArrayCreate(Pointer[] var1);

    public Pointer CFArrayCreate(String[] var1);

    public Pointer CFRetain(Pointer var1);

    public Pointer CFRunLoopGetCurrent();

    public Pointer CFRunLoopGetMain();

    public void CFRunLoopRun();

    public int CFRunLoopRunInMode(Pointer var1, double var2, boolean var4);

    public void CFRunLoopStop(Pointer var1);

    public Pointer CFStringCreateWithCString(Pointer var1, String var2, int var3);

    public Pointer CFStringCreateWithCString(String var1);

    public String getLastError();

    public String strerror(int var1);

    public static class CoreFoundationWrapper
    implements CoreFoundation {
        private static final CoreFoundation coreFoundation = (CoreFoundation)Native.loadLibrary((String)"CoreFoundation", CoreFoundation.class);
        private static final CoreFoundationWrapper wrapper = new CoreFoundationWrapper();

        public static CoreFoundationWrapper defaultInstance() {
            return wrapper;
        }

        private CoreFoundationWrapper() {
        }

        @Override
        public Pointer CFArrayCreate(Pointer allocator, Pointer[] values, int numValues, CFArrayCallBacks callBacks) {
            return coreFoundation.CFArrayCreate(allocator, values, numValues, callBacks);
        }

        @Override
        public Pointer CFArrayCreate(Pointer[] values) {
            return coreFoundation.CFArrayCreate(null, values, values.length, null);
        }

        @Override
        public Pointer CFArrayCreate(String[] stringVals) {
            Pointer[] values = new Pointer[stringVals.length];
            for (int i = 0; i < stringVals.length; ++i) {
                values[i] = this.CFStringCreateWithCString(stringVals[i]);
            }
            return this.CFArrayCreate(values);
        }

        @Override
        public Pointer CFRetain(Pointer pointer) {
            return coreFoundation.CFRetain(pointer);
        }

        @Override
        public Pointer CFRunLoopGetCurrent() {
            return coreFoundation.CFRunLoopGetCurrent();
        }

        @Override
        public Pointer CFRunLoopGetMain() {
            return coreFoundation.CFRunLoopGetMain();
        }

        @Override
        public void CFRunLoopRun() {
            coreFoundation.CFRunLoopRun();
        }

        @Override
        public int CFRunLoopRunInMode(Pointer mode, double interval, boolean returnAfterSourceHandled) {
            return coreFoundation.CFRunLoopRunInMode(mode, interval, returnAfterSourceHandled);
        }

        @Override
        public void CFRunLoopStop(Pointer pointer) {
            coreFoundation.CFRunLoopStop(pointer);
        }

        @Override
        public Pointer CFStringCreateWithCString(Pointer allocator, String string, int encoding) {
            return coreFoundation.CFStringCreateWithCString(allocator, string, encoding);
        }

        @Override
        public Pointer CFStringCreateWithCString(String string) {
            return this.CFStringCreateWithCString(null, string, 0x8000100);
        }

        @Override
        public String getLastError() {
            return this.strerror(Native.getLastError());
        }

        @Override
        public String strerror(int errnum) {
            return coreFoundation.strerror(errnum);
        }
    }

    public static interface CFArrayRetainCallBack {
        public void callback(Pointer var1);
    }

    public static interface CFArrayReleaseCallBack {
        public void callback(Pointer var1);
    }

    public static class CFArrayRef
    extends Structure {
    }

    public static interface CFArrayEqualCallBack {
        public void callback(Pointer var1, Pointer var2);
    }

    public static interface CFArrayCopyDescriptionCallBack {
        public void callback(Pointer var1);
    }

    public static class CFArrayCallBacks
    extends Structure {
        public int version;
        public CFArrayRetainCallBack retain;
        public CFArrayReleaseCallBack release;
        public CFArrayCopyDescriptionCallBack copyDescription;
        public CFArrayEqualCallBack equal;
    }

    public static class CFAllocatorRef
    extends Structure {
    }

    public static interface CFAllocatorCopyDescriptionCallBack
    extends Callback {
        public void callback(Pointer var1);
    }

    public static interface CFAllocationRetainCallback
    extends Callback {
        public void callback(Pointer var1);
    }

    public static interface CFAllocationReleaseCallaback
    extends Callback {
        public void callback(Pointer var1);
    }
}

