/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eogenerator.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.objectstyle.wolips.eogenerator.core.model.EOGenerateWorkspaceJob;
import org.objectstyle.wolips.eogenerator.core.model.IEOGeneratorListener;
import org.objectstyle.wolips.eogenerator.core.model.MarkerEOGeneratorListener;
import org.objectstyle.wolips.eogenerator.ui.DialogEOGeneratorListener;

public class GenerateAction
implements IObjectActionDelegate {
    private ISelection _selection;
    private IWorkbenchPart _workbenchPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this._workbenchPart = targetPart;
    }

    public void run(IAction action) {
        try {
            IStructuredSelection selection = (IStructuredSelection)this._selection;
            if (selection != null && !selection.isEmpty()) {
                IFile eogenFile = (IFile)selection.getFirstElement();
                EOGenerateWorkspaceJob generateJob = new EOGenerateWorkspaceJob(eogenFile);
                generateJob.addListener((IEOGeneratorListener)new MarkerEOGeneratorListener());
                generateJob.addListener((IEOGeneratorListener)new DialogEOGeneratorListener(this._workbenchPart.getSite().getShell()));
                generateJob.schedule();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            MessageDialog.openError((Shell)new Shell(), (String)"Generate Failed", (String)t.getMessage());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this._selection = selection;
    }
}

