/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wooeditor;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.objectstyle.wolips.baseforuiplugins.AbstractBaseUIActivator;
import org.objectstyle.wolips.wodclipse.core.woo.WooModel;
import org.osgi.framework.BundleContext;

public class WooeditorPlugin
extends AbstractBaseUIActivator
implements IResourceChangeListener {
    private static WooeditorPlugin plugin;
    private FormColors formColors;
    private IWorkspace workspace;

    public static WooeditorPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.objectstyle.wolips.wooeditor", (String)path);
    }

    public WooeditorPlugin() {
        plugin = this;
        this.workspace = ResourcesPlugin.getWorkspace();
    }

    public FormColors getFormColors(Display display) {
        if (this.formColors == null) {
            this.formColors = new FormColors(display);
            this.formColors.markShared();
        }
        return this.formColors;
    }

    public Image getImage(String key) {
        return this.getImageRegistry().get(key);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            IResourceDelta delta = event.getDelta();
            final ArrayList changed = new ArrayList();
            IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta visitingDelta) {
                    if (visitingDelta.getKind() != 4 || (visitingDelta.getFlags() & 0x100000) == 0) {
                        return true;
                    }
                    IResource resource = visitingDelta.getResource();
                    if (resource.getProjectRelativePath().toString().equals("build")) {
                        return false;
                    }
                    if (resource.getType() == 2 && "wo".equalsIgnoreCase(resource.getFileExtension())) {
                        changed.add(resource);
                    }
                    return true;
                }
            };
            try {
                delta.accept(visitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (IResource resource : changed) {
                        IFolder folder = (IFolder)resource;
                        try {
                            String charset = folder.getDefaultCharset();
                            IPath wooPath = folder.getLocation().addTrailingSeparator().append(folder.getName() + "o");
                            IFile wooFile = WooeditorPlugin.this.workspace.getRoot().getFileForLocation(wooPath);
                            WooModel.updateEncoding((IFile)wooFile, (String)charset);
                            for (IResource element : folder.members()) {
                                IFile file;
                                if (element.getType() != 1 || !(file = (IFile)element).getFileExtension().matches("(xml|html|xhtml|wod)") || file.getCharset().equals(charset)) continue;
                                System.out.println("WooeditorPlugin.run: setting encoding of " + file + " to " + charset);
                                file.setCharset(charset, null);
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.workspace.addResourceChangeListener((IResourceChangeListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.formColors != null) {
                this.formColors.dispose();
                this.formColors = null;
            }
        }
        finally {
            super.stop(context);
        }
        this.workspace.removeResourceChangeListener((IResourceChangeListener)this);
        plugin = null;
    }
}

