/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.actions;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.objectstyle.wolips.baseforuiplugins.utils.ErrorUtils;
import org.objectstyle.wolips.eomodeler.actions.EMAction;
import org.objectstyle.wolips.eomodeler.actions.GenerateSQLDialog;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.utils.EOModelUtils;

public class GenerateSQLAction
extends EMAction {
    @Override
    public void run(IAction action) {
        try {
            IStructuredSelection selection = this.getSelection();
            if (selection != null) {
                EOModel model = null;
                boolean modelSelected = false;
                LinkedList<String> entityNames = new LinkedList<String>();
                Iterator selectionIter = selection.iterator();
                while (!modelSelected && selectionIter.hasNext()) {
                    Object obj = selectionIter.next();
                    EOEntity entity = EOModelUtils.getRelatedEntity(obj);
                    if (entity != null) {
                        model = entity.getModel();
                        entityNames.add(entity.getName());
                        continue;
                    }
                    model = EOModelUtils.getRelatedModel(obj);
                    if (model == null) continue;
                    modelSelected = true;
                }
                if (modelSelected) {
                    entityNames = null;
                }
                if (model != null) {
                    if (model.isDirty()) {
                        MessageDialog.openWarning((Shell)this.getWindow().getShell(), (String)"Model Not Saved", (String)"Your model has unsaved changes. Unsaved changes will not be reflected in generated SQL.");
                    }
                    GenerateSQLDialog dialog = new GenerateSQLDialog(this.getWindow().getShell(), model, entityNames);
                    dialog.open();
                }
            }
        }
        catch (Throwable e) {
            ErrorUtils.openErrorDialog((Shell)Display.getDefault().getActiveShell(), (Throwable)e);
        }
    }
}

