/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.attributes;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.objectstyle.wolips.baseforuiplugins.utils.ErrorUtils;
import org.objectstyle.wolips.baseforuiplugins.utils.KeyComboBoxCellEditor;
import org.objectstyle.wolips.baseforuiplugins.utils.TableRowDoubleClickHandler;
import org.objectstyle.wolips.baseforuiplugins.utils.WOTableViewer;
import org.objectstyle.wolips.baseforuiplugins.utils.WOTextCellEditor;
import org.objectstyle.wolips.eomodeler.Activator;
import org.objectstyle.wolips.eomodeler.actions.NewAttributeAction;
import org.objectstyle.wolips.eomodeler.core.model.EOAttribute;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.editors.attributes.EOAttributesCellModifier;
import org.objectstyle.wolips.eomodeler.editors.attributes.EOAttributesContentProvider;
import org.objectstyle.wolips.eomodeler.editors.attributes.EOAttributesLabelProvider;
import org.objectstyle.wolips.eomodeler.editors.attributes.EOAttributesViewerSorter;
import org.objectstyle.wolips.eomodeler.utils.StayEditingCellEditorListener;
import org.objectstyle.wolips.eomodeler.utils.TableRefreshPropertyListener;
import org.objectstyle.wolips.eomodeler.utils.TableRowRefreshPropertyListener;
import org.objectstyle.wolips.eomodeler.utils.TableUtils;
import org.objectstyle.wolips.eomodeler.utils.TriStateCellEditor;

public class EOAttributesTableViewer
extends Composite
implements ISelectionProvider {
    private WOTableViewer myAttributesTableViewer;
    private EOEntity myEntity;
    private TableRefreshPropertyListener myAttributesChangedRefresher;
    private TableRefreshPropertyListener myParentChangedRefresher;
    private TableRowRefreshPropertyListener myTableRowRefresher;

    public EOAttributesTableViewer(Composite _parent, int _style) {
        super(_parent, _style);
        TableColumn allowNullColumn;
        TableColumn classPropertyColumn;
        TableColumn lockingColumn;
        this.setLayout((Layout)new FillLayout());
        this.myAttributesTableViewer = TableUtils.createTableViewer((Composite)this, 65538, "EOAttribute", EOAttribute.class.getName(), (IStructuredContentProvider)new EOAttributesContentProvider(), null, (ViewerSorter)new EOAttributesViewerSorter(EOAttribute.class.getName()));
        this.myAttributesTableViewer.setLabelProvider((IBaseLabelProvider)new EOAttributesLabelProvider((TableViewer)this.myAttributesTableViewer, EOAttribute.class.getName()));
        new DoubleClickNewAttributeHandler((TableViewer)this.myAttributesTableViewer).attach();
        this.myAttributesChangedRefresher = new TableRefreshPropertyListener("AttributesChanged", (TableViewer)this.myAttributesTableViewer);
        this.myParentChangedRefresher = new TableRefreshPropertyListener("ParentChanged", (TableViewer)this.myAttributesTableViewer);
        this.myTableRowRefresher = new TableRowRefreshPropertyListener((TableViewer)this.myAttributesTableViewer);
        Table attributesTable = this.myAttributesTableViewer.getTable();
        attributesTable.setLayoutData((Object)new GridData(1808));
        TableColumn primaryKeyColumn = TableUtils.getColumn((TableViewer)this.myAttributesTableViewer, EOAttribute.class.getName(), "primaryKey");
        if (primaryKeyColumn != null) {
            primaryKeyColumn.setText("");
            primaryKeyColumn.setImage(Activator.getDefault().getImageRegistry().get("primaryKey"));
        }
        if ((lockingColumn = TableUtils.getColumn((TableViewer)this.myAttributesTableViewer, EOAttribute.class.getName(), "usedForLocking")) != null) {
            lockingColumn.setText("");
            lockingColumn.setImage(Activator.getDefault().getImageRegistry().get("locking"));
        }
        if ((classPropertyColumn = TableUtils.getColumn((TableViewer)this.myAttributesTableViewer, EOAttribute.class.getName(), "classProperty")) != null) {
            classPropertyColumn.setText("");
            classPropertyColumn.setImage(Activator.getDefault().getImageRegistry().get("classProperty"));
        }
        if ((allowNullColumn = TableUtils.getColumn((TableViewer)this.myAttributesTableViewer, EOAttribute.class.getName(), "allowsNull")) != null) {
            allowNullColumn.setText("");
            allowNullColumn.setImage(Activator.getDefault().getImageRegistry().get("allowNull"));
        }
        TableUtils.sort((TableViewer)this.myAttributesTableViewer, "name");
        CellEditor[] cellEditors = new CellEditor[TableUtils.getColumnsForTableNamed(EOAttribute.class.getName()).length];
        KeyComboBoxCellEditor prototypeCellEditor = new KeyComboBoxCellEditor((Composite)attributesTable, new String[0], 8);
        prototypeCellEditor.getComboBox().setVisibleItemCount(10);
        TableUtils.setCellEditor(EOAttribute.class.getName(), "prototype", (CellEditor)prototypeCellEditor, cellEditors);
        TableUtils.setCellEditor(EOAttribute.class.getName(), "name", (CellEditor)new WOTextCellEditor((Composite)attributesTable), cellEditors);
        TableUtils.setCellEditor(EOAttribute.class.getName(), "columnName", (CellEditor)new WOTextCellEditor((Composite)attributesTable), cellEditors);
        this.updateCellEditors(cellEditors);
        this.myAttributesTableViewer.setCellModifier((ICellModifier)new EOAttributesCellModifier((TableViewer)this.myAttributesTableViewer, cellEditors));
        this.myAttributesTableViewer.setCellEditors(cellEditors);
        new StayEditingCellEditorListener((TableViewer)this.myAttributesTableViewer, EOAttribute.class.getName(), "prototype");
        new StayEditingCellEditorListener((TableViewer)this.myAttributesTableViewer, EOAttribute.class.getName(), "name");
        new StayEditingCellEditorListener((TableViewer)this.myAttributesTableViewer, EOAttribute.class.getName(), "columnName");
    }

    public void setEntity(EOEntity _entity) {
        if (this.myEntity != null) {
            this.myAttributesChangedRefresher.stop();
            this.myEntity.removePropertyChangeListener("parent", this.myParentChangedRefresher);
            this.myEntity.removePropertyChangeListener("attributes", this.myAttributesChangedRefresher);
            this.myEntity.removePropertyChangeListener("attribute", this.myTableRowRefresher);
        }
        this.myEntity = _entity;
        if (this.myEntity != null) {
            TableColumn allowsNullColumn;
            TableColumn nameColumn;
            this.myAttributesTableViewer.setInput((Object)this.myEntity);
            this.updateCellEditors(this.myAttributesTableViewer.getCellEditors());
            TableUtils.packTableColumns((TableViewer)this.myAttributesTableViewer);
            TableColumn prototypeColumn = TableUtils.getColumn((TableViewer)this.myAttributesTableViewer, EOAttribute.class.getName(), "prototype");
            if (prototypeColumn != null) {
                prototypeColumn.setWidth(Math.max(prototypeColumn.getWidth(), 100));
            }
            if ((nameColumn = TableUtils.getColumn((TableViewer)this.myAttributesTableViewer, EOAttribute.class.getName(), "name")) != null) {
                nameColumn.setWidth(Math.max(nameColumn.getWidth(), 100));
            }
            if ((allowsNullColumn = TableUtils.getColumn((TableViewer)this.myAttributesTableViewer, EOAttribute.class.getName(), "allowsNull")) != null) {
                allowsNullColumn.setWidth(Math.max(allowsNullColumn.getWidth(), 30));
            }
            this.myEntity.addPropertyChangeListener("parent", this.myParentChangedRefresher);
            this.myAttributesChangedRefresher.start();
            this.myEntity.addPropertyChangeListener("attributes", this.myAttributesChangedRefresher);
            this.myEntity.addPropertyChangeListener("attribute", this.myTableRowRefresher);
        }
    }

    public EOEntity getEntity() {
        return this.myEntity;
    }

    public WOTableViewer getTableViewer() {
        return this.myAttributesTableViewer;
    }

    protected void updateCellEditors(CellEditor[] _cellEditors) {
        Table attributesTable = this.myAttributesTableViewer.getTable();
        if (this.myEntity != null && this.myEntity.isPrototype()) {
            TableUtils.setCellEditor(EOAttribute.class.getName(), "primaryKey", new TriStateCellEditor((Composite)attributesTable), _cellEditors);
            TableUtils.setCellEditor(EOAttribute.class.getName(), "classProperty", new TriStateCellEditor((Composite)attributesTable), _cellEditors);
            TableUtils.setCellEditor(EOAttribute.class.getName(), "usedForLocking", new TriStateCellEditor((Composite)attributesTable), _cellEditors);
            TableUtils.setCellEditor(EOAttribute.class.getName(), "allowsNull", new TriStateCellEditor((Composite)attributesTable), _cellEditors);
        } else {
            TableUtils.setCellEditor(EOAttribute.class.getName(), "primaryKey", (CellEditor)new CheckboxCellEditor((Composite)attributesTable), _cellEditors);
            TableUtils.setCellEditor(EOAttribute.class.getName(), "classProperty", (CellEditor)new CheckboxCellEditor((Composite)attributesTable), _cellEditors);
            TableUtils.setCellEditor(EOAttribute.class.getName(), "usedForLocking", (CellEditor)new CheckboxCellEditor((Composite)attributesTable), _cellEditors);
            TableUtils.setCellEditor(EOAttribute.class.getName(), "allowsNull", (CellEditor)new CheckboxCellEditor((Composite)attributesTable), _cellEditors);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener _listener) {
        this.myAttributesTableViewer.addSelectionChangedListener(_listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener _listener) {
        this.myAttributesTableViewer.removeSelectionChangedListener(_listener);
    }

    public ISelection getSelection() {
        return this.myAttributesTableViewer.getSelection();
    }

    public void setSelection(ISelection _selection) {
        this.myAttributesTableViewer.setSelection(_selection);
    }

    public void dispose() {
        this.myAttributesChangedRefresher.stop();
        super.dispose();
    }

    protected class DoubleClickNewAttributeHandler
    extends TableRowDoubleClickHandler {
        public DoubleClickNewAttributeHandler(TableViewer _viewer) {
            super(_viewer);
        }

        protected void emptyDoubleSelectionOccurred() {
            try {
                NewAttributeAction.createAttribute(EOAttributesTableViewer.this.getEntity());
            }
            catch (Throwable e) {
                ErrorUtils.openErrorDialog((Shell)Display.getDefault().getActiveShell(), (Throwable)e);
            }
        }

        protected void doubleSelectionOccurred(ISelection _selection) {
        }
    }
}

