/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.entity;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.objectstyle.wolips.eomodeler.Messages;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.InheritanceType;
import org.objectstyle.wolips.eomodeler.editors.entity.EOEntityLabelProvider;
import org.objectstyle.wolips.eomodeler.editors.entity.EOEntityListContentProvider;
import org.objectstyle.wolips.eomodeler.editors.entity.InheritanceTypeContentProvider;
import org.objectstyle.wolips.eomodeler.editors.entity.InheritanceTypeLabelProvider;
import org.objectstyle.wolips.eomodeler.editors.relationship.EOModelLabelProvider;
import org.objectstyle.wolips.eomodeler.editors.relationship.EOModelListContentProvider;

public class SubclassEntityDialog
extends Dialog {
    private EOModel _sourceModel;
    private EOModel _destinationModel;
    private String _entityName;
    private EOEntity _parentEntity;
    private InheritanceType _inheritanceType;
    private String _restrictingQualifier;
    private Text _entityNameText;
    private ComboViewer _destinationModelViewer;
    private ComboViewer _parentEntityViewer;
    private ComboViewer _inheritanceTypeViewer;
    private Text _restrictingQualifierText;

    public SubclassEntityDialog(Shell shell, EOModel sourceModel, EOEntity parentEntity, EOModel destinationModel) {
        super(shell);
        this._sourceModel = sourceModel;
        this._parentEntity = parentEntity;
        this._destinationModel = destinationModel;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("SubclassEntityDialog.title"));
    }

    public String getEntityName() {
        return this._entityName;
    }

    public EOModel getDestinationModel() {
        return this._destinationModel;
    }

    public EOEntity getParentEntity() {
        return this._parentEntity;
    }

    public InheritanceType getInheritanceType() {
        return this._inheritanceType;
    }

    public String getRestrictingQualifier() {
        return this._restrictingQualifier;
    }

    protected void _updateSubclassFromUI() {
        if (this._entityNameText != null) {
            this._entityName = this._entityNameText.getText();
        }
        if (this._destinationModelViewer != null) {
            this._destinationModel = (EOModel)((IStructuredSelection)this._destinationModelViewer.getSelection()).getFirstElement();
        }
        if (this._parentEntityViewer != null) {
            this._parentEntity = (EOEntity)((IStructuredSelection)this._parentEntityViewer.getSelection()).getFirstElement();
        }
        if (this._inheritanceTypeViewer != null) {
            this._inheritanceType = (InheritanceType)((IStructuredSelection)this._inheritanceTypeViewer.getSelection()).getFirstElement();
        }
        if (this._restrictingQualifierText != null) {
            if (this._parentEntity != null && (this._inheritanceType == InheritanceType.SINGLE_TABLE || this._inheritanceType == InheritanceType.VERTICAL)) {
                this._restrictingQualifierText.setEnabled(true);
                this._restrictingQualifier = this._restrictingQualifierText.getText();
            } else {
                this._restrictingQualifierText.setEnabled(false);
                this._restrictingQualifier = null;
            }
        }
    }

    protected void _setEntityName(String entityName) {
        this._entityName = entityName;
    }

    protected void _setParentEntity(EOEntity parentEntity) {
        this._parentEntity = parentEntity;
    }

    protected Control createDialogArea(Composite parent) {
        Composite subclassDialogArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 15;
        gridLayout.marginLeft = 15;
        gridLayout.marginRight = 15;
        gridLayout.horizontalSpacing = 15;
        subclassDialogArea.setLayout((Layout)gridLayout);
        Label parentEntityLabel = new Label(subclassDialogArea, 0);
        parentEntityLabel.setText(Messages.getString("SubclassEntityDialog.parentEntityLabel"));
        this._parentEntityViewer = new ComboViewer(subclassDialogArea);
        this._parentEntityViewer.setContentProvider((IContentProvider)new EOEntityListContentProvider(false, false, false));
        this._parentEntityViewer.setLabelProvider((IBaseLabelProvider)new EOEntityLabelProvider());
        this._parentEntityViewer.setSorter(new ViewerSorter());
        this._parentEntityViewer.setInput((Object)this._sourceModel);
        this._parentEntityViewer.getCombo().setLayoutData((Object)new GridData(768));
        this._parentEntityViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent _event) {
                SubclassEntityDialog.this._updateSubclassFromUI();
            }
        });
        if (this._parentEntity != null) {
            this._parentEntityViewer.setSelection((ISelection)new StructuredSelection((Object)this._parentEntity));
        }
        Label inheritanceTypeLabel = new Label(subclassDialogArea, 0);
        inheritanceTypeLabel.setText(Messages.getString("SubclassEntityDialog.inheritanceTypeLabel"));
        this._inheritanceTypeViewer = new ComboViewer(subclassDialogArea);
        this._inheritanceTypeViewer.setLabelProvider((IBaseLabelProvider)new InheritanceTypeLabelProvider());
        this._inheritanceTypeViewer.setContentProvider((IContentProvider)new InheritanceTypeContentProvider());
        this._inheritanceTypeViewer.setSorter(new ViewerSorter());
        this._inheritanceTypeViewer.setInput((Object)InheritanceType.INHERITANCE_TYPES);
        this._inheritanceTypeViewer.getCombo().setLayoutData((Object)new GridData(768));
        this._inheritanceTypeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent _event) {
                SubclassEntityDialog.this._updateSubclassFromUI();
            }
        });
        this._inheritanceTypeViewer.setSelection((ISelection)new StructuredSelection((Object)InheritanceType.SINGLE_TABLE));
        Label destinationModelLabel = new Label(subclassDialogArea, 0);
        destinationModelLabel.setText(Messages.getString("SubclassEntityDialog.destinationModelLabel"));
        this._destinationModelViewer = new ComboViewer(subclassDialogArea);
        this._destinationModelViewer.setContentProvider((IContentProvider)new EOModelListContentProvider());
        this._destinationModelViewer.setLabelProvider((IBaseLabelProvider)new EOModelLabelProvider());
        this._destinationModelViewer.setSorter(new ViewerSorter());
        this._destinationModelViewer.setInput((Object)this._destinationModel);
        this._destinationModelViewer.getCombo().setLayoutData((Object)new GridData(768));
        this._destinationModelViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent _event) {
                SubclassEntityDialog.this._updateSubclassFromUI();
            }
        });
        if (this._destinationModel != null) {
            this._destinationModelViewer.setSelection((ISelection)new StructuredSelection((Object)this._destinationModel));
        }
        Label subclassNameLabel = new Label(subclassDialogArea, 0);
        subclassNameLabel.setText(Messages.getString("SubclassEntityDialog.entityNameLabel"));
        this._entityNameText = new Text(subclassDialogArea, 2048);
        this._entityNameText.setLayoutData((Object)new GridData(768));
        this._entityNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent _e) {
                SubclassEntityDialog.this._updateSubclassFromUI();
            }
        });
        this._entityNameText.setText(this._destinationModel.findUnusedEntityName(this._parentEntity.getName()));
        Label restrictingQualifierLabel = new Label(subclassDialogArea, 0);
        restrictingQualifierLabel.setText(Messages.getString("SubclassEntityDialog.restrictingQualifierLabel"));
        this._restrictingQualifierText = new Text(subclassDialogArea, 2048);
        this._restrictingQualifierText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent _e) {
                SubclassEntityDialog.this._updateSubclassFromUI();
            }
        });
        this._restrictingQualifierText.setLayoutData((Object)new GridData(768));
        this._updateSubclassFromUI();
        return subclassDialogArea;
    }
}

