/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.model;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.eomodeler.Messages;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.utils.NamingConvention;
import org.objectstyle.wolips.eomodeler.utils.FormUtils;
import org.objectstyle.wolips.eomodeler.utils.StringLabelProvider;
import org.objectstyle.wolips.eomodeler.utils.UglyFocusHackWorkaroundListener;

public class EOModelAdvancedEditorSection
extends AbstractPropertySection
implements ModifyListener,
ISelectionChangedListener,
SelectionListener {
    private EOModel _model;
    private ComboViewer _entityCase;
    private ComboViewer _entitySeparator;
    private Text _entityPrefix;
    private Text _entitySuffix;
    private ComboViewer _attributeCase;
    private ComboViewer _attributeSeparator;
    private Text _attributePrefix;
    private Text _attributeSuffix;
    private Button _reverseEngineered;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite form = this.getWidgetFactory().createFlatFormComposite(parent);
        FormLayout formLayout = new FormLayout();
        form.setLayout((Layout)formLayout);
        Composite topForm = FormUtils.createForm(this.getWidgetFactory(), form);
        this.getWidgetFactory().createCLabel(topForm, Messages.getString("EOModel.attributeNamingConvention.prefix"), 0);
        this._attributePrefix = new Text(topForm, 2048);
        this._attributePrefix.setLayoutData((Object)new GridData(768));
        UglyFocusHackWorkaroundListener.addListener(this._attributePrefix);
        this.getWidgetFactory().createCLabel(topForm, Messages.getString("EOModel.attributeNamingConvention.suffix"), 0);
        this._attributeSuffix = new Text(topForm, 2048);
        this._attributeSuffix.setLayoutData((Object)new GridData(768));
        UglyFocusHackWorkaroundListener.addListener(this._attributeSuffix);
        this.getWidgetFactory().createCLabel(topForm, Messages.getString("EOModel.attributeNamingConvention.case"), 0);
        Combo attributeCaseCombo = new Combo(topForm, 0x800808);
        this._attributeCase = new ComboViewer(attributeCaseCombo);
        this._attributeCase.setLabelProvider((IBaseLabelProvider)new StringLabelProvider());
        this._attributeCase.setContentProvider((IContentProvider)new ArrayContentProvider());
        this._attributeCase.setInput((Object)NamingConvention.Case.values());
        attributeCaseCombo.setLayoutData((Object)new GridData(768));
        this.getWidgetFactory().createCLabel(topForm, Messages.getString("EOModel.attributeNamingConvention.separator"), 0);
        Combo attributeSeparatorCombo = new Combo(topForm, 0x800808);
        this._attributeSeparator = new ComboViewer(attributeSeparatorCombo);
        this._attributeSeparator.setLabelProvider((IBaseLabelProvider)new StringLabelProvider());
        this._attributeSeparator.setContentProvider((IContentProvider)new ArrayContentProvider());
        this._attributeSeparator.setInput((Object)NamingConvention.Separator.values());
        attributeSeparatorCombo.setLayoutData((Object)new GridData(768));
        this.getWidgetFactory().createCLabel(topForm, Messages.getString("EOModel.entityNamingConvention.prefix"), 0);
        this._entityPrefix = new Text(topForm, 2048);
        this._entityPrefix.setLayoutData((Object)new GridData(768));
        UglyFocusHackWorkaroundListener.addListener(this._entityPrefix);
        this.getWidgetFactory().createCLabel(topForm, Messages.getString("EOModel.entityNamingConvention.suffix"), 0);
        this._entitySuffix = new Text(topForm, 2048);
        this._entitySuffix.setLayoutData((Object)new GridData(768));
        UglyFocusHackWorkaroundListener.addListener(this._entitySuffix);
        this.getWidgetFactory().createCLabel(topForm, Messages.getString("EOModel.entityNamingConvention.case"), 0);
        Combo entityCaseCombo = new Combo(topForm, 0x800808);
        this._entityCase = new ComboViewer(entityCaseCombo);
        this._entityCase.setLabelProvider((IBaseLabelProvider)new StringLabelProvider());
        this._entityCase.setContentProvider((IContentProvider)new ArrayContentProvider());
        this._entityCase.setInput((Object)NamingConvention.Case.values());
        entityCaseCombo.setLayoutData((Object)new GridData(768));
        this.getWidgetFactory().createCLabel(topForm, Messages.getString("EOModel.entityNamingConvention.separator"), 0);
        Combo entitySeparatorCombo = new Combo(topForm, 0x800808);
        this._entitySeparator = new ComboViewer(entitySeparatorCombo);
        this._entitySeparator.setLabelProvider((IBaseLabelProvider)new StringLabelProvider());
        this._entitySeparator.setContentProvider((IContentProvider)new ArrayContentProvider());
        this._entitySeparator.setInput((Object)NamingConvention.Separator.values());
        entitySeparatorCombo.setLayoutData((Object)new GridData(768));
        this.getWidgetFactory().createCLabel(topForm, "", 0);
        this._reverseEngineered = this.getWidgetFactory().createButton(topForm, "Reverse Engineered", 32);
        this._reverseEngineered.setLayoutData((Object)new GridData(768));
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (ComparisonUtils.equals((Object)selection, (Object)this.getSelection())) {
            return;
        }
        super.setInput(part, selection);
        this.disposeBindings();
        Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
        this._model = (EOModel)selectedObject;
        if (this._model != null) {
            String attributePrefix = this._model.getAttributeNamingConvention().getPrefix();
            String attributeSuffix = this._model.getAttributeNamingConvention().getSuffix();
            this._attributePrefix.setText(attributePrefix == null ? "" : attributePrefix);
            this._attributeSuffix.setText(attributeSuffix == null ? "" : attributeSuffix);
            this._attributeCase.setSelection((ISelection)new StructuredSelection((Object)this._model.getAttributeNamingConvention().getCase()));
            this._attributeSeparator.setSelection((ISelection)new StructuredSelection((Object)this._model.getAttributeNamingConvention().getSeparator()));
            String entityPrefix = this._model.getEntityNamingConvention().getPrefix();
            String entitySuffix = this._model.getEntityNamingConvention().getSuffix();
            this._entityPrefix.setText(entityPrefix == null ? "" : entityPrefix);
            this._entitySuffix.setText(entitySuffix == null ? "" : entitySuffix);
            this._entityCase.setSelection((ISelection)new StructuredSelection((Object)this._model.getEntityNamingConvention().getCase()));
            this._entitySeparator.setSelection((ISelection)new StructuredSelection((Object)this._model.getEntityNamingConvention().getSeparator()));
            this._reverseEngineered.setSelection(this._model.isReverseEngineered());
            this._attributePrefix.addModifyListener((ModifyListener)this);
            this._attributeSuffix.addModifyListener((ModifyListener)this);
            this._attributeCase.addSelectionChangedListener((ISelectionChangedListener)this);
            this._attributeSeparator.addSelectionChangedListener((ISelectionChangedListener)this);
            this._entityPrefix.addModifyListener((ModifyListener)this);
            this._entitySuffix.addModifyListener((ModifyListener)this);
            this._entityCase.addSelectionChangedListener((ISelectionChangedListener)this);
            this._entitySeparator.addSelectionChangedListener((ISelectionChangedListener)this);
            this._reverseEngineered.addSelectionListener((SelectionListener)this);
        }
    }

    protected void disposeBindings() {
        if (this._attributePrefix != null && !this._attributePrefix.isDisposed()) {
            this._attributePrefix.removeModifyListener((ModifyListener)this);
        }
        if (this._attributeSuffix != null && !this._attributeSuffix.isDisposed()) {
            this._attributeSuffix.removeModifyListener((ModifyListener)this);
        }
        if (this._attributeCase != null && !this._attributeCase.getCombo().isDisposed()) {
            this._attributeCase.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (this._attributeSeparator != null && !this._attributeSeparator.getCombo().isDisposed()) {
            this._attributeSeparator.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (this._entityPrefix != null && !this._entityPrefix.isDisposed()) {
            this._entityPrefix.removeModifyListener((ModifyListener)this);
        }
        if (this._entitySuffix != null && !this._entitySuffix.isDisposed()) {
            this._entitySuffix.removeModifyListener((ModifyListener)this);
        }
        if (this._entityCase != null && !this._entityCase.getCombo().isDisposed()) {
            this._entityCase.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (this._entitySeparator != null && !this._entitySeparator.getCombo().isDisposed()) {
            this._entitySeparator.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (this._reverseEngineered != null && !this._reverseEngineered.isDisposed()) {
            this._reverseEngineered.removeSelectionListener((SelectionListener)this);
        }
    }

    public void dispose() {
        this.disposeBindings();
        super.dispose();
    }

    public void modifyText(ModifyEvent e) {
        this.syncToModel();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.syncToModel();
    }

    public void syncToModel() {
        NamingConvention.Case attributeCase = (NamingConvention.Case)((Object)((IStructuredSelection)this._attributeCase.getSelection()).getFirstElement());
        NamingConvention.Separator attributeSeparator = (NamingConvention.Separator)((Object)((IStructuredSelection)this._attributeSeparator.getSelection()).getFirstElement());
        this._model.setAttributeNamingConvention(new NamingConvention(attributeCase, attributeSeparator, this._attributePrefix.getText(), this._attributeSuffix.getText()));
        NamingConvention.Case entityCase = (NamingConvention.Case)((Object)((IStructuredSelection)this._entityCase.getSelection()).getFirstElement());
        NamingConvention.Separator entitySeparator = (NamingConvention.Separator)((Object)((IStructuredSelection)this._entitySeparator.getSelection()).getFirstElement());
        this._model.setEntityNamingConvention(new NamingConvention(entityCase, entitySeparator, this._entityPrefix.getText(), this._entitySuffix.getText()));
        this._model.setReverseEngineered(this._reverseEngineered.getSelection());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.syncToModel();
    }

    public void widgetSelected(SelectionEvent e) {
        this.syncToModel();
    }
}

