/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.qualifier;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOAggregateQualifier;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOQualifier;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOTruePredicate;
import org.objectstyle.wolips.eomodeler.editors.qualifier.AbstractQualifierTypeEditor;
import org.objectstyle.wolips.eomodeler.editors.qualifier.EOQualifierEditor;
import org.objectstyle.wolips.eomodeler.editors.qualifier.IQualifierEditorListener;
import org.objectstyle.wolips.eomodeler.editors.qualifier.IQualifierTypeEditorListener;

public abstract class AggregateQualifierTypeEditor
extends AbstractQualifierTypeEditor
implements IQualifierEditorListener {
    private List<EOQualifierEditor> _editors = new LinkedList<EOQualifierEditor>();

    public AggregateQualifierTypeEditor(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(1, false);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
    }

    @Override
    public void setQualifier(EOQualifier qualifier) {
        List<Object> qualifiers;
        for (EOQualifierEditor editor : this._editors) {
            editor.dispose();
        }
        this._editors.clear();
        if (qualifier instanceof EOAggregateQualifier) {
            EOAggregateQualifier andQualifier = (EOAggregateQualifier)qualifier;
            qualifiers = andQualifier.getQualifiers();
        } else {
            qualifiers = new LinkedList<EOQualifier>();
            qualifiers.add(qualifier);
        }
        if (qualifiers.size() == 1) {
            qualifiers.add(new EOTruePredicate());
        }
        for (EOQualifier eOQualifier : qualifiers) {
            EOQualifierEditor childEditor = this.createEditor();
            childEditor.setQualifier(eOQualifier);
            this._editors.add(childEditor);
        }
    }

    @Override
    public EOQualifier getQualifier() {
        EOQualifier qualifier;
        LinkedList<EOQualifier> qualifiers = new LinkedList<EOQualifier>();
        for (EOQualifierEditor editor : this._editors) {
            EOQualifier childQualifier = editor.getQualifier();
            if (childQualifier == null) continue;
            qualifiers.add(childQualifier);
        }
        if (qualifiers.isEmpty()) {
            qualifier = null;
        } else if (qualifiers.size() == 1) {
            qualifier = (EOQualifier)qualifiers.get(0);
        } else {
            EOAggregateQualifier aggregateQualifier = this.createQualifier();
            aggregateQualifier.getQualifiers().addAll(qualifiers);
            qualifier = aggregateQualifier;
        }
        return qualifier;
    }

    protected EOQualifierEditor createEditor() {
        EOQualifierEditor childEditor = new EOQualifierEditor(this, 0);
        childEditor.setLayoutData(new GridData(768));
        childEditor.setQualifierEditorListener(this);
        return childEditor;
    }

    @Override
    public void qualifierAddedAbove(EOQualifierEditor editor) {
        int index = this._editors.indexOf(editor);
        EOQualifierEditor newEditor = this.createEditor();
        this._editors.add(index, newEditor);
        newEditor.moveAbove((Control)editor);
        this.layout(true, true);
        this.getParent().layout(true, true);
    }

    @Override
    public void qualifierAddedBelow(EOQualifierEditor editor) {
        int index = this._editors.indexOf(editor);
        EOQualifierEditor newEditor = this.createEditor();
        this._editors.add(index + 1, newEditor);
        newEditor.moveBelow((Control)editor);
        this.layout(true, true);
        this.getParent().layout(true, true);
    }

    @Override
    public void qualifierRemoved(EOQualifierEditor editor) {
        IQualifierTypeEditorListener listener;
        this._editors.remove(editor);
        editor.dispose();
        if (this._editors.size() == 1 && (listener = this.getQualifierTypeEditorListener()) != null) {
            listener.qualifierTypeChanged(this);
        }
        this.layout(true, true);
        this.getParent().layout(true, true);
    }

    protected abstract EOAggregateQualifier createQualifier();
}

