/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.relationship;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.eomodeler.Activator;
import org.objectstyle.wolips.eomodeler.Messages;
import org.objectstyle.wolips.eomodeler.core.model.EODeleteRule;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOJoinSemantic;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.EORelationship;
import org.objectstyle.wolips.eomodeler.core.model.EORelationshipPath;
import org.objectstyle.wolips.eomodeler.editors.entity.EOEntityLabelProvider;
import org.objectstyle.wolips.eomodeler.editors.entity.EOEntityListContentProvider;
import org.objectstyle.wolips.eomodeler.editors.relationship.EODeleteRuleContentProvider;
import org.objectstyle.wolips.eomodeler.editors.relationship.EODeleteRuleLabelProvider;
import org.objectstyle.wolips.eomodeler.editors.relationship.EOJoinSemanticContentProvider;
import org.objectstyle.wolips.eomodeler.editors.relationship.EOJoinSemanticLabelProvider;
import org.objectstyle.wolips.eomodeler.editors.relationship.EOModelLabelProvider;
import org.objectstyle.wolips.eomodeler.editors.relationship.EOModelListContentProvider;
import org.objectstyle.wolips.eomodeler.editors.relationship.JoinsTableEditor;
import org.objectstyle.wolips.eomodeler.utils.BooleanUpdateValueStrategy;
import org.objectstyle.wolips.eomodeler.utils.ComboViewerBinding;
import org.objectstyle.wolips.eomodeler.utils.FormUtils;
import org.objectstyle.wolips.eomodeler.utils.UglyFocusHackWorkaroundListener;

public class EORelationshipBasicEditorSection
extends AbstractPropertySection {
    private EORelationship _relationship;
    private Text _nameText;
    private Text _definitionText;
    private Button _toOneButton;
    private Button _toManyButton;
    private Button _optionalButton;
    private Button _mandatoryButton;
    private JoinsTableEditor _joinsTableEditor;
    private ComboViewer _deleteRuleComboViewer;
    private ComboViewer _modelComboViewer;
    private ComboViewer _joinSemanticComboViewer;
    private ComboViewer _entityComboViewer;
    private JoinsListener _joinsListener = new JoinsListener();
    private DataBindingContext _bindingContext;
    private ComboViewerBinding _deleteRuleBinding;
    private ComboViewerBinding _joinSemanticBinding;
    private ComboViewerBinding _modelBinding;
    private ComboViewerBinding _entityBinding;
    private Button _classPropertyButton;

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite form = this.getWidgetFactory().createFlatFormComposite(parent);
        FormLayout formLayout = new FormLayout();
        form.setLayout((Layout)formLayout);
        Composite topForm = FormUtils.createForm(this.getWidgetFactory(), form);
        this.getWidgetFactory().createCLabel(topForm, Messages.getString("EORelationship.name"), 0);
        this._nameText = new Text(topForm, 2048);
        GridData nameFieldLayoutData = new GridData(768);
        this._nameText.setLayoutData((Object)nameFieldLayoutData);
        UglyFocusHackWorkaroundListener.addListener(this._nameText);
        this.getWidgetFactory().createCLabel(topForm, Messages.getString("EORelationship.definition"), 0);
        this._definitionText = new Text(topForm, 2048);
        GridData definitionFieldLayoutData = new GridData(768);
        this._definitionText.setLayoutData((Object)definitionFieldLayoutData);
        UglyFocusHackWorkaroundListener.addListener(this._definitionText);
        this.getWidgetFactory().createCLabel(topForm, Messages.getString("EORelationship.settings"), 0);
        Composite settingsComposite = new Composite(topForm, 0);
        settingsComposite.setBackground(topForm.getBackground());
        FillLayout settingsLayout = new FillLayout(256);
        settingsLayout.spacing = 10;
        settingsComposite.setLayout((Layout)settingsLayout);
        GridData settingsLayoutData = new GridData(768);
        settingsLayoutData.heightHint = 25;
        settingsComposite.setLayoutData((Object)settingsLayoutData);
        this._toManyButton = new Button(settingsComposite, 0x800002);
        this._toManyButton.setToolTipText(Messages.getString("EORelationship.toMany"));
        this._toManyButton.setImage(Activator.getDefault().getImageRegistry().get("toMany"));
        this._classPropertyButton = new Button(settingsComposite, 0x800002);
        this._classPropertyButton.setToolTipText(Messages.getString("EORelationship.classProperty"));
        this._classPropertyButton.setImage(Activator.getDefault().getImageRegistry().get("classProperty"));
        this._optionalButton = new Button(settingsComposite, 0x800002);
        this._optionalButton.setToolTipText(Messages.getString("EORelationship.optional"));
        this._optionalButton.setImage(Activator.getDefault().getImageRegistry().get("allowNull"));
        this.getWidgetFactory().createCLabel(topForm, Messages.getString("EORelationship.deleteRule"), 0);
        Combo deleteRuleCombo = new Combo(topForm, 0x800808);
        this._deleteRuleComboViewer = new ComboViewer(deleteRuleCombo);
        this._deleteRuleComboViewer.setLabelProvider((IBaseLabelProvider)new EODeleteRuleLabelProvider());
        this._deleteRuleComboViewer.setContentProvider((IContentProvider)new EODeleteRuleContentProvider());
        this._deleteRuleComboViewer.setInput((Object)EODeleteRule.DELETE_RULES);
        this._deleteRuleComboViewer.setSelection((ISelection)new StructuredSelection((Object)EODeleteRule.NULLIFY));
        GridData deleteRuleComboLayoutData = new GridData(768);
        deleteRuleCombo.setLayoutData((Object)deleteRuleComboLayoutData);
        this.getWidgetFactory().createCLabel(topForm, Messages.getString("EORelationship.model"), 0);
        Combo modelCombo = new Combo(topForm, 0x800808);
        this._modelComboViewer = new ComboViewer(modelCombo);
        this._modelComboViewer.setLabelProvider((IBaseLabelProvider)new EOModelLabelProvider());
        this._modelComboViewer.setContentProvider((IContentProvider)new EOModelListContentProvider());
        this._modelComboViewer.addSelectionChangedListener((ISelectionChangedListener)new ModelSelectionListener());
        GridData modelRuleComboLayoutData = new GridData(768);
        modelCombo.setLayoutData((Object)modelRuleComboLayoutData);
        this.getWidgetFactory().createCLabel(topForm, Messages.getString("EORelationship.destination"), 0);
        Combo entityCombo = new Combo(topForm, 0x800808);
        this._entityComboViewer = new ComboViewer(entityCombo);
        this._entityComboViewer.setLabelProvider((IBaseLabelProvider)new EOEntityLabelProvider());
        this._entityComboViewer.setContentProvider((IContentProvider)new EOEntityListContentProvider(false, true, false));
        GridData entityComboLayoutData = new GridData(768);
        entityCombo.setLayoutData((Object)entityComboLayoutData);
        Combo joinSemanticCombo = new Combo(topForm, 0x800808);
        this._joinSemanticComboViewer = new ComboViewer(joinSemanticCombo);
        this._joinSemanticComboViewer.setLabelProvider((IBaseLabelProvider)new EOJoinSemanticLabelProvider());
        this._joinSemanticComboViewer.setContentProvider((IContentProvider)new EOJoinSemanticContentProvider());
        this._joinSemanticComboViewer.setInput((Object)EOJoinSemantic.JOIN_SEMANTICS);
        this._joinSemanticComboViewer.setSelection((ISelection)new StructuredSelection((Object)EOJoinSemantic.INNER));
        GridData joinSemanticLayoutData = new GridData(768);
        joinSemanticLayoutData.verticalAlignment = 128;
        joinSemanticCombo.setLayoutData((Object)joinSemanticLayoutData);
        this._joinsTableEditor = new JoinsTableEditor(topForm, 0);
        this._joinsTableEditor.setBackground(topForm.getBackground());
        GridData joinsTableLayoutData = new GridData(1808);
        this._joinsTableEditor.setLayoutData(joinsTableLayoutData);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (ComparisonUtils.equals((Object)selection, (Object)this.getSelection())) {
            return;
        }
        super.setInput(part, selection);
        EORelationship relationship = null;
        Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
        if (selectedObject instanceof EORelationship) {
            relationship = (EORelationship)selectedObject;
        } else if (selectedObject instanceof EORelationshipPath) {
            relationship = ((EORelationshipPath)selectedObject).getChildRelationship();
        }
        if (!ComparisonUtils.equals((Object)relationship, (Object)this._relationship)) {
            this.disposeBindings();
            this._relationship = relationship;
            if (this._relationship != null) {
                this._relationship.addPropertyChangeListener("joins", this._joinsListener);
                this._relationship.addPropertyChangeListener("definition", this._joinsListener);
                this._joinsTableEditor.setRelationship(this._relationship);
                this._modelComboViewer.setInput((Object)this._relationship);
                this._entityComboViewer.setInput((Object)this._relationship);
                EOEntity destinationEntity = this._relationship.getDestination();
                if (destinationEntity != null) {
                    this._modelComboViewer.setSelection((ISelection)new StructuredSelection((Object)destinationEntity.getModel()));
                }
                this._bindingContext = new DataBindingContext();
                this._bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int)24), BeansObservables.observeValue((Object)this._relationship, (String)"name"), null, null);
                this._bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this._definitionText, (int)24), BeansObservables.observeValue((Object)this._relationship, (String)"definition"), null, null);
                this._bindingContext.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._toManyButton), BeansObservables.observeValue((Object)this._relationship, (String)"toMany"), null, (UpdateValueStrategy)new BooleanUpdateValueStrategy());
                this._bindingContext.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._optionalButton), BeansObservables.observeValue((Object)this._relationship, (String)"optional"), null, (UpdateValueStrategy)new BooleanUpdateValueStrategy());
                this._bindingContext.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._classPropertyButton), BeansObservables.observeValue((Object)this._relationship, (String)"classProperty"), null, (UpdateValueStrategy)new BooleanUpdateValueStrategy());
                this._deleteRuleBinding = new ComboViewerBinding(this._deleteRuleComboViewer, this._relationship, "deleteRule", null, null, null);
                this._joinSemanticBinding = new ComboViewerBinding(this._joinSemanticComboViewer, this._relationship, "joinSemantic", this._relationship.getEntity().getModel().getModelGroup(), "models", null);
                this._entityBinding = new ComboViewerBinding(this._entityComboViewer, this._relationship, "destination", this._relationship.getEntity().getModel(), "entities", null);
                this.updateModelAndEntityCombosEnabled();
            }
        }
    }

    protected void updateModelAndEntityCombosEnabled() {
        boolean joinsEnabled = !this._relationship.isFlattened();
        boolean hasJoins = this._relationship.getJoins().size() != 0;
        boolean enabled = !hasJoins && joinsEnabled;
        this._modelComboViewer.getCombo().setEnabled(enabled);
        this._entityComboViewer.getCombo().setEnabled(enabled);
        this._definitionText.setEnabled(!hasJoins);
    }

    protected void updateEntityCombo() {
        IStructuredSelection selection = (IStructuredSelection)this._modelComboViewer.getSelection();
        EOModel selectedModel = (EOModel)selection.getFirstElement();
        this._entityComboViewer.setInput((Object)selectedModel);
    }

    protected void disposeBindings() {
        if (this._relationship != null) {
            this._relationship.removePropertyChangeListener("joins", this._joinsListener);
            this._relationship.removePropertyChangeListener("definition", this._joinsListener);
        }
        if (this._bindingContext != null) {
            this._bindingContext.dispose();
        }
        if (this._deleteRuleBinding != null) {
            this._deleteRuleBinding.dispose();
        }
        if (this._joinSemanticBinding != null) {
            this._joinSemanticBinding.dispose();
        }
        if (this._modelBinding != null) {
            this._modelBinding.dispose();
        }
        if (this._entityBinding != null) {
            this._entityBinding.dispose();
        }
        if (this._joinsTableEditor != null) {
            this._joinsTableEditor.disposeBindings();
        }
    }

    public void dispose() {
        super.dispose();
        this.disposeBindings();
    }

    protected class ModelSelectionListener
    implements ISelectionChangedListener {
        protected ModelSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            EORelationshipBasicEditorSection.this.updateEntityCombo();
        }
    }

    protected class JoinsListener
    implements PropertyChangeListener {
        protected JoinsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            EORelationshipBasicEditorSection.this.updateModelAndEntityCombosEnabled();
        }
    }
}

