/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.variables;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.objectstyle.wolips.baseforplugins.util.WOLipsNatureUtils;
import org.objectstyle.wolips.variables.BuildProperties;
import org.objectstyle.wolips.variables.IBuildPropertiesInitializer;
import org.objectstyle.wolips.variables.VariablesPlugin;

public class BuildPropertiesAdapterFactory
implements IAdapterFactory {
    private Map<IProject, BuildProperties> _cache = new HashMap<IProject, BuildProperties>();

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        IProject project = (IProject)adaptableObject;
        if (!WOLipsNatureUtils.isWOLipsNature((IProject)project)) {
            return null;
        }
        BuildProperties properties = null;
        if (adapterType == BuildProperties.class) {
            properties = this._cache.get(project);
            BuildProperties newProperties = new BuildProperties((IProject)adaptableObject);
            if (properties == null || properties.getModificationStamp() != newProperties.getModificationStamp()) {
                this._cache.put(project, newProperties);
                if (properties != null) {
                    newProperties._copyDefaultsFrom(properties);
                } else {
                    BuildPropertiesAdapterFactory.initializeBuildProperties(newProperties);
                }
                properties = newProperties;
            }
        }
        return properties;
    }

    public Class[] getAdapterList() {
        return new Class[]{BuildProperties.class};
    }

    public static void initializeBuildProperties(BuildProperties buildProperties) {
        IExtension[] extensions;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.objectstyle.wolips.variables.buildPropertiesInitializer");
        for (IExtension extension : extensions = extensionPoint.getExtensions()) {
            IConfigurationElement[] configurationElements;
            for (IConfigurationElement configurationElement : configurationElements = extension.getConfigurationElements()) {
                try {
                    IBuildPropertiesInitializer buildPropertiesInitializer = (IBuildPropertiesInitializer)configurationElement.createExecutableExtension("class");
                    buildPropertiesInitializer.initialize(buildProperties);
                }
                catch (CoreException e) {
                    VariablesPlugin.getDefault().log(e);
                }
            }
        }
    }

    public static void initializeBuildPropertiesDefaults(BuildProperties buildProperties) {
        IExtension[] extensions;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.objectstyle.wolips.variables.buildPropertiesInitializer");
        for (IExtension extension : extensions = extensionPoint.getExtensions()) {
            IConfigurationElement[] configurationElements;
            for (IConfigurationElement configurationElement : configurationElements = extension.getConfigurationElements()) {
                try {
                    IBuildPropertiesInitializer buildPropertiesInitializer = (IBuildPropertiesInitializer)configurationElement.createExecutableExtension("class");
                    buildPropertiesInitializer.initializeDefaults(buildProperties);
                }
                catch (CoreException e) {
                    VariablesPlugin.getDefault().log(e);
                }
            }
        }
    }
}

