/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.launching.variables;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;

public class WorkingDirResolver
implements IDynamicVariableResolver {
    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        if (argument == null) {
            throw new CoreException((IStatus)new Status(4, "org.objectstyle.wolips.launching", 4, "Provide a project name for the working dir variable.", null));
        }
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(argument);
        if (iProject == null || !iProject.exists() || !iProject.isAccessible()) {
            throw new CoreException((IStatus)new Status(4, "org.objectstyle.wolips.launching", 4, "Could not find or open project: " + argument, null));
        }
        ProjectAdapter project = (ProjectAdapter)iProject.getAdapter(ProjectAdapter.class);
        IPath workingDir = null;
        if (project != null) {
            workingDir = project.getWorkingDir();
        }
        if (workingDir == null) {
            throw new CoreException((IStatus)new Status(4, "org.objectstyle.wolips.launching", 4, "Could not find working dir for project: " + argument, null));
        }
        return workingDir.toString();
    }
}

