/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.bindings.api;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.objectstyle.wolips.bindings.api.AbstractApiModelElement;
import org.objectstyle.wolips.bindings.api.And;
import org.objectstyle.wolips.bindings.api.ApiModel;
import org.objectstyle.wolips.bindings.api.Bound;
import org.objectstyle.wolips.bindings.api.Count;
import org.objectstyle.wolips.bindings.api.Gettable;
import org.objectstyle.wolips.bindings.api.IValidation;
import org.objectstyle.wolips.bindings.api.Not;
import org.objectstyle.wolips.bindings.api.Or;
import org.objectstyle.wolips.bindings.api.Settable;
import org.objectstyle.wolips.bindings.api.Unbound;
import org.objectstyle.wolips.bindings.api.Ungettable;
import org.objectstyle.wolips.bindings.api.Unsettable;
import org.w3c.dom.Element;

public abstract class AbstractValidationContainer
extends AbstractApiModelElement
implements IValidation {
    public AbstractValidationContainer(Element element, ApiModel apiModel) {
        super(element, apiModel);
    }

    public List<Unsettable> getUnsettables() {
        List<Element> unsetableElements = this.getChildrenElementsByTagName("unsettable");
        LinkedList<Unsettable> unsettables = new LinkedList<Unsettable>();
        for (int i = 0; i < unsetableElements.size(); ++i) {
            Element unsettableElement = unsetableElements.get(i);
            Unsettable validation = new Unsettable(unsettableElement, this.apiModel);
            unsettables.add(validation);
        }
        return unsettables;
    }

    public List<Settable> getSettables() {
        List<Element> setableElements = this.getChildrenElementsByTagName("settable");
        LinkedList<Settable> settables = new LinkedList<Settable>();
        for (int i = 0; i < setableElements.size(); ++i) {
            Element settableElement = setableElements.get(i);
            Settable settable = new Settable(settableElement, this.apiModel);
            settables.add(settable);
        }
        return settables;
    }

    public List<Ungettable> getUngettables() {
        List<Element> ungetableElements = this.getChildrenElementsByTagName("ungettable");
        LinkedList<Ungettable> ungettables = new LinkedList<Ungettable>();
        for (int i = 0; i < ungetableElements.size(); ++i) {
            Element ungettableElement = ungetableElements.get(i);
            Ungettable validation = new Ungettable(ungettableElement, this.apiModel);
            ungettables.add(validation);
        }
        return ungettables;
    }

    public List<Gettable> getGettables() {
        List<Element> getableElements = this.getChildrenElementsByTagName("gettable");
        LinkedList<Gettable> gettables = new LinkedList<Gettable>();
        for (int i = 0; i < getableElements.size(); ++i) {
            Element gettableElement = getableElements.get(i);
            Gettable gettable = new Gettable(gettableElement, this.apiModel);
            gettables.add(gettable);
        }
        return gettables;
    }

    public List<Unbound> getUnbounds() {
        List<Element> unsetableElements = this.getChildrenElementsByTagName("unbound");
        LinkedList<Unbound> unsettables = new LinkedList<Unbound>();
        for (int i = 0; i < unsetableElements.size(); ++i) {
            Element unboundElement = unsetableElements.get(i);
            Unbound validation = new Unbound(unboundElement, this.apiModel);
            unsettables.add(validation);
        }
        return unsettables;
    }

    public List<Bound> getBounds() {
        List<Element> setableElements = this.getChildrenElementsByTagName("bound");
        LinkedList<Bound> settables = new LinkedList<Bound>();
        for (int i = 0; i < setableElements.size(); ++i) {
            Element boundElement = setableElements.get(i);
            Bound bound = new Bound(boundElement, this.apiModel);
            settables.add(bound);
        }
        return settables;
    }

    public List<And> getAnds() {
        List<Element> andElements = this.getChildrenElementsByTagName("and");
        LinkedList<And> ands = new LinkedList<And>();
        for (int i = 0; i < andElements.size(); ++i) {
            Element andElement = andElements.get(i);
            And and = new And(andElement, this.apiModel);
            ands.add(and);
        }
        return ands;
    }

    public List<Count> getCounts() {
        List<Element> countElements = this.getChildrenElementsByTagName("count");
        LinkedList<Count> counts = new LinkedList<Count>();
        for (int i = 0; i < countElements.size(); ++i) {
            Element countElement = countElements.get(i);
            Count count = new Count(countElement, this.apiModel);
            counts.add(count);
        }
        return counts;
    }

    public List<Or> getOrs() {
        List<Element> orElements = this.getChildrenElementsByTagName("or");
        LinkedList<Or> ors = new LinkedList<Or>();
        for (int i = 0; i < orElements.size(); ++i) {
            Element orElement = orElements.get(i);
            Or or = new Or(orElement, this.apiModel);
            ors.add(or);
        }
        return ors;
    }

    public List<Not> getNots() {
        List<Element> notElements = this.getChildrenElementsByTagName("not");
        LinkedList<Not> nots = new LinkedList<Not>();
        for (int i = 0; i < notElements.size(); ++i) {
            Element notElement = notElements.get(i);
            Not not = new Not(notElement, this.apiModel);
            nots.add(not);
        }
        return nots;
    }

    @Override
    public List<IValidation> getValidationChildren() {
        LinkedList<IValidation> validationChildren = new LinkedList<IValidation>();
        this.addValidationChildren(validationChildren, this.getCounts());
        this.addValidationChildren(validationChildren, this.getAnds());
        this.addValidationChildren(validationChildren, this.getOrs());
        this.addValidationChildren(validationChildren, this.getNots());
        this.addValidationChildren(validationChildren, this.getUnbounds());
        this.addValidationChildren(validationChildren, this.getBounds());
        this.addValidationChildren(validationChildren, this.getUnsettables());
        this.addValidationChildren(validationChildren, this.getSettables());
        this.addValidationChildren(validationChildren, this.getUngettables());
        this.addValidationChildren(validationChildren, this.getGettables());
        return validationChildren;
    }

    protected void addValidationChildren(List<IValidation> allValidationChildren, List<? extends IValidation> validationChildren) {
        if (validationChildren != null) {
            allValidationChildren.addAll(validationChildren);
        }
    }

    @Override
    public void fillInValidationsAffectedByBindingNamed(String bindingName, List<IValidation> validations) {
        List<IValidation> validationChildren = this.getValidationChildren();
        for (int i = 0; i < validationChildren.size(); ++i) {
            validationChildren.get(i).fillInValidationsAffectedByBindingNamed(bindingName, validations);
        }
    }

    @Override
    public boolean isAffectedByBindingNamed(String bindingName) {
        boolean isAffectedByBindingName = false;
        List<IValidation> validationChildren = this.getValidationChildren();
        for (int i = 0; !isAffectedByBindingName && i < validationChildren.size(); ++i) {
            isAffectedByBindingName = validationChildren.get(i).isAffectedByBindingNamed(bindingName);
        }
        return isAffectedByBindingName;
    }

    @Override
    public abstract boolean evaluate(Map<String, String> var1);
}

