/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.bindings.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.objectstyle.wolips.bindings.api.ApiModelException;
import org.objectstyle.wolips.bindings.api.Wo;
import org.objectstyle.wolips.bindings.api.Wodefinitions;
import org.objectstyle.wolips.locate.LocatePlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ApiModel {
    private Document _document;
    private URL _url;
    private Reader _reader;
    private IFile _eclipseFile;
    private File _file;
    private boolean _isDirty;
    private long _lastModified;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiModel(File file) throws ApiModelException {
        this._file = file;
        if (!file.exists() || file.length() == 0L) {
            String javaFileName = LocatePlugin.getDefault().fileNameWithoutExtension(file);
            try (FileWriter writer = new FileWriter(file);){
                writer.write(ApiModel.blankContent(javaFileName));
            }
            catch (IOException e) {
                throw new ApiModelException("Failed to create blank API file.", e);
            }
        }
        this.parse();
    }

    public ApiModel(IFile file) throws ApiModelException {
        this._eclipseFile = file;
        this._file = file.getLocation().toFile();
        if (!file.exists() || file.getLocation().toFile().length() == 0L) {
            String javaFileName = LocatePlugin.getDefault().fileNameWithoutExtension((IResource)file);
            try {
                this._document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(ApiModel.blankContent(javaFileName))));
                this.saveChanges();
            }
            catch (Exception e) {
                throw new ApiModelException("Failed to create blank API file.", e);
            }
        }
        this._lastModified = this._eclipseFile.getModificationStamp();
        this.parse();
    }

    public ApiModel(URL url) throws ApiModelException {
        this._url = url;
        this.parse();
    }

    public ApiModel(Reader reader) throws ApiModelException {
        this._reader = reader;
        this.parse();
    }

    public static String blankContent(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version = \"1.0\" encoding = \"UTF-8\" standalone = \"yes\"?>\n");
        sb.append("<wodefinitions>\n");
        sb.append("    <wo wocomponentcontent = \"false\" class = \"" + name + "\">");
        sb.append("    </wo>\n");
        sb.append("</wodefinitions>\n");
        return sb.toString();
    }

    public IFile getEclipseFile() {
        return this._eclipseFile;
    }

    public String getLocation() {
        String location = this._url != null ? this._url.toExternalForm() : (this._file != null ? this._file.getAbsolutePath() : null);
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseIfNecessary() throws ApiModelException {
        ApiModel apiModel = this;
        synchronized (apiModel) {
            boolean parsed = false;
            if (this._eclipseFile != null) {
                if (this._eclipseFile.getModificationStamp() != this._lastModified) {
                    this.parse();
                    parsed = true;
                }
            } else if (this._file != null && this._file.lastModified() != this._lastModified) {
                this.parse();
                parsed = true;
            }
            return parsed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() throws ApiModelException {
        ApiModel apiModel = this;
        synchronized (apiModel) {
            try {
                if (this._eclipseFile != null) {
                    this._lastModified = this._eclipseFile.getModificationStamp();
                } else if (this._file != null) {
                    this._lastModified = this._file.lastModified();
                }
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                if (this._url != null) {
                    this._document = documentBuilder.parse(this._url.toExternalForm());
                } else if (this._file != null) {
                    StringBuffer apiBuffer = new StringBuffer();
                    try (FileReader apiReader = new FileReader(this._file);){
                        BufferedReader bufferedApiReader = new BufferedReader(apiReader);
                        String line = bufferedApiReader.readLine();
                        if (line != null && line.startsWith("<?")) {
                            apiBuffer.append(line.replaceAll("encoding=\"macintosh\"", "encoding=\"UTF-8\""));
                            apiBuffer.append("\n");
                        }
                        while ((line = bufferedApiReader.readLine()) != null) {
                            apiBuffer.append(line);
                            apiBuffer.append("\n");
                        }
                    }
                    StringReader apiBufferReader = new StringReader(apiBuffer.toString());
                    this._document = documentBuilder.parse(new InputSource(apiBufferReader));
                } else if (this._reader != null) {
                    this._document = documentBuilder.parse(new InputSource(this._reader));
                } else {
                    throw new ApiModelException("There was no file, URL, or reader specified as the location for this API file.");
                }
                this._document.normalize();
            }
            catch (Throwable e) {
                throw new ApiModelException("Failed to parse API file '" + this.getLocation() + "'.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Wodefinitions getWODefinitions() throws ApiModelException {
        ApiModel apiModel = this;
        synchronized (apiModel) {
            this.parseIfNecessary();
            Element element = this._document.getDocumentElement();
            return new Wodefinitions(element, this);
        }
    }

    public Wo getWo() throws ApiModelException {
        Wodefinitions wodefinitions = this.getWODefinitions();
        if (wodefinitions == null) {
            return null;
        }
        return wodefinitions.getWo();
    }

    public void saveChanges() throws ApiModelException {
        if (this._file == null) {
            throw new ApiModelException("You can not saveChanges to an ApiModel that is not backed by a file.");
        }
        try {
            try (FileWriter writer = new FileWriter(this._file);){
                this.saveChanges(writer);
            }
            if (this._eclipseFile != null) {
                try {
                    this._eclipseFile.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {}
            }
        }
        catch (IOException ioe) {
            throw new ApiModelException("Failed to save changes to API file.", ioe);
        }
    }

    public void saveChanges(Writer writer) throws ApiModelException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 4);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("standalone", "yes");
            DOMSource domsource = new DOMSource(this._document);
            StreamResult output = new StreamResult(writer);
            transformer.transform(domsource, output);
            this._isDirty = false;
        }
        catch (Throwable t) {
            throw new ApiModelException("Failed to save API file " + this.getLocation() + ".", t);
        }
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    public void markAsDirty() {
        this._isDirty = true;
    }
}

