/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.bindings.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.objectstyle.wolips.bindings.Activator;
import org.objectstyle.wolips.bindings.wod.BindingValidationRule;
import org.objectstyle.wolips.core.CorePlugin;
import org.objectstyle.wolips.preferences.TableViewerSupport;

public class BindingValidationRulePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer _viewer;
    private List<BindingValidationRule> _model = new ArrayList<BindingValidationRule>();
    private List<BindingValidationRule> _oldModel = new ArrayList<BindingValidationRule>();

    public BindingValidationRulePreferencePage() {
        this.setTitle("Binding Validation Rules");
        this.setDescription("Binding validation rules let you specify the regex for components and the regexes for valid binding values on those components.  For instance, component .*\\.MDT.* and binding value ^localizer\\..* would say that any component with MDT in its name that uses a binding value starting with 'localizer\\.' automatically validates.");
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        TableViewerSupport support = new TableViewerSupport(this._model, parent){

            protected void initTableViewer(TableViewer viewer) {
                Table table = viewer.getTable();
                TableColumn col1 = new TableColumn(table, 16384);
                col1.setText("Component Regex");
                col1.setWidth(150);
                TableColumn col2 = new TableColumn(table, 16384);
                col2.setText("Valid Binding Regex");
                col2.setWidth(150);
            }

            protected Object doAdd() {
                BindingValidationRuleDialog dialog = new BindingValidationRuleDialog(BindingValidationRulePreferencePage.this.getShell());
                if (dialog.open() == 0) {
                    return dialog.getBindingValidationRule();
                }
                return null;
            }

            protected void doEdit(Object obj) {
                BindingValidationRule bindingValidationRule = (BindingValidationRule)obj;
                BindingValidationRuleDialog dialog = new BindingValidationRuleDialog(BindingValidationRulePreferencePage.this.getShell(), bindingValidationRule);
                if (dialog.open() == 0) {
                    BindingValidationRule newElement = dialog.getBindingValidationRule();
                    bindingValidationRule.setTypeRegex(newElement.getTypeRegex());
                    bindingValidationRule.setValidBindingRegex(newElement.getValidBindingRegex());
                }
            }

            protected ITableLabelProvider createLabelProvider() {
                return new ITableLabelProvider(){

                    public Image getColumnImage(Object _tagShortcut, int columnIndex) {
                        return null;
                    }

                    public String getColumnText(Object bindingValidationRule, int columnIndex) {
                        switch (columnIndex) {
                            case 0: {
                                return ((BindingValidationRule)bindingValidationRule).getTypeRegex();
                            }
                            case 1: {
                                return ((BindingValidationRule)bindingValidationRule).getValidBindingRegex();
                            }
                        }
                        return bindingValidationRule.toString();
                    }

                    public void addListener(ILabelProviderListener listener) {
                    }

                    public void dispose() {
                    }

                    public boolean isLabelProperty(Object bindingValidationRule, String property) {
                        return false;
                    }

                    public void removeListener(ILabelProviderListener listener) {
                    }
                };
            }
        };
        this._viewer = support.getTableViewer();
        this._model.addAll(BindingValidationRule.fromPreferenceString(this.getPreferenceStore().getString("BindingValidationRules")));
        this.syncModels();
        this._viewer.refresh();
        return support.getControl();
    }

    protected void performDefaults() {
        this._model.clear();
        this._model.addAll(BindingValidationRule.fromPreferenceString(this.getPreferenceStore().getDefaultString("BindingValidationRules")));
        this._viewer.refresh();
        this.processChange();
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("BindingValidationRules", BindingValidationRule.toPreferenceString(this._model));
        this.processChange();
        CorePlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void syncModels() {
        try {
            this._oldModel.clear();
            for (int i = 0; i < this._model.size(); ++i) {
                this._oldModel.add(this._model.get(i).clone());
            }
        }
        catch (Exception ex) {
            CorePlugin.getDefault().log((Throwable)ex);
        }
    }

    public void init(IWorkbench workbench) {
    }

    private void processChange() {
        if (BindingValidationRule.hasChange(this._oldModel, this._model)) {
            this.syncModels();
        }
    }

    private class BindingValidationRuleDialog
    extends Dialog {
        private Text _typeRegex;
        private Text _validBindingRegex;
        private BindingValidationRule _bindingValidationRule;

        public BindingValidationRuleDialog(Shell parentShell) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        public BindingValidationRuleDialog(Shell parentShell, BindingValidationRule bindingValidationRule) {
            super(parentShell);
            this._bindingValidationRule = bindingValidationRule;
        }

        protected Point getInitialSize() {
            Point size = super.getInitialSize();
            size.x = 300;
            return size;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText("Tag Shortcut");
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(1808));
            composite.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label(composite, 0);
            label.setText("Component Regex");
            this._typeRegex = new Text(composite, 2048);
            if (this._bindingValidationRule != null) {
                this._typeRegex.setText(this._bindingValidationRule.getTypeRegex());
            }
            this._typeRegex.setLayoutData((Object)new GridData(768));
            label = new Label(composite, 0);
            label.setText("Valid Binding Regex");
            this._validBindingRegex = new Text(composite, 2048);
            if (this._bindingValidationRule != null) {
                this._validBindingRegex.setText(this._bindingValidationRule.getValidBindingRegex());
            }
            this._validBindingRegex.setLayoutData((Object)new GridData(768));
            return composite;
        }

        protected void okPressed() {
            if (this._typeRegex.getText().length() == 0) {
                MessageDialog.openError((Shell)this.getParentShell(), (String)"Component Regex Required", (String)"You must set a component regex.");
                return;
            }
            if (this._validBindingRegex.getText().length() == 0) {
                MessageDialog.openError((Shell)this.getParentShell(), (String)"Valid Binding Regex Required", (String)"You must set a valid binding regex.");
                return;
            }
            String typeRegex = this._typeRegex.getText();
            String validBindingRegex = this._validBindingRegex.getText();
            this._bindingValidationRule = new BindingValidationRule(typeRegex, validBindingRegex);
            super.okPressed();
        }

        public BindingValidationRule getBindingValidationRule() {
            return this._bindingValidationRule;
        }
    }
}

