/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.bindings.tests;

import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.objectstyle.wolips.bindings.api.ApiModel;
import org.objectstyle.wolips.bindings.api.ApiModelException;
import org.objectstyle.wolips.bindings.api.Validation;

public class ValidationTestCase
extends TestCase {
    public void testPierreValidationFailure() throws ApiModelException {
        String api = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wodefinitions>\t<wo class=\"SPRegistrationErrorConditional\" wocomponentcontent=\"true\">\t\t<binding name=\"attributeTypeName\"/>\t\t<binding name=\"addressType\"/>\t\t<binding name=\"key\"/>\t\t<validation message=\"The error conditional must include either an &quot;attributeTypeName&quot; or an &quot;addressType&quot; / &quot;key&quot; pair.\">\t\t\t<and>\t\t\t\t<unbound name=\"attributeTypeName\"/>\t\t\t\t<or>\t\t\t\t\t<unbound name=\"addressType\"/>\t\t\t\t\t<unbound name=\"key\"/>\t\t\t\t</or>\t\t\t</and>\t\t</validation>\t</wo></wodefinitions>";
        StringReader sr = new StringReader(api);
        ApiModel model = new ApiModel(sr);
        HashMap<String, String> bindings = new HashMap<String, String>();
        bindings.put("attributeTypeName", "\"value\"");
        List<Validation> failedValidations = model.getWo().getFailedValidations(bindings);
        ValidationTestCase.assertEquals((int)0, (int)failedValidations.size());
        bindings.clear();
        bindings.put("addressType", "currentAddressType");
        bindings.put("key", "currentKey");
        failedValidations = model.getWo().getFailedValidations(bindings);
        ValidationTestCase.assertEquals((int)0, (int)failedValidations.size());
        for (Validation validation : failedValidations) {
            System.out.println("ValidationTestCase.testTest: " + validation.getMessage());
        }
    }
}

