/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.bindings.wod;

import java.util.ArrayList;
import java.util.List;

public class BindingValidationRule {
    private String _typeRegex;
    private String _validBindingRegex;

    public BindingValidationRule(String typeRegex, String validBindingRegex) {
        this._typeRegex = typeRegex;
        this._validBindingRegex = validBindingRegex;
    }

    public String getTypeRegex() {
        return this._typeRegex;
    }

    public void setTypeRegex(String typeRegex) {
        this._typeRegex = typeRegex;
    }

    public String getValidBindingRegex() {
        return this._validBindingRegex;
    }

    public void setValidBindingRegex(String validBindingRegex) {
        this._validBindingRegex = validBindingRegex;
    }

    public BindingValidationRule clone() {
        return new BindingValidationRule(this.getTypeRegex(), this.getValidBindingRegex());
    }

    public boolean equals(Object obj) {
        if (obj instanceof BindingValidationRule) {
            BindingValidationRule shortcut = (BindingValidationRule)obj;
            return this.getTypeRegex().equals(shortcut.getTypeRegex()) && this.getValidBindingRegex().equals(shortcut.getValidBindingRegex());
        }
        return false;
    }

    public static boolean hasChange(List<BindingValidationRule> rules1, List<BindingValidationRule> rules2) {
        if (rules1.size() != rules2.size()) {
            return true;
        }
        for (int i = 0; i < rules1.size(); ++i) {
            BindingValidationRule rule2;
            BindingValidationRule rule1 = rules1.get(i);
            if (rule1.equals(rule2 = rules2.get(i))) continue;
            return true;
        }
        return false;
    }

    public static List<BindingValidationRule> fromPreferenceString(String value) {
        ArrayList<BindingValidationRule> list = new ArrayList<BindingValidationRule>();
        if (value != null) {
            String[] values = value.split("\n");
            for (int i = 0; i < values.length; ++i) {
                String[] split = values[i].split("\t");
                if (split.length < 2) continue;
                String typeRegex = split[0];
                String validBindingRegex = split[1];
                list.add(new BindingValidationRule(typeRegex, validBindingRegex));
            }
        }
        return list;
    }

    public static String toPreferenceString(List<BindingValidationRule> list) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            BindingValidationRule rules = list.get(i);
            sb.append(rules.getTypeRegex());
            sb.append("\t");
            sb.append(rules.getValidBindingRegex());
            sb.append("\n");
        }
        return sb.toString();
    }
}

