/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wizards;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.WizardNewLinkPage;
import org.objectstyle.wolips.wizards.Messages;
import org.objectstyle.wolips.wizards.WizardsPlugin;

public class D2WApplicationConfigurationPage
extends WizardNewLinkPage {
    private Image _d2wbasicimage;
    private Image _d2wneuimage;
    private Image _d2wwolimage;
    private Image _d2wwonderimage;
    private D2WLook _currentLook;
    private WizardsPlugin.WO_VERSION _currentWOVersion;
    Button basicButton = null;
    Button wolButton = null;
    Button neuButton = null;
    Button wonderButton = null;
    Button[] buttons = new Button[]{this.basicButton, this.wolButton, this.neuButton, this.wonderButton};
    Combo woVersionList = null;
    public static final String BASIC_BUTTON_STRING = Messages.getString("D2WApplicationConfigurationPage.lnf.basic.message");
    public static final String NEU_BUTTON_STRING = Messages.getString("D2WApplicationConfigurationPage.lnf.neu.message");
    public static final String WOL_BUTTON_STRING = Messages.getString("D2WApplicationConfigurationPage.lnf.wol.message");
    public static final String CLASSIC_BUTTON_STRING = Messages.getString("D2WApplicationConfigurationPage.lnf.classic.message");
    public static final String PROJECT_WONDER_STRING = Messages.getString("D2WApplicationConfigurationPage.lnf.wonder.message");
    protected static D2WSelectionListener _d2wListener;

    public D2WApplicationConfigurationPage(String pageName, int type) {
        super(pageName, type);
        this._d2wbasicimage = WizardsPlugin.D2W_BASIC_ICON().createImage();
        this._d2wneuimage = WizardsPlugin.D2W_NEU_ICON().createImage();
        this._d2wwolimage = WizardsPlugin.D2W_WOL_ICON().createImage();
        this._d2wwonderimage = WizardsPlugin.D2W_WONDER_ICON().createImage();
        _d2wListener = new D2WSelectionListener();
    }

    public D2WLook currentLook() {
        return this._currentLook;
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        topLevel.setLayout((Layout)layout);
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(font);
        Group d2wWOVersionGroup = new Group(topLevel, 4);
        GridLayout versionLayout = new GridLayout();
        d2wWOVersionGroup.setLayout((Layout)versionLayout);
        d2wWOVersionGroup.setLayoutData((Object)new GridData(768));
        d2wWOVersionGroup.setText("WebObjects Version:");
        d2wWOVersionGroup.setFont(topLevel.getFont());
        this.woVersionList = new Combo((Composite)d2wWOVersionGroup, 8);
        for (WizardsPlugin.WO_VERSION version : WizardsPlugin.WO_VERSION.values()) {
            this.woVersionList.add(version.getDisplayString());
        }
        this.woVersionList.select(0);
        this.woVersionList.addSelectionListener((SelectionListener)new D2WComboSelectionListener());
        Group d2wButtonGroup = new Group(topLevel, 4);
        GridLayout clientlayout = new GridLayout();
        d2wButtonGroup.setLayout((Layout)clientlayout);
        d2wButtonGroup.setLayoutData((Object)new GridData(768));
        d2wButtonGroup.setText("Look And Feel");
        d2wButtonGroup.setFont(topLevel.getFont());
        this.basicButton = new Button((Composite)d2wButtonGroup, 16);
        this.basicButton.setText(BASIC_BUTTON_STRING);
        this.basicButton.setImage(this._d2wbasicimage);
        this.basicButton.addSelectionListener((SelectionListener)_d2wListener);
        this.basicButton.setSelection(true);
        this.wolButton = new Button((Composite)d2wButtonGroup, 16);
        this.wolButton.setText(WOL_BUTTON_STRING);
        this.wolButton.setImage(this._d2wwolimage);
        this.wolButton.setSelection(false);
        this.wolButton.addSelectionListener((SelectionListener)_d2wListener);
        this.neuButton = new Button((Composite)d2wButtonGroup, 16);
        this.neuButton.setText(NEU_BUTTON_STRING);
        this.neuButton.setImage(this._d2wneuimage);
        this.neuButton.setSelection(false);
        this.neuButton.addSelectionListener((SelectionListener)_d2wListener);
        this.wonderButton = new Button((Composite)d2wButtonGroup, 16);
        this.wonderButton.setText(PROJECT_WONDER_STRING);
        this.wonderButton.setImage(this._d2wwonderimage);
        this.wonderButton.setSelection(false);
        this.wonderButton.addSelectionListener((SelectionListener)_d2wListener);
        this.wonderButton.setEnabled(false);
        this._currentWOVersion = WizardsPlugin.WO_VERSION.WO_54;
        this._currentLook = D2WLook.BASIC54;
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)topLevel);
    }

    WizardsPlugin.WO_VERSION getCurrentVersionSelection() {
        for (WizardsPlugin.WO_VERSION version : WizardsPlugin.WO_VERSION.values()) {
            if (!version.getDisplayString().equals(this.woVersionList.getText())) continue;
            return version;
        }
        return WizardsPlugin.WO_VERSION.WO_54;
    }

    Button getCurrentSelectedButton() {
        for (Button currButton : this.buttons) {
            if (!currButton.isEnabled()) continue;
            return currButton;
        }
        return null;
    }

    D2WLook lookForButton(Button button) {
        D2WLook look;
        if (button.equals(this.basicButton) && this._currentWOVersion.equals((Object)WizardsPlugin.WO_VERSION.WO_54)) {
            look = D2WLook.BASIC54;
        } else if (button.equals(this.wolButton) && this._currentWOVersion.equals((Object)WizardsPlugin.WO_VERSION.WO_54)) {
            look = D2WLook.WEBOBJECTS54;
        } else if (button.equals(this.neuButton) && this._currentWOVersion.equals((Object)WizardsPlugin.WO_VERSION.WO_54)) {
            look = D2WLook.NEUTRAL54;
        } else if (button.equals(this.basicButton) && (this._currentWOVersion.equals((Object)WizardsPlugin.WO_VERSION.WO_52) || this._currentWOVersion.equals((Object)WizardsPlugin.WO_VERSION.WO_53))) {
            look = D2WLook.BASIC52;
        } else if (button.equals(this.wolButton) && (this._currentWOVersion.equals((Object)WizardsPlugin.WO_VERSION.WO_52) || this._currentWOVersion.equals((Object)WizardsPlugin.WO_VERSION.WO_53))) {
            look = D2WLook.WEBOBJECTS52;
        } else if (button.equals(this.neuButton) && (this._currentWOVersion.equals((Object)WizardsPlugin.WO_VERSION.WO_52) || this._currentWOVersion.equals((Object)WizardsPlugin.WO_VERSION.WO_53))) {
            look = D2WLook.NEUTRAL52;
        } else {
            System.out.println("Can't match selected look.  Picking default " + (Object)((Object)D2WLook.BASIC54));
            look = D2WLook.BASIC54;
        }
        return look;
    }

    public boolean handleUpdatedSelection(SelectionEvent e) {
        Object source = e.getSource();
        if (source instanceof Button) {
            this._currentWOVersion = this.getCurrentVersionSelection();
            this._currentLook = this.lookForButton((Button)source);
        } else if (source instanceof Combo) {
            this._currentWOVersion = this.getCurrentVersionSelection();
            this._currentLook = this.lookForButton(this.getCurrentSelectedButton());
        }
        return true;
    }

    class D2WSelectionListener
    extends SelectionAdapter {
        D2WSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            D2WApplicationConfigurationPage.this.handleUpdatedSelection(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            D2WApplicationConfigurationPage.this.handleUpdatedSelection(e);
        }
    }

    class D2WComboSelectionListener
    implements SelectionListener {
        D2WComboSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            D2WApplicationConfigurationPage.this.handleUpdatedSelection(e);
        }

        public void widgetSelected(SelectionEvent e) {
            D2WApplicationConfigurationPage.this.handleUpdatedSelection(e);
        }
    }

    public static enum D2WLook {
        BASIC54("d2w_bas_application_54"),
        WEBOBJECTS54("d2w_wol_application_54"),
        NEUTRAL54("d2w_neu_application_54"),
        WONDER("wonderd2wapplication"),
        BASIC52("d2w_bas_application_52"),
        WEBOBJECTS52("d2w_wol_application_52"),
        NEUTRAL52("d2w_neu_application_52");

        private String _templateName;

        private D2WLook(String templatePath) {
            this._templateName = templatePath;
        }

        String getTemplatePath() {
            return this._templateName;
        }
    }
}

