/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.objectstyle.wolips.baseforplugins.util.CharSetUtils;
import org.objectstyle.wolips.templateengine.ComponentEngine;
import org.objectstyle.wolips.wizards.WOComponentCreationPage;
import org.objectstyle.wolips.wizards.WizardsPlugin;

public class WOComponentCreator
implements IRunnableWithProgress {
    private String componentName;
    private String packageName;
    private String superclassName;
    private boolean createBodyTag;
    private boolean createApiFile;
    private IResource parentResource;
    private WOComponentCreationPage page;
    private int htmlBodyType;
    private String wooEncoding;

    public WOComponentCreator(IResource parentResource, String componentName, String packageName, String superclassName, boolean createBodyTag, boolean createApiFile, WOComponentCreationPage page) {
        this.parentResource = parentResource;
        this.componentName = componentName;
        this.packageName = packageName;
        this.superclassName = superclassName;
        this.createBodyTag = createBodyTag;
        this.createApiFile = createApiFile;
        this.page = page;
        this.htmlBodyType = page.getSelectedHTMLDocType().getTemplateIndex();
        this.wooEncoding = CharSetUtils.encodingNameFromObjectiveC((String)page.getSelectedEncoding());
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        try {
            this.createWOComponent(monitor);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    public void createWOComponent(IProgressMonitor monitor) throws CoreException, InvocationTargetException {
        IFolder componentFolder = null;
        IPath componentJavaPath = null;
        IPath apiPath = null;
        IContainer componentFolderToReveal = null;
        IJavaProject iJavaProject = JavaCore.create((IProject)this.parentResource.getProject());
        switch (this.parentResource.getType()) {
            case 4: {
                componentFolder = ((IProject)this.parentResource).getFolder(this.componentName + ".wo");
                componentFolderToReveal = componentFolder.getParent();
                apiPath = this.parentResource.getProject().getLocation();
                break;
            }
            case 2: {
                componentFolder = ((IFolder)this.parentResource).getFolder(this.componentName + ".wo");
                componentFolderToReveal = componentFolder.getParent();
                apiPath = componentFolder.getParent().getLocation();
                break;
            }
            default: {
                throw new InvocationTargetException(new Exception("Wrong parent resource - check validation"));
            }
        }
        IPackageFragmentRoot[] roots = iJavaProject.getPackageFragmentRoots();
        for (int i = 0; i < roots.length; ++i) {
            if (roots[i].getKind() != 1) continue;
            componentJavaPath = roots[i].getCorrespondingResource().getLocation();
            break;
        }
        if (this.packageName != null && this.packageName.length() > 0) {
            componentJavaPath = componentJavaPath.append((IPath)new Path(this.packageName.replace('.', '/')));
        }
        this.prepareFolder(componentFolder, monitor);
        String projectName = this.parentResource.getProject().getName();
        IPath path = componentFolder.getLocation();
        IPath projectRelativeJavaPath = componentJavaPath.removeFirstSegments(this.parentResource.getProject().getLocation().segmentCount());
        IFolder javaSourceFolder = this.parentResource.getProject().getFolder(projectRelativeJavaPath);
        this.prepareFolder(javaSourceFolder, monitor);
        ComponentEngine componentEngine = new ComponentEngine();
        try {
            componentEngine.init();
        }
        catch (Exception e) {
            WizardsPlugin.getDefault().log(e);
            throw new InvocationTargetException(e);
        }
        componentEngine.setProjectName(projectName);
        componentEngine.setCreateBodyTag(this.createBodyTag);
        componentEngine.setComponentName(this.componentName);
        componentEngine.setPackageName(this.packageName);
        componentEngine.setSuperclassName(this.superclassName);
        componentEngine.setComponentPath(path);
        componentEngine.setApiPath(apiPath);
        componentEngine.setJavaPath(componentJavaPath);
        componentEngine.setCreateApiFile(this.createApiFile);
        componentEngine.setHTMLBodyType(this.htmlBodyType);
        componentEngine.setWOOEncoding(this.wooEncoding);
        try {
            componentEngine.run((IProgressMonitor)new NullProgressMonitor());
            this.parentResource.getProject().refreshLocal(2, monitor);
            IResource[] resources = new IResource[]{componentFolderToReveal.findMember(this.componentName + ".java"), componentFolder.findMember(this.componentName + ".wod")};
            this.page.setResourcesToReveal(resources);
        }
        catch (Exception e) {
            WizardsPlugin.getDefault().log(e);
            throw new InvocationTargetException(e);
        }
    }

    public void prepareFolder(IFolder _folder, IProgressMonitor _progressMonitor) throws CoreException {
        if (!_folder.exists()) {
            IContainer parent = _folder.getParent();
            if (parent instanceof IFolder) {
                this.prepareFolder((IFolder)parent, _progressMonitor);
            }
            _folder.create(false, true, _progressMonitor);
        }
    }
}

