/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.baseforplugins.util.URLUtils;
import org.objectstyle.wolips.baseforuiplugins.utils.ErrorUtils;
import org.objectstyle.wolips.eomodeler.Activator;
import org.objectstyle.wolips.eomodeler.Messages;
import org.objectstyle.wolips.eomodeler.core.model.AbstractEOAttributePath;
import org.objectstyle.wolips.eomodeler.core.model.EOArgument;
import org.objectstyle.wolips.eomodeler.core.model.EOAttribute;
import org.objectstyle.wolips.eomodeler.core.model.EODatabaseConfig;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOEntityIndex;
import org.objectstyle.wolips.eomodeler.core.model.EOFetchSpecification;
import org.objectstyle.wolips.eomodeler.core.model.EOLastModified;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.EOModelGroup;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.model.EORelationship;
import org.objectstyle.wolips.eomodeler.core.model.EORelationshipOptionalityMismatchFailure;
import org.objectstyle.wolips.eomodeler.core.model.EOStoredProcedure;
import org.objectstyle.wolips.eomodeler.core.model.IEOAttribute;
import org.objectstyle.wolips.eomodeler.core.model.IEOModelGroupFactory;
import org.objectstyle.wolips.eomodeler.core.utils.EOModelUtils;
import org.objectstyle.wolips.eomodeler.editors.EOModelErrorDialog;
import org.objectstyle.wolips.eomodeler.editors.EOModelSaveErrorDialog;
import org.objectstyle.wolips.eomodeler.editors.IEOModelEditor;
import org.objectstyle.wolips.eomodeler.editors.LoadEOModelWorkspaceJob;
import org.objectstyle.wolips.eomodeler.editors.arguments.EOArgumentsTableEditor;
import org.objectstyle.wolips.eomodeler.editors.entities.EOEntitiesTableEditor;
import org.objectstyle.wolips.eomodeler.editors.entity.EOEntityEditor;
import org.objectstyle.wolips.eomodeler.outline.EOModelContentOutlinePage;
import org.objectstyle.wolips.eomodeler.utils.AbstractAddRemoveChangeRefresher;
import org.objectstyle.wolips.eomodeler.utils.EclipseFileUtils;

public class EOModelEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
ITabbedPropertySheetPageContributor,
ISelectionProvider,
IEOModelEditor {
    public static final String EOMODEL_EDITOR_ID = "org.objectstyle.wolips.eomodeler.editors.EOModelEditor";
    public static final String EOMODEL_PAGE = "eomodel";
    public static final String EOENTITY_PAGE = "eoentity";
    public static final String EOSTOREDPROCEDURE_PAGE = "eostoredprocedure";
    private EOEntitiesTableEditor myEntitiesTableEditor;
    private EOEntityEditor myEntityEditor;
    private EOArgumentsTableEditor myStoredProcedureEditor;
    private EOModelContentOutlinePage myContentOutlinePage;
    private final ListenerList mySelectionChangedListeners;
    private IStructuredSelection mySelection;
    private final PropertyChangeListener myDirtyModelListener;
    private final EntitiesChangeRefresher myEntitiesChangeListener;
    private final FetchSpecsChangeRefresher myFetchSpecsChangeListener;
    private final EntityIndexesChangeRefresher myEntityIndexesChangeListener;
    private final StoredProceduresChangeRefresher myStoredProceduresChangeListener;
    private final DatabaseConfigsChangeRefresher myDatabaseConfigsChangeListener;
    private final AttributeAndRelationshipDeletedRefresher myAttributeAndRelationshipListener;
    private final ArgumentDeletedRefresher myArgumentListener;
    private EOStoredProcedure mySelectedStoredProcedure;
    private EOEntity mySelectedEntity;
    private EOEntity myOpeningEntity;
    private EOModel myModel;
    private Set<EOModelVerificationFailure> myLoadFailures;
    private boolean myEntityPageVisible;
    private boolean myStoredProcedurePageVisible;
    private int mySelectionDepth;
    private final Object myCreatePagesLock = new Object();
    private int _failuresHashCode;

    public EOModelEditor() {
        this.mySelectionChangedListeners = new ListenerList();
        this.myDirtyModelListener = new DirtyModelListener();
        this.myEntitiesChangeListener = new EntitiesChangeRefresher();
        this.myFetchSpecsChangeListener = new FetchSpecsChangeRefresher();
        this.myEntityIndexesChangeListener = new EntityIndexesChangeRefresher();
        this.myStoredProceduresChangeListener = new StoredProceduresChangeRefresher();
        this.myDatabaseConfigsChangeListener = new DatabaseConfigsChangeRefresher();
        this.myAttributeAndRelationshipListener = new AttributeAndRelationshipDeletedRefresher();
        this.myArgumentListener = new ArgumentDeletedRefresher();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _loadInBackground(IProgressMonitor progressMonitor) {
        block23: {
            this.myLoadFailures = new LinkedHashSet<EOModelVerificationFailure>();
            try {
                IEditorInput editorInput = this.getEditorInput();
                URI indexURL = null;
                if (editorInput instanceof IURIEditorInput) {
                    indexURL = ((IURIEditorInput)editorInput).getURI();
                } else if (editorInput instanceof IStorageEditorInput) {
                    IStorage storage = ((IStorageEditorInput)editorInput).getStorage();
                    Class<?> jarEntryClass = storage.getClass();
                    IPath jarEntryPath = (IPath)jarEntryClass.getMethod("getFullPath", new Class[0]).invoke((Object)storage, new Object[0]);
                    Object root = jarEntryClass.getMethod("getPackageFragmentRoot", new Class[0]).invoke((Object)storage, new Object[0]);
                    Class<?> packageFragmentRootClass = root.getClass();
                    IResource jarResource = (IResource)packageFragmentRootClass.getMethod("getUnderlyingResource", new Class[0]).invoke(root, new Object[0]);
                    IPath jarPath = jarResource == null ? (IPath)packageFragmentRootClass.getMethod("getPath", new Class[0]).invoke(root, new Object[0]) : jarResource.getLocation();
                    indexURL = new URI("jar:" + jarPath.toFile().toURL() + "!" + jarEntryPath.toPortableString());
                }
                if (this.myModel != null) {
                    if (this.myModel.getModelGroup() != null) {
                        this.myModel.getModelGroup().removePropertyChangeListener("dirty", this.myDirtyModelListener);
                    }
                    this.myModel.removePropertyChangeListener("dirty", this.myDirtyModelListener);
                    this.myEntitiesChangeListener.stop();
                    this.myModel.removePropertyChangeListener("entities", this.myEntitiesChangeListener);
                    this.myStoredProceduresChangeListener.stop();
                    this.myModel.removePropertyChangeListener("storedProcedures", this.myStoredProceduresChangeListener);
                    this.myDatabaseConfigsChangeListener.stop();
                    this.myModel.removePropertyChangeListener("databaseConfigs", this.myDatabaseConfigsChangeListener);
                    this.myFetchSpecsChangeListener.stop();
                    this.myModel.removePropertyChangeListener("entity.fetchSpecifications", this.myFetchSpecsChangeListener);
                    this.myEntityIndexesChangeListener.stop();
                    this.myModel.removePropertyChangeListener("entity.entityIndexes", this.myEntityIndexesChangeListener);
                }
                String openingEntityName = null;
                String extension = URLUtils.getExtension((URI)indexURL);
                if ("plist".equalsIgnoreCase(extension)) {
                    String name = URLUtils.getName((URI)indexURL);
                    openingEntityName = name.substring(0, name.indexOf(46));
                    indexURL = new File(URLUtils.cheatAndTurnIntoFile((URI)indexURL).getParentFile(), "index.eomodeld").toURI();
                } else if ("fspec".equalsIgnoreCase(extension)) {
                    indexURL = new File(URLUtils.cheatAndTurnIntoFile((URI)indexURL).getParentFile(), "index.eomodeld").toURI();
                }
                EOModelGroup modelGroup = new EOModelGroup();
                modelGroup.addPropertyChangeListener("models", this.getContentOutlinePage());
                try {
                    IEOModelGroupFactory.Utility.loadModelGroup(indexURL, modelGroup, this.myLoadFailures, true, indexURL.toURL(), progressMonitor);
                }
                finally {
                    modelGroup.removePropertyChangeListener("models", this.getContentOutlinePage());
                }
                EOModel model = modelGroup.getEditingModel();
                boolean showModelGroup = true;
                if (model == null) {
                    this.handleModelErrors(this.myLoadFailures, true, null);
                    Set<EOModel> models = modelGroup.getModels();
                    if (models.size() > 0) {
                        model = models.iterator().next();
                        showModelGroup = true;
                    }
                }
                if (model == null) break block23;
                if (openingEntityName != null) {
                    this.myOpeningEntity = model.getEntityNamed(openingEntityName);
                }
                this.handleModelErrors(this.myLoadFailures, false, null);
                if (model.getModelGroup() != null) {
                    model.getModelGroup().addPropertyChangeListener("dirty", this.myDirtyModelListener);
                }
                model.addPropertyChangeListener("dirty", this.myDirtyModelListener);
                this.myEntitiesChangeListener.start();
                model.addPropertyChangeListener("entities", this.myEntitiesChangeListener);
                this.myStoredProceduresChangeListener.start();
                model.addPropertyChangeListener("storedProcedures", this.myStoredProceduresChangeListener);
                this.myDatabaseConfigsChangeListener.start();
                model.addPropertyChangeListener("databaseConfigs", this.myDatabaseConfigsChangeListener);
                this.myFetchSpecsChangeListener.start();
                model.addPropertyChangeListener("entity.fetchSpecifications", this.myFetchSpecsChangeListener);
                this.myEntityIndexesChangeListener.start();
                model.addPropertyChangeListener("entity.entityIndexes", this.myEntityIndexesChangeListener);
                this.updatePartName();
                this.getEditorSite().setSelectionProvider((ISelectionProvider)this);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EOModelEditor.this.editorDirtyStateChanged();
                    }
                });
                Object object = this.myCreatePagesLock;
                synchronized (object) {
                    this.myModel = model;
                    if (this.myEntitiesTableEditor != null) {
                        final boolean finalShowModelGroup = showModelGroup;
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (EOModelEditor.this.myEntitiesTableEditor != null) {
                                    EOModelEditor.this.myEntitiesTableEditor.setModel(EOModelEditor.this.myModel);
                                }
                                if (EOModelEditor.this.getContentOutlinePage() != null && EOModelEditor.this.getContentOutlinePage().getUpdater() != null) {
                                    EOModelEditor.this.getContentOutlinePage().getUpdater().setModel(EOModelEditor.this.myModel);
                                    if (finalShowModelGroup) {
                                        EOModelEditor.this.getContentOutlinePage().showModelGroup();
                                    }
                                }
                            }
                        });
                    }
                }
                if (this.myOpeningEntity != null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            EOModelEditor.this.setSelectedEntity(EOModelEditor.this.myOpeningEntity);
                            EOModelEditor.this.setActivePage(EOModelEditor.this.getPageNum(EOModelEditor.EOENTITY_PAGE));
                        }
                    });
                }
            }
            catch (Throwable e) {
                this.myLoadFailures.add(new EOModelVerificationFailure(null, "Failed to load model.", false, e));
                this.handleModelErrors(this.myLoadFailures, true, null);
                e.printStackTrace();
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener _listener) {
        this.mySelectionChangedListeners.add((Object)_listener);
    }

    protected int computeFailuresHashCode(Set<EOModelVerificationFailure> failures) {
        StringBuffer sb = new StringBuffer();
        for (EOModelVerificationFailure failure : failures) {
            sb.append(failure.getMessage());
        }
        return sb.toString().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createPages() {
        Object object = this.myCreatePagesLock;
        synchronized (object) {
            try {
                this.myEntitiesTableEditor = new EOEntitiesTableEditor();
                this.addPage((IEditorPart)this.myEntitiesTableEditor, this.getEditorInput());
                this.setPageText(this.getPageNum(EOMODEL_PAGE), Messages.getString("EOModelEditor.entitiesTab"));
                this.myEntityEditor = new EOEntityEditor();
                EOModelSelectionChangedListener modelSelectionChangedListener = new EOModelSelectionChangedListener();
                this.myEntitiesTableEditor.addSelectionChangedListener(modelSelectionChangedListener);
                this.myEntitiesTableEditor.setModel(this.myModel);
                EOEntitySelectionChangedListener entitySelectionChangedListener = new EOEntitySelectionChangedListener();
                this.myEntityEditor.addSelectionChangedListener(entitySelectionChangedListener);
                this.myStoredProcedureEditor = new EOArgumentsTableEditor();
                EOArgumentSelectionChangedListener argumentSelectionChangedListener = new EOArgumentSelectionChangedListener();
                this.myStoredProcedureEditor.addSelectionChangedListener(argumentSelectionChangedListener);
            }
            catch (PartInitException e) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating editor.", null, (IStatus)e.getStatus());
            }
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.myEntitiesChangeListener.stop();
        this.myStoredProceduresChangeListener.stop();
        this.myDatabaseConfigsChangeListener.stop();
        this.myFetchSpecsChangeListener.stop();
        this.myEntityIndexesChangeListener.stop();
        super.dispose();
        this.switchFromEntityModelerPerspective();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSave(final IProgressMonitor monitor) {
        this.showBusy(true);
        try {
            IEditorInput input = this.getEditorInput();
            if (input != null && this.myModel != null) {
                HashSet<EOModelVerificationFailure> failures = new HashSet<EOModelVerificationFailure>();
                final LinkedList<EOModel> dirtyModels = new LinkedList<EOModel>();
                for (EOModel model : this.myModel.getModelGroup().getModels()) {
                    if (!model.isDirty()) continue;
                    dirtyModels.add(model);
                }
                boolean saveAllModels = true;
                if (dirtyModels.size() > 1 || !dirtyModels.contains(this.myModel)) {
                    TreeSet<String> modelNames = new TreeSet<String>();
                    for (EOModel model : dirtyModels) {
                        if (model == this.myModel) continue;
                        modelNames.add(model.getName());
                    }
                    saveAllModels = MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"Additional Models Modified", (String)("You modified the following additional models in this model group: " + modelNames + ". Would you like to save them, also?"));
                }
                HashSet<EOModel> doNotSaveModels = new HashSet<EOModel>();
                for (EOModel model : dirtyModels) {
                    if (model != this.myModel && !saveAllModels) continue;
                    HashSet<EOLastModified> lastModified = new HashSet<EOLastModified>();
                    model.checkLastModified(lastModified);
                    if (lastModified.isEmpty() || MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Model Changed on Disk", (String)("The model '" + model.getName() + "' changed on disk since you opened it. Are you want to overwrite those changes?"))) continue;
                    doNotSaveModels.add(model);
                }
                dirtyModels.removeAll(doNotSaveModels);
                for (EOModel model : dirtyModels) {
                    if (model != this.myModel && !saveAllModels) continue;
                    monitor.beginTask("Checking " + model.getName() + " ...", -1);
                    try {
                        model.verify(failures);
                        if (model.canSave()) continue;
                        failures.add(new EOModelVerificationFailure(model, "You modified the model '" + model.getName() + "', but you are not able to save it to '" + model.getIndexURL() + "'.", false));
                    }
                    finally {
                        monitor.done();
                    }
                }
                final boolean finalSaveAllModels = saveAllModels;
                this.handleModelErrors(failures, false, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        EOModelEditor.this.showBusy(true);
                        try {
                            for (EOModel model : dirtyModels) {
                                if (!model.canSave() || model != EOModelEditor.this.myModel && !finalSaveAllModels) continue;
                                monitor.beginTask("Saving " + model.getName() + " ...", -1);
                                try {
                                    model.save();
                                    IFile eclipseIndexFile = EclipseFileUtils.getEclipseFile(EOModelEditor.this.myModel.getIndexURL());
                                    if (eclipseIndexFile == null) continue;
                                    eclipseIndexFile.getParent().getParent().refreshLocal(2, monitor);
                                }
                                finally {
                                    monitor.done();
                                }
                            }
                        }
                        catch (Throwable t) {
                            ErrorUtils.openErrorDialog((Shell)Display.getDefault().getActiveShell(), (Throwable)t);
                        }
                        finally {
                            EOModelEditor.this.showBusy(false);
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            ErrorUtils.openErrorDialog((Shell)Display.getDefault().getActiveShell(), (Throwable)t);
        }
        finally {
            this.showBusy(false);
        }
    }

    public void doSaveAs() {
        this.doSave(null);
    }

    protected void doubleClickedObjectInOutline(Object _obj) {
        if (_obj instanceof EOEntity) {
            this.setActivePage(this.getPageNum(EOENTITY_PAGE));
        } else if (_obj instanceof EOStoredProcedure) {
            this.setActivePage(this.getPageNum(EOSTOREDPROCEDURE_PAGE));
        }
    }

    protected void editorDirtyStateChanged() {
        this.firePropertyChange(257);
    }

    protected void fireSelectionChanged(ISelection _selection) {
        IWorkbenchPart activePart = this.getSite().getPage().getActivePart();
        if (activePart instanceof PropertySheet) {
            if (this.getContentOutlinePage().getControl() != null) {
                this.getContentOutlinePage().setFocus();
            }
            this.getSite().getPage().activate(activePart);
        }
        Object[] selectionChangedListeners = this.mySelectionChangedListeners.getListeners();
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, _selection);
        for (int listenerNum = 0; listenerNum < selectionChangedListeners.length; ++listenerNum) {
            ISelectionChangedListener listener = (ISelectionChangedListener)selectionChangedListeners[listenerNum];
            listener.selectionChanged(selectionChangedEvent);
        }
    }

    public Object getAdapter(Class _adapterClass) {
        Object adapter;
        if (_adapterClass == IPropertySheetPage.class) {
            adapter = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        } else if (_adapterClass == IContentOutlinePage.class) {
            EOModelContentOutlinePage outlinePage = this.getContentOutlinePage();
            adapter = outlinePage;
        } else {
            adapter = super.getAdapter(_adapterClass);
        }
        return adapter;
    }

    public EOModelContentOutlinePage getContentOutlinePage() {
        if (this.myContentOutlinePage == null) {
            this.myContentOutlinePage = new EOModelContentOutlinePage(this);
            this.myContentOutlinePage.addSelectionChangedListener(new EOModelContentSelectionChangedListener());
        }
        return this.myContentOutlinePage;
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public EOEntitiesTableEditor getEntitiesTableEditor() {
        return this.myEntitiesTableEditor;
    }

    public EOEntityEditor getEntityEditor() {
        return this.myEntityEditor;
    }

    @Override
    public EOModel getModel() {
        return this.myModel;
    }

    protected int getPageNum(IEditorPart _editorPart) {
        int matchingPageNum = -1;
        int pageCount = this.getPageCount();
        for (int pageNum = 0; matchingPageNum == -1 && pageNum < pageCount; ++pageNum) {
            IEditorPart editorPart = this.getEditor(pageNum);
            if (editorPart != _editorPart) continue;
            matchingPageNum = pageNum;
        }
        return matchingPageNum;
    }

    protected int getPageNum(String _pageType) {
        int pageNum = _pageType == EOENTITY_PAGE ? this.getPageNum((IEditorPart)this.myEntityEditor) : (_pageType == EOMODEL_PAGE ? this.getPageNum((IEditorPart)this.myEntitiesTableEditor) : (_pageType == EOSTOREDPROCEDURE_PAGE ? this.getPageNum((IEditorPart)this.myStoredProcedureEditor) : -1));
        return pageNum;
    }

    public EOEntity getSelectedEntity() {
        return this.mySelectedEntity;
    }

    public EOStoredProcedure getSelectedStoredProcedure() {
        return this.mySelectedStoredProcedure;
    }

    public ISelection getSelection() {
        return this.mySelection;
    }

    public EOArgumentsTableEditor getStoredProcedureEditor() {
        return this.myStoredProcedureEditor;
    }

    public IUndoContext getUndoContext() {
        return new EOModelEditorUndoContext();
    }

    protected void handleModelErrors(final Set<EOModelVerificationFailure> failures, boolean forceOpen, final Runnable executeWhenApproved) {
        if (this.myModel != null) {
            try {
                if (Activator.getDefault().getPreferenceStore().getBoolean("EntityModelerErrorsInProblemsView")) {
                    final EOModel editingModel = this.myModel;
                    IWorkspaceRunnable body = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            for (EOModel model : editingModel.getModelGroup().getModels()) {
                                try {
                                    IFile indexFile = EclipseFileUtils.getEclipseIndexFile(model);
                                    if (indexFile == null) continue;
                                    IMarker[] oldMarkers = indexFile.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                                    for (int markerNum = 0; markerNum < oldMarkers.length; ++markerNum) {
                                        oldMarkers[markerNum].delete();
                                    }
                                    IMarker[] newMarkers = indexFile.findMarkers("org.objectstyle.wolips.eomodeler.core.problem", true, 2);
                                    for (int markerNum = 0; markerNum < newMarkers.length; ++markerNum) {
                                        newMarkers[markerNum].delete();
                                    }
                                }
                                catch (Exception e) {
                                    Activator.getDefault().log(e);
                                }
                            }
                            for (EOModelVerificationFailure failure : failures) {
                                EOModel model = failure.getModel();
                                try {
                                    IFile indexFile = EclipseFileUtils.getEclipseIndexFile(model);
                                    if (indexFile == null) continue;
                                    IMarker marker = indexFile.createMarker("org.objectstyle.wolips.eomodeler.core.problem");
                                    marker.setAttribute("message", (Object)failure.getMessage());
                                    int severity = failure.isWarning() ? 1 : 2;
                                    marker.setAttribute("severity", (Object)severity);
                                    marker.setAttribute("transient", false);
                                }
                                catch (Exception e) {
                                    Activator.getDefault().log(e);
                                }
                            }
                        }
                    };
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    workspace.run(body, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Exception e) {
                Activator.getDefault().log(e);
            }
        }
        if (!Activator.getDefault().getPreferenceStore().getBoolean("ShowRelationshipAttributeOptionalityMismatchLabel")) {
            Iterator<EOModelVerificationFailure> failuresIter = failures.iterator();
            while (failuresIter.hasNext()) {
                EOModelVerificationFailure failure = failuresIter.next();
                if (!(failure instanceof EORelationshipOptionalityMismatchFailure)) continue;
                failuresIter.remove();
            }
        }
        boolean warnings = false;
        boolean errors = false;
        for (EOModelVerificationFailure failure : failures) {
            if (failure.isWarning()) {
                warnings = true;
                continue;
            }
            errors = true;
        }
        boolean openWindow = false;
        if (forceOpen) {
            openWindow = true;
        } else {
            if (errors && Activator.getDefault().getPreferenceStore().getBoolean("EntityModelerOpenWindowOnVerificationErrors")) {
                openWindow = true;
            }
            if (warnings && Activator.getDefault().getPreferenceStore().getBoolean("EntityModelerOpenWindowOnVerificationWarnings")) {
                openWindow = true;
            }
        }
        int newFailuresHashCode = this.computeFailuresHashCode(failures);
        if (openWindow && this._failuresHashCode != 0 && newFailuresHashCode == this._failuresHashCode) {
            openWindow = false;
        }
        this._failuresHashCode = newFailuresHashCode;
        if (openWindow) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!failures.isEmpty()) {
                        EOModelErrorDialog dialog = executeWhenApproved != null ? new EOModelSaveErrorDialog(Display.getCurrent().getActiveShell(), (Set<? extends EOModelVerificationFailure>)failures, EOModelEditor.this) : new EOModelErrorDialog(Display.getCurrent().getActiveShell(), (Set<? extends EOModelVerificationFailure>)failures, EOModelEditor.this);
                        dialog.setBlockOnOpen(true);
                        int result = dialog.open();
                        if (executeWhenApproved != null) {
                            if (result == 0) {
                                executeWhenApproved.run();
                            } else {
                                EOModelEditor.this._failuresHashCode = 0;
                            }
                        }
                    }
                }
            });
        } else if (executeWhenApproved != null) {
            executeWhenApproved.run();
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        try {
            this.switchToEntityModelerPerspective();
            super.init(site, editorInput);
            LoadEOModelWorkspaceJob loadModelJob = new LoadEOModelWorkspaceJob(this, editorInput);
            loadModelJob.schedule();
        }
        catch (WorkbenchException e) {
            e.printStackTrace();
        }
    }

    public boolean isDirty() {
        boolean dirty = false;
        if (this.myModel != null) {
            if (this.myModel.isDirty()) {
                dirty = true;
            } else if (this.myModel.getModelGroup() != null) {
                dirty = this.myModel.getModelGroup().isDirty();
            }
        }
        return dirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void pageChange(int _newPageIndex) {
        super.pageChange(_newPageIndex);
        ISelectionProvider selectionProvider = (ISelectionProvider)this.getEditor(_newPageIndex);
        this.getSite().setSelectionProvider(selectionProvider);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener _listener) {
        this.mySelectionChangedListeners.remove((Object)_listener);
    }

    public void resourceChanged(final IResourceChangeEvent _event) {
        if (_event.getType() == 2) {
            final IURIEditorInput input = (IURIEditorInput)this.getEditorInput();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage[] pages = EOModelEditor.this.getSite().getWorkbenchWindow().getPages();
                    for (int pageNum = 0; pageNum < pages.length; ++pageNum) {
                        IFile eclipseIndexFile = EclipseFileUtils.getEclipseFile(input.getURI());
                        if (eclipseIndexFile == null || !eclipseIndexFile.getProject().equals(_event.getResource())) continue;
                        IEditorPart editorPart = pages[pageNum].findEditor((IEditorInput)input);
                        pages[pageNum].closeEditor(editorPart, true);
                    }
                }
            });
        }
    }

    public void revert() {
        boolean confirmed = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("EOModelEditor.revertTitle"), (String)Messages.getString("EOModelEditor.revertMessage"));
        if (confirmed) {
            try {
                this.init((IEditorSite)this.getSite(), this.getEditorInput());
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    public void setActivePage(int _pageIndex) {
        if (_pageIndex != this.getActivePage()) {
            super.setActivePage(_pageIndex);
        }
    }

    protected void setEntityPageVisible(boolean _entityPageVisible) {
        try {
            if (_entityPageVisible) {
                String entityName;
                if (!this.myEntityPageVisible) {
                    this.addPage((IEditorPart)this.myEntityEditor, this.getEditorInput());
                }
                if ((entityName = this.mySelectedEntity.getName()) == null) {
                    entityName = "?";
                }
                this.setPageText(this.getPageNum(EOENTITY_PAGE), entityName);
            } else if (this.myEntityPageVisible) {
                this.removePage(this.getPageNum(EOENTITY_PAGE));
            }
            this.myEntityPageVisible = _entityPageVisible;
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating editor.", null, (IStatus)e.getStatus());
        }
    }

    public void setFocus() {
        super.setFocus();
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        if (Activator.getDefault().getPreferenceStore().getBoolean("EntityModelerChangePerspectives")) {
            IEditorReference[] editorReferences;
            IWorkbenchPage workbenchPage;
            boolean shouldSwitchToEntityModeler = false;
            IWorkbench workbench = Activator.getDefault().getWorkbench();
            IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
            if (activeWindow != null && activeWindow != null && (workbenchPage = activeWindow.getActivePage()) != null && (editorReferences = workbenchPage.getEditorReferences()).length > 1) {
                shouldSwitchToEntityModeler = true;
            }
            if (shouldSwitchToEntityModeler) {
                this.switchToEntityModelerPerspective();
            }
        }
    }

    public void setSelectedEntity(EOEntity _selectedEntity) {
        if (!ComparisonUtils.equals((Object)this.mySelectedEntity, (Object)_selectedEntity)) {
            if (this.mySelectedEntity != null) {
                this.mySelectedEntity.removePropertyChangeListener("attributes", this.myAttributeAndRelationshipListener);
                this.mySelectedEntity.removePropertyChangeListener("relationships", this.myAttributeAndRelationshipListener);
            }
            this.mySelectedEntity = _selectedEntity;
            if (this.mySelectedEntity != null) {
                this.mySelectedEntity.addPropertyChangeListener("attributes", this.myAttributeAndRelationshipListener);
                this.mySelectedEntity.addPropertyChangeListener("relationships", this.myAttributeAndRelationshipListener);
            }
            if (_selectedEntity == null) {
                this.setEntityPageVisible(false);
            } else {
                this.setEntityPageVisible(true);
            }
            this.myEntitiesTableEditor.setSelectedEntity(_selectedEntity);
            this.myEntityEditor.setEntity(_selectedEntity);
            this.updatePartName();
        }
        if (_selectedEntity != null) {
            this.setSelectedStoredProcedure(null);
        }
    }

    public void setSelectedStoredProcedure(EOStoredProcedure _selectedStoredProcedure) {
        if (!ComparisonUtils.equals((Object)this.mySelectedStoredProcedure, (Object)_selectedStoredProcedure)) {
            if (this.mySelectedStoredProcedure != null) {
                this.mySelectedStoredProcedure.removePropertyChangeListener("arguments", this.myArgumentListener);
            }
            this.mySelectedStoredProcedure = _selectedStoredProcedure;
            if (this.mySelectedStoredProcedure != null) {
                this.mySelectedStoredProcedure.addPropertyChangeListener("arguments", this.myArgumentListener);
            }
            if (_selectedStoredProcedure == null) {
                this.setStoredProcedurePageVisible(false);
            } else {
                this.setStoredProcedurePageVisible(true);
            }
            this.myStoredProcedureEditor.setStoredProcedure(_selectedStoredProcedure);
            this.updatePartName();
        }
        if (_selectedStoredProcedure != null) {
            this.setSelectedEntity(null);
        }
    }

    public void setSelection(ISelection _selection) {
        this.setSelection(_selection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSelection(ISelection _selection, boolean _updateOutline) {
        ++this.mySelectionDepth;
        try {
            if (this.mySelectionDepth == 1) {
                IStructuredSelection selection;
                IStructuredSelection previousSelection = this.mySelection;
                this.mySelection = selection = (IStructuredSelection)_selection;
                if (previousSelection == null || !selection.toList().equals(previousSelection.toList())) {
                    Object selectedObject = null;
                    if (!selection.isEmpty()) {
                        selectedObject = selection.getFirstElement();
                    }
                    if (selectedObject instanceof EOModel) {
                        this.setSelectedEntity(null);
                        this.setSelectedStoredProcedure(null);
                        this.setActivePage(this.getPageNum(EOMODEL_PAGE));
                    } else if (selectedObject instanceof EOEntity) {
                        EOEntity selectedEntity = (EOEntity)selectedObject;
                        this.setSelectedEntity(selectedEntity);
                    } else if (selectedObject instanceof EOAttribute) {
                        EOAttribute selectedAttribute = (EOAttribute)selectedObject;
                        this.setSelectedEntity(selectedAttribute.getEntity());
                        this.getEntityEditor().setSelection(_selection);
                        this.setActivePage(this.getPageNum(EOENTITY_PAGE));
                    } else if (selectedObject instanceof EORelationship) {
                        EORelationship selectedRelationship = (EORelationship)selectedObject;
                        this.setSelectedEntity(selectedRelationship.getEntity());
                        this.getEntityEditor().setSelection((ISelection)selection);
                        this.setActivePage(this.getPageNum(EOENTITY_PAGE));
                    } else if (selectedObject instanceof EOFetchSpecification) {
                        EOFetchSpecification selectedFetchSpec = (EOFetchSpecification)selectedObject;
                        this.setSelectedEntity(selectedFetchSpec.getEntity());
                        this.getEntityEditor().setSelection((ISelection)selection);
                    } else if (selectedObject instanceof AbstractEOAttributePath) {
                        AbstractEOAttributePath selectedAttributePath = (AbstractEOAttributePath)selectedObject;
                        this.setSelectedEntity(selectedAttributePath.getChildIEOAttribute().getEntity());
                        this.getEntityEditor().setSelection((ISelection)new StructuredSelection((Object)selectedAttributePath.getChildIEOAttribute()));
                        this.setActivePage(this.getPageNum(EOENTITY_PAGE));
                    } else if (selectedObject instanceof EOStoredProcedure) {
                        EOStoredProcedure selectedStoredProcedure = (EOStoredProcedure)selectedObject;
                        this.setSelectedStoredProcedure(selectedStoredProcedure);
                    } else if (selectedObject instanceof EOArgument) {
                        EOArgument selectedArgument = (EOArgument)selectedObject;
                        this.setSelectedStoredProcedure(selectedArgument.getStoredProcedure());
                        this.getStoredProcedureEditor().setSelection(_selection);
                        this.setActivePage(this.getPageNum(EOSTOREDPROCEDURE_PAGE));
                    } else if (selectedObject instanceof EODatabaseConfig) {
                        this.setSelectedEntity(null);
                        this.setActivePage(this.getPageNum(EOMODEL_PAGE));
                    }
                    if (_updateOutline) {
                        this.getContentOutlinePage().setSelection((ISelection)selection);
                    }
                    this.fireSelectionChanged((ISelection)selection);
                }
            }
        }
        finally {
            --this.mySelectionDepth;
        }
    }

    protected void setStoredProcedurePageVisible(boolean _storedProcedurePageVisible) {
        try {
            if (_storedProcedurePageVisible) {
                String storedProcedureName;
                if (!this.myStoredProcedurePageVisible) {
                    this.addPage((IEditorPart)this.myStoredProcedureEditor, this.getEditorInput());
                }
                if ((storedProcedureName = this.mySelectedStoredProcedure.getName()) == null) {
                    storedProcedureName = "?";
                }
                this.setPageText(this.getPageNum(EOSTOREDPROCEDURE_PAGE), storedProcedureName);
            } else if (this.myStoredProcedurePageVisible) {
                this.removePage(this.getPageNum(EOSTOREDPROCEDURE_PAGE));
            }
            this.myStoredProcedurePageVisible = _storedProcedurePageVisible;
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating editor.", null, (IStatus)e.getStatus());
        }
    }

    public void switchFromEntityModelerPerspective() {
        IEditorReference[] editorReferences;
        IWorkbenchPage workbenchPage;
        IWorkbench workbench;
        boolean closedWindow = false;
        if (Activator.getDefault().getPreferenceStore().getBoolean("EntityModelerOpenInWindow") && (workbench = Activator.getDefault().getWorkbench()).getWorkbenchWindows().length > 1 && (workbenchPage = workbench.getActiveWorkbenchWindow().getActivePage()) != null && "org.objectstyle.wolips.eomodeler.EOModelerPerspective".equals(workbenchPage.getPerspective().getId()) && (editorReferences = workbenchPage.getEditorReferences()).length == 0) {
            closedWindow = workbench.getActiveWorkbenchWindow().close();
        }
        if (!closedWindow && Activator.getDefault().getPreferenceStore().getBoolean("EntityModelerChangePerspectives")) {
            try {
                IWorkbenchPage workbenchPage2;
                workbench = Activator.getDefault().getWorkbench();
                IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
                if (activeWorkbenchWindow != null && (workbenchPage2 = activeWorkbenchWindow.getActivePage()) != null && "org.objectstyle.wolips.eomodeler.EOModelerPerspective".equals(workbenchPage2.getPerspective().getId())) {
                    IEditorReference[] editorReferences2 = workbenchPage2.getEditorReferences();
                    int eomodelerEditorCount = 0;
                    for (int editorReferenceNum = 0; editorReferenceNum < editorReferences2.length; ++editorReferenceNum) {
                        IEditorReference editorReference = editorReferences2[editorReferenceNum];
                        if (!EOMODEL_EDITOR_ID.equals(editorReference.getId())) continue;
                        ++eomodelerEditorCount;
                    }
                    if (eomodelerEditorCount == 0) {
                        workbench.showPerspective("org.objectstyle.wolips.ui.Perspective", activeWorkbenchWindow);
                    }
                }
            }
            catch (WorkbenchException e) {
                Activator.getDefault().log(e);
            }
        }
    }

    public void switchToEntityModelerPerspective() {
        try {
            IWorkbench workbench;
            IWorkbenchWindow activeWorkbenchWindow;
            if (Activator.getDefault().getPreferenceStore().getBoolean("EntityModelerChangePerspectives") && (activeWorkbenchWindow = (workbench = Activator.getDefault().getWorkbench()).getActiveWorkbenchWindow()) != null) {
                workbench.showPerspective("org.objectstyle.wolips.eomodeler.EOModelerPerspective", activeWorkbenchWindow);
            }
        }
        catch (WorkbenchException e) {
            Activator.getDefault().log(e);
        }
    }

    protected void updatePartName() {
        String partName = this.myModel != null ? this.myModel.getName() : Messages.getString("EOModelEditor.partName");
        this.setPartName(partName);
    }

    protected class StoredProceduresChangeRefresher
    extends AbstractAddRemoveChangeRefresher<EOStoredProcedure> {
        public StoredProceduresChangeRefresher() {
            super("StoredProceduresChange");
        }

        @Override
        public void changeSelection(ISelection selection) {
            EOModelEditor.this.setSelection(selection);
            EOModelEditor.this.setActivePage(EOModelEditor.this.getPageNum(EOModelEditor.EOSTOREDPROCEDURE_PAGE));
        }

        @Override
        protected void objectsAdded(List<EOStoredProcedure> _addedObjects) {
        }

        @Override
        protected void objectsRemoved(List<EOStoredProcedure> _removedObjects) {
            EOModelEditor.this.setSelection((ISelection)new StructuredSelection((Object)EOModelEditor.this.getModel()));
            EOModelEditor.this.setActivePage(EOModelEditor.this.getPageNum(EOModelEditor.EOMODEL_PAGE));
        }
    }

    protected class FetchSpecsChangeRefresher
    extends AbstractAddRemoveChangeRefresher<EOFetchSpecification> {
        public FetchSpecsChangeRefresher() {
            super("FetchSpecsChange");
        }

        @Override
        public void changeSelection(ISelection selection) {
            EOModelEditor.this.setSelection(selection);
            EOModelEditor.this.setActivePage(EOModelEditor.this.getPageNum(EOModelEditor.EOENTITY_PAGE));
        }

        @Override
        protected void objectsAdded(List<EOFetchSpecification> _addedObjects) {
        }

        @Override
        protected void objectsRemoved(List<EOFetchSpecification> _removedObjects) {
            EOModelEditor.this.setSelection((ISelection)new StructuredSelection((Object)EOModelEditor.this.getModel()));
            EOModelEditor.this.setActivePage(EOModelEditor.this.getPageNum(EOModelEditor.EOMODEL_PAGE));
        }
    }

    protected class EOModelSelectionChangedListener
    implements ISelectionChangedListener {
        protected EOModelSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent _event) {
            IStructuredSelection selection = (IStructuredSelection)_event.getSelection();
            EOModelEditor.this.setSelection((ISelection)selection);
        }
    }

    protected class EOModelEditorUndoContext
    implements IUndoContext {
        protected EOModelEditorUndoContext() {
        }

        public String getLabel() {
            return EOModelUtils.getUndoContext(EOModelEditor.this.getModel()).getLabel();
        }

        public boolean matches(IUndoContext context) {
            return EOModelUtils.getUndoContext(EOModelEditor.this.getModel()).matches(context);
        }
    }

    protected class EOModelContentSelectionChangedListener
    implements ISelectionChangedListener {
        private Object mySelectedObject;

        protected EOModelContentSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent _event) {
            IStructuredSelection selection = (IStructuredSelection)_event.getSelection();
            Object selectedObject = selection.getFirstElement();
            EOModelEditor.this.setSelection((ISelection)selection, false);
            if (EOModelEditor.this.myContentOutlinePage.isSelectedWithOutline()) {
                EOModelEditor.this.doubleClickedObjectInOutline(selectedObject);
            } else if (this.mySelectedObject == null) {
                this.mySelectedObject = selectedObject;
            } else if (this.mySelectedObject == selectedObject) {
                EOModelEditor.this.doubleClickedObjectInOutline(selectedObject);
                this.mySelectedObject = null;
            } else {
                this.mySelectedObject = selectedObject;
            }
        }
    }

    protected class EOEntitySelectionChangedListener
    implements ISelectionChangedListener {
        protected EOEntitySelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent _event) {
            IStructuredSelection selection = (IStructuredSelection)_event.getSelection();
            EOModelEditor.this.setSelection((ISelection)selection);
        }
    }

    protected class EOArgumentSelectionChangedListener
    implements ISelectionChangedListener {
        protected EOArgumentSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent _event) {
            IStructuredSelection selection = (IStructuredSelection)_event.getSelection();
            EOModelEditor.this.setSelection((ISelection)selection);
        }
    }

    protected class EntityIndexesChangeRefresher
    extends AbstractAddRemoveChangeRefresher<EOEntityIndex> {
        public EntityIndexesChangeRefresher() {
            super("EntityIndexesChange");
        }

        @Override
        public void changeSelection(ISelection selection) {
            EOModelEditor.this.setSelection(selection);
            EOModelEditor.this.setActivePage(EOModelEditor.this.getPageNum(EOModelEditor.EOENTITY_PAGE));
        }

        @Override
        protected void objectsAdded(List<EOEntityIndex> _addedObjects) {
        }

        @Override
        protected void objectsRemoved(List<EOEntityIndex> _removedObjects) {
            EOModelEditor.this.setSelection((ISelection)new StructuredSelection((Object)EOModelEditor.this.getModel()));
            EOModelEditor.this.setActivePage(EOModelEditor.this.getPageNum(EOModelEditor.EOMODEL_PAGE));
        }
    }

    protected class EntitiesChangeRefresher
    extends AbstractAddRemoveChangeRefresher<EOEntity> {
        public EntitiesChangeRefresher() {
            super("EntitiesChange");
        }

        @Override
        public void changeSelection(ISelection selection) {
            EOModelEditor.this.setSelection(selection);
            EOModelEditor.this.setActivePage(EOModelEditor.this.getPageNum(EOModelEditor.EOENTITY_PAGE));
        }

        @Override
        protected void objectsAdded(List<EOEntity> _addedObjects) {
        }

        @Override
        protected void objectsRemoved(List<EOEntity> _removedObjects) {
            EOModelEditor.this.setSelection((ISelection)new StructuredSelection((Object)EOModelEditor.this.getModel()));
            EOModelEditor.this.setActivePage(EOModelEditor.this.getPageNum(EOModelEditor.EOMODEL_PAGE));
        }
    }

    protected class DirtyModelListener
    implements PropertyChangeListener {
        protected DirtyModelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent _event) {
            String propertyName = _event.getPropertyName();
            if ("dirty".equals(propertyName)) {
                EOModelEditor.this.editorDirtyStateChanged();
            }
        }
    }

    protected class DatabaseConfigsChangeRefresher
    extends AbstractAddRemoveChangeRefresher<EODatabaseConfig> {
        public DatabaseConfigsChangeRefresher() {
            super("DatabaseConfigsChange");
        }

        @Override
        public void changeSelection(ISelection selection) {
            EOModelEditor.this.setSelection(selection);
        }

        @Override
        protected void objectsAdded(List<EODatabaseConfig> _addedObjects) {
        }

        @Override
        protected void objectsRemoved(List<EODatabaseConfig> _removedObjects) {
            EOModelEditor.this.setSelection((ISelection)new StructuredSelection((Object)EOModelEditor.this.getModel()));
            EOModelEditor.this.setActivePage(EOModelEditor.this.getPageNum(EOModelEditor.EOMODEL_PAGE));
        }
    }

    protected class AttributeAndRelationshipDeletedRefresher
    extends AbstractAddRemoveChangeRefresher<IEOAttribute> {
        public AttributeAndRelationshipDeletedRefresher() {
            super("AttributeAndRelationshipDeleted");
        }

        @Override
        public void changeSelection(ISelection selection) {
            EOModelEditor.this.setSelection(selection);
        }

        @Override
        protected void objectsAdded(List<IEOAttribute> _addedObjects) {
        }

        @Override
        protected void objectsRemoved(List<IEOAttribute> _removedObjects) {
            EOModelEditor.this.setSelection((ISelection)new StructuredSelection((Object)EOModelEditor.this.getSelectedEntity()));
            EOModelEditor.this.setActivePage(EOModelEditor.this.getPageNum(EOModelEditor.EOENTITY_PAGE));
        }
    }

    protected class ArgumentDeletedRefresher
    extends AbstractAddRemoveChangeRefresher<EOArgument> {
        public ArgumentDeletedRefresher() {
            super("ArgumentDeleted");
        }

        @Override
        public void changeSelection(ISelection selection) {
            EOModelEditor.this.setSelection(selection);
        }

        @Override
        protected void objectsAdded(List<EOArgument> _addedObjects) {
        }

        @Override
        protected void objectsRemoved(List<EOArgument> _removedObjects) {
            EOModelEditor.this.setSelection((ISelection)new StructuredSelection((Object)EOModelEditor.this.getSelectedStoredProcedure()));
            EOModelEditor.this.setActivePage(EOModelEditor.this.getPageNum(EOModelEditor.EOSTOREDPROCEDURE_PAGE));
        }
    }
}

