/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.objectstyle.wolips.eomodeler.core.kvc.CachingKeyPath;
import org.objectstyle.wolips.eomodeler.core.kvc.KeyPath;
import org.objectstyle.wolips.eomodeler.utils.TableUtils;

public class TablePropertyViewerSorter
extends ViewerSorter {
    private String[] myColumnProperties;
    private int mySortedColumn;
    private int myDirection;
    private Map myKeys;

    public TablePropertyViewerSorter(String tableName) {
        this(TableUtils.getColumnsForTableNamed(tableName));
    }

    public TablePropertyViewerSorter(String[] columnProperties) {
        this.myColumnProperties = columnProperties;
        this.myKeys = new HashMap();
        for (int keyNum = 0; keyNum < columnProperties.length; ++keyNum) {
            CachingKeyPath keyPath = new CachingKeyPath(columnProperties[keyNum]);
            this.myKeys.put(columnProperties[keyNum], keyPath);
        }
    }

    public void sort(TableViewer _viewer, String _property) {
        int matchingColumn = TableUtils._getColumnNumber(this.myColumnProperties, _property);
        if (matchingColumn != -1) {
            this.sort(_viewer, matchingColumn);
        }
    }

    public void sort(TableViewer _viewer, int _column) {
        Table table = _viewer.getTable();
        TableColumn sortColumn = table.getSortColumn();
        TableColumn selectedColumn = table.getColumn(_column);
        int direction = table.getSortDirection();
        if (sortColumn == selectedColumn) {
            direction = direction == 128 ? 1024 : 128;
        } else {
            table.setSortColumn(selectedColumn);
            direction = 128;
        }
        table.setSortDirection(direction);
        this.mySortedColumn = _column;
        this.myDirection = direction;
        _viewer.refresh();
    }

    public int compare(Viewer _viewer, Object _o1, Object _o2) {
        String property = this.myColumnProperties[this.mySortedColumn];
        Object o1 = this.getComparisonValue(_o1, property);
        Object o2 = this.getComparisonValue(_o2, property);
        int comparison = 0;
        if (o1 == null && o2 == null) {
            comparison = 0;
        } else if (o1 == null) {
            comparison = -1;
        } else if (o2 == null) {
            comparison = 1;
        } else if (o1 instanceof Boolean && o2 instanceof Boolean) {
            boolean right;
            boolean left = (Boolean)o1;
            comparison = left == (right = ((Boolean)o2).booleanValue()) ? 0 : (left ? 1 : -1);
        } else if (o1 instanceof Integer && o2 instanceof Integer) {
            comparison = ((Integer)o1).compareTo((Integer)o2);
        } else if (o1 instanceof String && o2 instanceof String) {
            comparison = this.collator.compare(o1, o2);
        }
        if (this.myDirection == 1024) {
            comparison = -comparison;
        }
        return comparison;
    }

    public Object getComparisonValue(Object _obj, String _property) {
        Object value = ((KeyPath)this.myKeys.get(_property)).getValue(_obj);
        return value;
    }
}

