/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class PluginUtils {
    public static boolean isOfType(IType _type, String _lookingForTypeName) throws JavaModelException {
        boolean isWOComponent;
        String qualifiedTypeName = _type.getFullyQualifiedName();
        if (qualifiedTypeName.equals(_lookingForTypeName)) {
            isWOComponent = true;
        } else {
            String superclassName = _type.getSuperclassName();
            if (superclassName == null) {
                isWOComponent = false;
            } else {
                String superclassQualifiedTypeName = JavaModelUtil.getResolvedTypeName((String)_type.getSuperclassTypeSignature(), (IType)_type);
                IType superclassType = _type.getJavaProject().findType(superclassQualifiedTypeName);
                isWOComponent = PluginUtils.isOfType(superclassType, _lookingForTypeName);
            }
        }
        return isWOComponent;
    }

    public static IResource findResource(IContainer _container, String _resourceName) throws CoreException {
        IResource matchingResource = null;
        IResource[] members = _container.members();
        for (int i = 0; matchingResource == null && i < members.length; ++i) {
            if (members[i].getName().equals(_resourceName)) {
                matchingResource = members[i];
                continue;
            }
            if (!(members[i] instanceof IContainer)) continue;
            matchingResource = PluginUtils.findResource((IContainer)members[i], _resourceName);
        }
        return matchingResource;
    }
}

