/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.completion;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Display;
import org.objectstyle.wolips.bindings.Activator;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;

public class WodParserCacheInvalidator
implements IResourceChangeListener,
IResourceDeltaVisitor {
    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException e) {
                Activator.getDefault().log((Throwable)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean visit(IResourceDelta delta) {
        IResource resource = delta.getResource();
        if (resource.isDerived()) {
            return false;
        }
        if (!(resource instanceof IFile)) return true;
        IFile file = (IFile)resource;
        String name = file.getName().toLowerCase();
        if (name.endsWith(".java")) {
            if (delta.getKind() == 1) return true;
            if (delta.getKind() == 2) {
                WodParserCache.getTypeCache().clearCacheForResource(resource);
                return true;
            } else {
                IJavaElement javaElement;
                if (delta.getKind() != 4 || !((javaElement = JavaCore.create((IFile)file)) instanceof ICompilationUnit)) return true;
                try {
                    IType[] types;
                    IJavaProject javaProject = javaElement.getJavaProject();
                    if (javaProject == null || !javaProject.isOnClasspath(javaElement)) return true;
                    for (IType type : types = ((ICompilationUnit)javaElement).getAllTypes()) {
                        WodParserCache.getTypeCache().clearCacheForType(type);
                    }
                    return true;
                }
                catch (JavaModelException e) {
                    Activator.getDefault().log((Object)("Failed to clear caches for " + resource + "."), (Throwable)e);
                    return true;
                }
            }
        } else if (name.endsWith(".api")) {
            IJavaProject javaProject = JavaCore.create((IProject)file.getProject());
            if (javaProject == null) return true;
            String elementName = file.getName().substring(0, file.getName().lastIndexOf(46));
            WodParserCache.getTypeCache().getApiCache(javaProject).clearCacheForElementNamed(elementName);
            return true;
        } else if (file.getParent() != null && file.getParent().getName().endsWith(".eomodeld")) {
            if (delta.getKind() == 1) {
                WodParserCache.getModelGroupCache().clearCacheForProject(file.getProject());
                return true;
            } else if (delta.getKind() == 2) {
                WodParserCache.getModelGroupCache().clearCacheForProject(file.getProject());
                return true;
            } else {
                if (delta.getKind() != 4 || (delta.getFlags() & 0x100) == 0) return true;
                WodParserCache.getModelGroupCache().clearCacheForProject(file.getProject());
            }
            return true;
        } else {
            if (file.getParent() == null || !file.getParent().getName().endsWith(".wo")) return true;
            if (delta.getKind() == 1) {
                String newComponent = file.getParent().getFullPath().removeFileExtension().lastSegment();
                final IFile oldFile = file;
                final IPath newPath = file.getParent().getFullPath().append(newComponent).addFileExtension(file.getFileExtension());
                if (file.getFileExtension().matches("(xml|html|xhtml|wod|woo)") && !file.getFullPath().equals((Object)newPath) && !newPath.toFile().exists()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (!newPath.toFile().exists()) {
                                    oldFile.move(newPath, false, null);
                                }
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                WodParserCache.invalidateResource((IResource)file.getParent());
                return true;
            } else if (delta.getKind() == 2) {
                WodParserCache.invalidateResource((IResource)file.getParent());
                return true;
            } else {
                if (delta.getKind() != 4 || (delta.getFlags() & 0x100000) == 0) return true;
                WodParserCache.invalidateResource((IResource)file.getParent());
            }
        }
        return true;
    }
}

