/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.variables.BuildProperties;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.refactoring.TemplateRefactoring;
import org.objectstyle.wolips.wodclipse.core.util.WodDocumentUtils;
import org.objectstyle.wolips.wodclipse.core.util.WodHtmlUtils;

public class DeleteTagRefactoring
implements IRunnableWithProgress {
    private BuildProperties _buildProperties;
    private FuzzyXMLElement _element;
    private WodParserCache _cache;
    private boolean _unwrap;

    public DeleteTagRefactoring(FuzzyXMLElement element, boolean unwrap, BuildProperties buildProperties, WodParserCache cache) {
        this._element = element;
        this._unwrap = unwrap;
        this._buildProperties = buildProperties;
        this._cache = cache;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        try {
            IDocument htmlDocument;
            IWodElement wodElement;
            int referenceCount = 0;
            if (WodHtmlUtils.isWOTag(this._element) && !WodHtmlUtils.isInline(this._element) && (wodElement = WodHtmlUtils.getWodElement(this._element, this._buildProperties, true, this._cache)) != null) {
                String elementName = wodElement.getElementName();
                List htmlElementNames = this._cache.getHtmlEntry().getHtmlElementCache().getHtmlElementNames(elementName);
                if (htmlElementNames != null) {
                    referenceCount = htmlElementNames.size();
                }
                if (referenceCount == 1) {
                    DeleteTagRefactoring.deleteWodElement(this._cache, wodElement);
                }
            }
            if ((htmlDocument = this._cache.getHtmlEntry().getDocument()) != null) {
                LinkedList<TextEdit> htmlEdits = new LinkedList<TextEdit>();
                if (this._unwrap && this._element.hasCloseTag()) {
                    htmlEdits.add((TextEdit)new DeleteEdit(this._element.getCloseTagOffset(), this._element.getCloseTagLength() + 2));
                    htmlEdits.add((TextEdit)new DeleteEdit(this._element.getOffset(), this._element.getOpenTagLength() + 2));
                } else {
                    htmlEdits.add((TextEdit)new DeleteEdit(this._element.getOffset(), this._element.getLength()));
                }
                WodDocumentUtils.applyEdits(htmlDocument, htmlEdits);
            }
        }
        catch (Exception e) {
            throw new InvocationTargetException(e, "Failed to refactor.");
        }
    }

    public static void deleteWodElement(WodParserCache _cache, IWodElement wodElement) throws MalformedTreeException, BadLocationException {
        IDocument wodDocument = _cache.getWodEntry().getDocument();
        if (wodDocument != null) {
            LinkedList<TextEdit> wodEdits = new LinkedList<TextEdit>();
            wodEdits.add((TextEdit)new DeleteEdit(wodElement.getStartOffset(), wodElement.getEndOffset() - wodElement.getStartOffset() + 1));
            WodDocumentUtils.applyEdits(wodDocument, wodEdits);
        }
    }

    public static void run(FuzzyXMLElement element, boolean unwrap, BuildProperties buildProperties, WodParserCache cache, IProgressMonitor progressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
        TemplateRefactoring.processHtmlAndWod(new DeleteTagRefactoring(element, unwrap, buildProperties, cache), cache, progressMonitor);
    }
}

