/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.refactoring;

import java.util.HashSet;
import java.util.Set;
import org.objectstyle.wolips.baseforplugins.util.StringUtilities;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.bindings.wod.IWodModel;

public class ElementRename {
    private String _oldName;
    private String _newName;

    public ElementRename(String oldName, String newName) {
        this._oldName = oldName;
        this._newName = newName;
    }

    public String getOldName() {
        return this._oldName;
    }

    public String getNewName() {
        return this._newName;
    }

    public static ElementRename newUniqueName(IWodModel wodModel, IWodElement wodElement, boolean forceRename) {
        return ElementRename.newUniqueName(wodModel, wodElement, new HashSet<String>(), forceRename);
    }

    public static ElementRename newUniqueName(IWodModel wodModel, IWodElement wodElement, Set<String> elementNames, boolean forceRename) {
        String typeName;
        ElementRename elementRename = null;
        String shortTypeName = typeName = wodElement.getElementType();
        if (typeName.startsWith("WO")) {
            shortTypeName = typeName.substring("WO".length());
        }
        String elementName = wodElement.getElementName();
        if (forceRename || elementName.startsWith(shortTypeName) && StringUtilities.isDigitsOnly((String)elementName.substring(shortTypeName.length()))) {
            String action;
            String value;
            String newName = null;
            boolean forceAppendNumber = false;
            if ("WOConditional".equals(typeName)) {
                String conditionValue = (String)wodElement.getBindingsMap().get("condition");
                String negateValue = (String)wodElement.getBindingsMap().get("negate");
                String prefix = null;
                if (negateValue != null && (negateValue.equalsIgnoreCase("true") || negateValue.equalsIgnoreCase("yes"))) {
                    prefix = "Not";
                }
                newName = ElementRename.newNameFromBindingValue(prefix, conditionValue, null);
            } else if ("WOString".equals(typeName)) {
                value = (String)wodElement.getBindingsMap().get("value");
                newName = ElementRename.newNameFromBindingValue(null, value, null);
            } else if ("ERXLocalizedString".equals(typeName)) {
                value = (String)wodElement.getBindingsMap().get("value");
                newName = ElementRename.newNameFromBindingValue(null, value, null);
            } else if ("WOSubmitButton".equals(typeName)) {
                action = (String)wodElement.getBindingsMap().get("action");
                newName = action != null ? ElementRename.newNameFromBindingValue(null, action + "Button", null) : "Button";
            } else if ("WOHyperlink".equals(typeName)) {
                action = (String)wodElement.getBindingsMap().get("action");
                newName = action != null ? ElementRename.newNameFromBindingValue(null, action + "Link", null) : "Link";
            } else if ("WORepetition".equals(typeName)) {
                String list = (String)wodElement.getBindingsMap().get("list");
                newName = ElementRename.newNameFromBindingValue(null, list, null);
            } else if ("WOGenericContainer".equals(typeName) || "WOGenericElement".equals(typeName)) {
                String genericElementName = (String)wodElement.getBindingsMap().get("elementName");
                newName = ElementRename.newNameFromBindingValue(null, genericElementName, null);
                forceAppendNumber = true;
            } else if (forceRename) {
                newName = typeName;
            }
            if (newName != null) {
                String uniqueNewName = newName;
                int counter = 1;
                while (counter == 1 && forceAppendNumber || wodModel.getElementNamed(uniqueNewName) != null || elementNames.contains(uniqueNewName)) {
                    uniqueNewName = newName + String.valueOf(counter++);
                }
                elementRename = new ElementRename(elementName, uniqueNewName);
                elementNames.add(uniqueNewName);
            }
        }
        return elementRename;
    }

    public static String newNameFromBindingValue(String prefix, String value, String suffix) {
        String newName = null;
        if (value != null && !value.startsWith("\"~")) {
            value = value.replaceAll(" ", "_");
            value = value.replaceAll("[\"^]", "");
            value = value.replaceAll("[@,]", ".");
            String[] keys = value.split("\\.");
            StringBuffer newNameBuffer = new StringBuffer();
            if (prefix != null) {
                newNameBuffer.append(prefix);
            }
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i].length() <= 0) continue;
                newNameBuffer.append(keys[i].substring(0, 1).toUpperCase());
                newNameBuffer.append(keys[i].substring(1));
            }
            if (suffix != null) {
                newNameBuffer.append(suffix);
            }
            newName = newNameBuffer.toString();
        }
        return newName;
    }
}

