/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.TextEdit;
import org.objectstyle.wolips.bindings.wod.IWodBinding;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.refactoring.TemplateRefactoring;
import org.objectstyle.wolips.wodclipse.core.util.WodDocumentUtils;

public class RemoveBindingRefactoring
implements IRunnableWithProgress {
    private IWodElement _element;
    private IWodBinding _binding;
    private WodParserCache _cache;

    public RemoveBindingRefactoring(IWodElement element, IWodBinding binding, WodParserCache cache) {
        this._element = element;
        this._binding = binding;
        this._cache = cache;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        try {
            this._cache.clearCache();
            Position valuePosition = this._binding.getValuePosition();
            if (valuePosition != null) {
                int startOffset = this._binding.getStartOffset();
                int endOffset = this._binding.getEndOffset();
                if (this._element.isInline()) {
                    IDocument htmlDocument = this._cache.getHtmlEntry().getDocument();
                    if (htmlDocument != null) {
                        LinkedList<TextEdit> htmlEdits = new LinkedList<TextEdit>();
                        htmlEdits.add((TextEdit)new DeleteEdit(startOffset - 1, endOffset - startOffset + 2));
                        WodDocumentUtils.applyEdits(htmlDocument, htmlEdits);
                    }
                } else {
                    IDocument wodDocument = this._cache.getWodEntry().getDocument();
                    if (wodDocument != null) {
                        LinkedList<TextEdit> wodEdits = new LinkedList<TextEdit>();
                        wodEdits.add((TextEdit)new DeleteEdit(startOffset, endOffset - startOffset + 1));
                        WodDocumentUtils.applyEdits(wodDocument, wodEdits);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new InvocationTargetException(e, "Failed to refactor.");
        }
    }

    public static void run(IWodElement element, IWodBinding binding, WodParserCache cache, IProgressMonitor progressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
        TemplateRefactoring.processHtmlAndWod(new RemoveBindingRefactoring(element, binding, cache), cache, progressMonitor);
    }
}

