/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.core.resources.internal.build;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.objectstyle.wolips.core.resources.builder.IBuilder;
import org.objectstyle.wolips.core.resources.builder.IIncrementalBuilder;
import org.objectstyle.wolips.core.resources.internal.build.AbstractBuildVisitor;
import org.objectstyle.wolips.core.resources.internal.build.BuilderWrapper;

public class IncrementalBuildDeltaVisitor
extends AbstractBuildVisitor
implements IResourceDeltaVisitor {
    public IncrementalBuildDeltaVisitor(BuilderWrapper[] builderWrappers, IProgressMonitor progressMonitor, Map buildCache) {
        super(builderWrappers, progressMonitor, buildCache);
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (delta == null || this.isCanceled()) {
            return false;
        }
        IResource resource = delta.getResource();
        if (resource.isDerived()) {
            return false;
        }
        IProgressMonitor progressMonitor = this.getProgressMonitor();
        Map buildCache = this.getBuildCache();
        int woResourceType = this.getWoResourceType(resource);
        if (woResourceType == AbstractBuildVisitor.WO_RESOURCE_TYPE_CLASS) {
            this.notifyBuilderHandleClassesDelta(delta, progressMonitor, buildCache);
        } else if (woResourceType == AbstractBuildVisitor.WO_RESOURCE_TYPE_CLASSPATH) {
            this.notifyBuilderHandleOtherDelta(delta, progressMonitor, buildCache);
            this.notifyBuilderClasspathChanged(delta, progressMonitor, buildCache);
        } else if (woResourceType != AbstractBuildVisitor.WO_RESOURCE_TYPE_IGNORE) {
            if (woResourceType == AbstractBuildVisitor.WO_RESOURCE_TYPE_OTHER) {
                this.notifyBuilderHandleOtherDelta(delta, progressMonitor, buildCache);
            } else if (woResourceType == AbstractBuildVisitor.WO_RESOURCE_TYPE_RESOURCE) {
                this.notifyBuilderHandleResourcesDelta(delta, progressMonitor, buildCache);
            } else if (woResourceType == AbstractBuildVisitor.WO_RESOURCE_TYPE_SOURCE) {
                this.notifyBuilderHandleSourceDelta(delta, progressMonitor, buildCache);
            } else if (woResourceType == AbstractBuildVisitor.WO_RESOURCE_TYPE_WEB_SERVER_RESOURCE) {
                this.notifyBuilderHandleWebServerResourcesDelta(delta, progressMonitor, buildCache);
            }
        }
        return true;
    }

    private void notifyBuilderClasspathChanged(IResourceDelta delta, IProgressMonitor progressMonitor, Map buildCache) {
        BuilderWrapper[] builderWrappers = this.getBuilderWrappers();
        for (int i = 0; i < builderWrappers.length; ++i) {
            IBuilder builder = builderWrappers[i].getBuilder();
            if (!builder.isEnabled() || !(builder instanceof IIncrementalBuilder)) continue;
            ((IIncrementalBuilder)builder).classpathChanged(delta, progressMonitor, buildCache);
        }
    }

    private void notifyBuilderHandleClassesDelta(IResourceDelta delta, IProgressMonitor progressMonitor, Map buildCache) {
        BuilderWrapper[] builderWrappers = this.getBuilderWrappers();
        for (int i = 0; i < builderWrappers.length; ++i) {
            IBuilder builder = builderWrappers[i].getBuilder();
            if (!builder.isEnabled() || !(builder instanceof IIncrementalBuilder)) continue;
            ((IIncrementalBuilder)builder).handleClassesDelta(delta, progressMonitor, buildCache);
        }
    }

    private void notifyBuilderHandleResourcesDelta(IResourceDelta delta, IProgressMonitor progressMonitor, Map buildCache) {
        BuilderWrapper[] builderWrappers = this.getBuilderWrappers();
        for (int i = 0; i < builderWrappers.length; ++i) {
            IBuilder builder = builderWrappers[i].getBuilder();
            if (!builder.isEnabled() || !(builder instanceof IIncrementalBuilder)) continue;
            ((IIncrementalBuilder)builder).handleWoappResourcesDelta(delta, progressMonitor, buildCache);
        }
    }

    private void notifyBuilderHandleSourceDelta(IResourceDelta delta, IProgressMonitor progressMonitor, Map buildCache) {
        BuilderWrapper[] builderWrappers = this.getBuilderWrappers();
        for (int i = 0; i < builderWrappers.length; ++i) {
            IBuilder builder = builderWrappers[i].getBuilder();
            if (!builder.isEnabled() || !(builder instanceof IIncrementalBuilder)) continue;
            ((IIncrementalBuilder)builder).handleSourceDelta(delta, progressMonitor, buildCache);
        }
    }

    private void notifyBuilderHandleWebServerResourcesDelta(IResourceDelta delta, IProgressMonitor progressMonitor, Map buildCache) {
        BuilderWrapper[] builderWrappers = this.getBuilderWrappers();
        for (int i = 0; i < builderWrappers.length; ++i) {
            IBuilder builder = builderWrappers[i].getBuilder();
            if (!builder.isEnabled() || !(builder instanceof IIncrementalBuilder)) continue;
            ((IIncrementalBuilder)builder).handleWebServerResourcesDelta(delta, progressMonitor, buildCache);
        }
    }

    private void notifyBuilderHandleOtherDelta(IResourceDelta delta, IProgressMonitor progressMonitor, Map buildCache) {
        BuilderWrapper[] builderWrappers = this.getBuilderWrappers();
        for (int i = 0; i < builderWrappers.length; ++i) {
            IBuilder builder = builderWrappers[i].getBuilder();
            if (!builder.isEnabled() || !(builder instanceof IIncrementalBuilder)) continue;
            ((IIncrementalBuilder)builder).handleOtherDelta(delta, progressMonitor, buildCache);
        }
    }
}

