/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.core.resources.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeHierarchyChangedListener;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.objectstyle.wolips.baseforplugins.util.LRUMap;

public class SuperTypeHierarchyCache {
    private static final int CACHE_SIZE = 100;
    private static ArrayList<HierarchyCacheEntry> fgHierarchyCache = new ArrayList(100);
    protected static Map<IType, MethodOverrideTester> fgMethodOverrideTesterCache = new LRUMap(100);
    protected static int fgCacheHits = 0;
    protected static int fgCacheMisses = 0;

    public static ITypeHierarchy getTypeHierarchy(IType type) throws JavaModelException {
        return SuperTypeHierarchyCache.getTypeHierarchy(type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MethodOverrideTester getMethodOverrideTester(IType type) throws JavaModelException {
        MethodOverrideTester test = null;
        Map<IType, MethodOverrideTester> map = fgMethodOverrideTesterCache;
        synchronized (map) {
            test = fgMethodOverrideTesterCache.get(type);
        }
        if (test == null) {
            ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy(type);
            Map<IType, MethodOverrideTester> map2 = fgMethodOverrideTesterCache;
            synchronized (map2) {
                test = fgMethodOverrideTesterCache.get(type);
                if (test == null) {
                    test = new MethodOverrideTester(type, hierarchy);
                    fgMethodOverrideTesterCache.put(type, test);
                }
            }
        }
        return test;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeMethodOverrideTester(ITypeHierarchy hierarchy) {
        Map<IType, MethodOverrideTester> map = fgMethodOverrideTesterCache;
        synchronized (map) {
            Iterator<MethodOverrideTester> iter = fgMethodOverrideTesterCache.values().iterator();
            while (iter.hasNext()) {
                MethodOverrideTester curr = iter.next();
                if (!curr.getTypeHierarchy().equals(hierarchy)) continue;
                iter.remove();
            }
        }
    }

    public static ITypeHierarchy getTypeHierarchy(IType type, IProgressMonitor progressMonitor) throws JavaModelException {
        ITypeHierarchy hierarchy = SuperTypeHierarchyCache.findTypeHierarchyInCache(type);
        if (hierarchy == null) {
            ++fgCacheMisses;
            hierarchy = type.newSupertypeHierarchy(progressMonitor);
            SuperTypeHierarchyCache.addTypeHierarchyToCache(hierarchy);
        } else {
            ++fgCacheHits;
        }
        return hierarchy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addTypeHierarchyToCache(ITypeHierarchy hierarchy) {
        ArrayList<HierarchyCacheEntry> arrayList = fgHierarchyCache;
        synchronized (arrayList) {
            int nEntries = fgHierarchyCache.size();
            if (nEntries >= 100) {
                int i;
                HierarchyCacheEntry oldest = null;
                ArrayList<HierarchyCacheEntry> obsoleteHierarchies = new ArrayList<HierarchyCacheEntry>(100);
                for (i = 0; i < nEntries; ++i) {
                    HierarchyCacheEntry entry = fgHierarchyCache.get(i);
                    ITypeHierarchy curr = entry.getTypeHierarchy();
                    if (!curr.exists() || hierarchy.contains(curr.getType())) {
                        obsoleteHierarchies.add(entry);
                        continue;
                    }
                    if (oldest != null && entry.getLastAccess() >= oldest.getLastAccess()) continue;
                    oldest = entry;
                }
                if (!obsoleteHierarchies.isEmpty()) {
                    for (i = 0; i < obsoleteHierarchies.size(); ++i) {
                        SuperTypeHierarchyCache.removeHierarchyEntryFromCache((HierarchyCacheEntry)obsoleteHierarchies.get(i));
                    }
                } else if (oldest != null) {
                    SuperTypeHierarchyCache.removeHierarchyEntryFromCache(oldest);
                }
            }
            HierarchyCacheEntry newEntry = new HierarchyCacheEntry(hierarchy);
            fgHierarchyCache.add(newEntry);
        }
    }

    public static boolean hasInCache(IType type) {
        return SuperTypeHierarchyCache.findTypeHierarchyInCache(type) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ITypeHierarchy findTypeHierarchyInCache(IType type) {
        ArrayList<HierarchyCacheEntry> arrayList = fgHierarchyCache;
        synchronized (arrayList) {
            for (int i = fgHierarchyCache.size() - 1; i >= 0; --i) {
                HierarchyCacheEntry curr = fgHierarchyCache.get(i);
                ITypeHierarchy hierarchy = curr.getTypeHierarchy();
                if (!hierarchy.exists()) {
                    SuperTypeHierarchyCache.removeHierarchyEntryFromCache(curr);
                    continue;
                }
                if (!hierarchy.contains(type)) continue;
                curr.markAsAccessed();
                return hierarchy;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeHierarchyEntryFromCache(HierarchyCacheEntry entry) {
        ArrayList<HierarchyCacheEntry> arrayList = fgHierarchyCache;
        synchronized (arrayList) {
            SuperTypeHierarchyCache.removeMethodOverrideTester(entry.getTypeHierarchy());
            entry.dispose();
            fgHierarchyCache.remove(entry);
        }
    }

    public static int getCacheHits() {
        return fgCacheHits;
    }

    public static int getCacheMisses() {
        return fgCacheMisses;
    }

    private static class HierarchyCacheEntry
    implements ITypeHierarchyChangedListener {
        private ITypeHierarchy fTypeHierarchy;
        private long fLastAccess;

        public HierarchyCacheEntry(ITypeHierarchy hierarchy) {
            this.fTypeHierarchy = hierarchy;
            this.fTypeHierarchy.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            this.markAsAccessed();
        }

        public void typeHierarchyChanged(ITypeHierarchy typeHierarchy) {
            SuperTypeHierarchyCache.removeHierarchyEntryFromCache(this);
        }

        public ITypeHierarchy getTypeHierarchy() {
            return this.fTypeHierarchy;
        }

        public void markAsAccessed() {
            this.fLastAccess = System.currentTimeMillis();
        }

        public long getLastAccess() {
            return this.fLastAccess;
        }

        public void dispose() {
            this.fTypeHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            this.fTypeHierarchy = null;
        }

        public String toString() {
            return "Super hierarchy of: " + this.fTypeHierarchy.getType().getElementName();
        }
    }
}

