/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.womodeler.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.objectstyle.wolips.womodeler.server.IRequestHandler;
import org.objectstyle.wolips.womodeler.server.Request;

public class Webserver
implements Runnable {
    private static final String DEFAULT_REQUEST_HANDLER = "___DEFAULT___";
    private boolean _running;
    private ServerSocket _serverSocket;
    private int _port;
    private Map<String, IRequestHandler> _pathToRequestHandler;

    public Webserver(int port) {
        this._port = port;
        this._pathToRequestHandler = new HashMap<String, IRequestHandler>();
    }

    public void addRequestHandler(String path, IRequestHandler requestHandler) {
        this._pathToRequestHandler.put(path, requestHandler);
    }

    public void removeRequestHandler(String path) {
        this._pathToRequestHandler.remove(path);
    }

    public InetAddress getHostAddress() throws IOException {
        return InetAddress.getLocalHost();
    }

    public int getPort() {
        return this._port;
    }

    public synchronized void start(boolean daemon) {
        if (!this._running) {
            this._running = true;
            Thread serverThread = new Thread((Runnable)this, "WOLips Server");
            serverThread.setDaemon(daemon);
            serverThread.start();
        }
    }

    public synchronized void stop() {
        try {
            if (this._serverSocket != null) {
                this._serverSocket.close();
            }
            this._running = false;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            for (IRequestHandler requestHandler : this._pathToRequestHandler.values()) {
                requestHandler.init(this);
            }
            this._serverSocket = new ServerSocket(this._port);
            while (this._running) {
                try {
                    Socket requestSock = this._serverSocket.accept();
                    Request req = new Request(this, requestSock);
                    Thread requestThread = new Thread((Runnable)req, "WOLips Server Request");
                    requestThread.start();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public IRequestHandler getHandler(Request request) {
        String path = request.getPath();
        IRequestHandler requestHandler = this._pathToRequestHandler.get(path);
        if (requestHandler == null) {
            requestHandler = this._pathToRequestHandler.get(DEFAULT_REQUEST_HANDLER);
        }
        return requestHandler;
    }
}

