/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.components.editor;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.objectstyle.wolips.components.editor.IComponentEditor;
import org.objectstyle.wolips.components.editor.IHtmlDocumentProvider;
import org.objectstyle.wolips.components.editor.IWebobjectTagListener;
import org.objectstyle.wolips.components.editor.IWodDocumentProvider;

public class ComponentEditorInteraction {
    private Set<IWebobjectTagListener> _webObjectTagListeners = new HashSet<IWebobjectTagListener>();
    private IHtmlDocumentProvider _htmlDocumentProvider;
    private IWodDocumentProvider _wodDocumentProvider;
    private IComponentEditor _componentEditor;

    public void setComponentEditor(IComponentEditor componentEditor) {
        this._componentEditor = componentEditor;
    }

    public IComponentEditor getComponentEditor() {
        return this._componentEditor;
    }

    public boolean embeddedEditorWillSave(IProgressMonitor progressMonitor) {
        return this._componentEditor.embeddedEditorWillSave(progressMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWebObjectTagListener(IWebobjectTagListener webobjectTagListener) {
        Set<IWebobjectTagListener> set = this._webObjectTagListeners;
        synchronized (set) {
            this._webObjectTagListeners.add(webobjectTagListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWebObjectTagListener(IWebobjectTagListener webobjectTagListener) {
        Set<IWebobjectTagListener> set = this._webObjectTagListeners;
        synchronized (set) {
            this._webObjectTagListeners.remove(webobjectTagListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireWebObjectChanged() {
        Set<IWebobjectTagListener> set = this._webObjectTagListeners;
        synchronized (set) {
            for (IWebobjectTagListener webObjectTagListener : this._webObjectTagListeners) {
                webObjectTagListener.webObjectChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireWebObjectTagSelected(String name) {
        Set<IWebobjectTagListener> set = this._webObjectTagListeners;
        synchronized (set) {
            for (IWebobjectTagListener webObjectTagListener : this._webObjectTagListeners) {
                webObjectTagListener.webObjectTagSelected(name);
            }
        }
    }

    public IHtmlDocumentProvider getHtmlDocumentProvider() {
        return this._htmlDocumentProvider;
    }

    public void setHtmlDocumentProvider(IHtmlDocumentProvider htmlDocumentProvider) {
        this._htmlDocumentProvider = htmlDocumentProvider;
    }

    public IWodDocumentProvider getWodDocumentProvider() {
        return this._wodDocumentProvider;
    }

    public void setWodDocumentProvider(IWodDocumentProvider wodDocumentProvider) {
        this._wodDocumentProvider = wodDocumentProvider;
    }
}

